### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
from minknow_api.statistics_pb2_grpc import *
import minknow_api.statistics_pb2 as statistics_pb2
from minknow_api.statistics_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "StatisticsService",
    "DataSelection",
    "StreamDutyTimeRequest",
    "StreamDutyTimeResponse",
    "ReadLengthHistogramKey",
    "ReadLengthHistogramSplit",
    "StreamReadLengthHistogramRequest",
    "StreamReadLengthHistogramResponse",
    "GetReadLengthTypesRequest",
    "GetReadLengthTypesResponse",
    "AcquisitionOutputKey",
    "AcquisitionOutputSplit",
    "StreamAcquisitionOutputRequest",
    "AcquisitionOutputBucket",
    "StreamAcquisitionOutputResponse",
    "StreamWriterOutputRequest",
    "WriterOutputBucket",
    "StreamWriterOutputResponse",
    "StreamEncounteredAcquisitionOutputKeysRequest",
    "StreamEncounteredAcquisitionOutputKeysResponse",
    "StreamTemperatureRequest",
    "TemperaturePacket",
    "StreamTemperatureResponse",
    "BiasVoltagePacket",
    "StreamBiasVoltagesRequest",
    "StreamBiasVoltagesResponse",
    "StreamBoxplotRequest",
    "BoxplotResponse",
    "ReadLengthType",
    "MinknowEvents",
    "EstimatedBases",
    "BasecalledBases",
    "BucketValueType",
    "ReadCounts",
    "ReadLengths",
    "ReadEndReason",
    "All",
    "Unknown",
    "Partial",
    "MuxChange",
    "UnblockMuxChange",
    "SignalPositive",
    "SignalNegative",
    "DataServiceUnblockMuxChange",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class StatisticsService(object):
    def __init__(self, channel):
        self._stub = StatisticsServiceStub(channel)
        self._pb = statistics_pb2
    def stream_duty_time(self, _message=None, _timeout=None, **kwargs):
        """Tracks how much time has been spent in each channel state, aggregated across all the channels

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamDutyTimeRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The acquisition id of the experiment.
            data_selection (minknow_api.statistics_pb2.DataSelection, optional): The desired data selection.

                The units for all values are `seconds since the start of the experiment`.

        Returns:
            iter of minknow_api.statistics_pb2.StreamDutyTimeResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_duty_time,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamDutyTimeRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_duty_time requires a 'acquisition_run_id' argument")

        if "data_selection" in kwargs:
            unused_args.remove("data_selection")
            _message.data_selection.CopyFrom(kwargs['data_selection'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_duty_time: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_duty_time,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def stream_acquisition_output(self, _message=None, _timeout=None, **kwargs):
        """Tracks experiment output across various filters over time.

        The first response will give you all the data it can, and continue to provide updates
        if the acquisition period remains live.

        The stream will end once the current acquisition period ends, and a caller will need to
        reinvoke the rpc in order to get new data.

        Since 1.14

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamAcquisitionOutputRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The acquisition id of the experiment.
            data_selection (minknow_api.statistics_pb2.DataSelection, optional): The desired data selection.

                The units for all values are `seconds since the start of the experiment`.
            filtering (minknow_api.statistics_pb2.AcquisitionOutputKey, optional): Define filtering parameters for streamed data.
            split (minknow_api.statistics_pb2.AcquisitionOutputSplit, optional): Define how results are split for returned data.

        Returns:
            iter of minknow_api.statistics_pb2.StreamAcquisitionOutputResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_acquisition_output,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamAcquisitionOutputRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_acquisition_output requires a 'acquisition_run_id' argument")

        if "data_selection" in kwargs:
            unused_args.remove("data_selection")
            _message.data_selection.CopyFrom(kwargs['data_selection'])

        if "filtering" in kwargs:
            unused_args.remove("filtering")
            _message.filtering.extend(kwargs['filtering'])

        if "split" in kwargs:
            unused_args.remove("split")
            _message.split.CopyFrom(kwargs['split'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_acquisition_output: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_acquisition_output,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def stream_writer_output(self, _message=None, _timeout=None, **kwargs):
        """Tracks experiment writes across all channels over time

        The first response will give you all the data it can.

        The stream will end once the current acquisition period ends, and a caller will need to
        reinvoke the rpc in order to get new data.

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamWriterOutputRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The acquisition id of the experiment.
            data_selection (minknow_api.statistics_pb2.DataSelection, optional): The desired data selection.

                The units for all values are `seconds since the start of the experiment`.

        Returns:
            iter of minknow_api.statistics_pb2.StreamWriterOutputResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_writer_output,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamWriterOutputRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_writer_output requires a 'acquisition_run_id' argument")

        if "data_selection" in kwargs:
            unused_args.remove("data_selection")
            _message.data_selection.CopyFrom(kwargs['data_selection'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_writer_output: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_writer_output,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def stream_encountered_acquisition_output_keys(self, _message=None, _timeout=None, **kwargs):
        """Tracks which barcode names have been encountered

        When a new barcode name is encountered, a list of all encountered barcode names is returned

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamEncounteredAcquisitionOutputKeysRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The acquisition id of the experiment.

        Returns:
            iter of minknow_api.statistics_pb2.StreamEncounteredAcquisitionOutputKeysResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_encountered_acquisition_output_keys,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamEncounteredAcquisitionOutputKeysRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_encountered_acquisition_output_keys requires a 'acquisition_run_id' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_encountered_acquisition_output_keys: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_encountered_acquisition_output_keys,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def stream_temperature(self, _message=None, _timeout=None, **kwargs):
        """Streams device temperature for a device. The first message will contain all of the temperatures up
        until the current live point, and then messages after that point will just be updates.

        Temperatures are averaged over a 1 minute period, and the value of each bucket is given in minute intervals

        Since 3.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamTemperatureRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The acquisition id of the experiment.
            data_selection (minknow_api.statistics_pb2.DataSelection, optional): The desired data selection.

                The units for all values are `seconds since the start of the experiment`.

        Returns:
            iter of minknow_api.statistics_pb2.StreamTemperatureResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_temperature,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamTemperatureRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_temperature requires a 'acquisition_run_id' argument")

        if "data_selection" in kwargs:
            unused_args.remove("data_selection")
            _message.data_selection.CopyFrom(kwargs['data_selection'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_temperature: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_temperature,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def stream_bias_voltages(self, _message=None, _timeout=None, **kwargs):
        """Streams when bias voltage changes occur, where the response given will be the acquisition
        index that the voltage changed at, and the voltage itself. The first message will contain
        all of the bias voltage changes up until the current live point, and then messages after
        that period will just be updates

        Will fail with INVALID_ARGUMENT if an unknown acquisition id is given

        Since 3.2

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamBiasVoltagesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The acquisition id of the experiment.

        Returns:
            iter of minknow_api.statistics_pb2.StreamBiasVoltagesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_bias_voltages,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamBiasVoltagesRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_bias_voltages requires a 'acquisition_run_id' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_bias_voltages: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_bias_voltages,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def stream_read_length_histogram(self, _message=None, _timeout=None, **kwargs):
        """A histogram of read lengths

        If the experiment is in-progress, then the latest histogram is streamed on a regular basis
        If the experiment is complete, then the final histogram is returned

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamReadLengthHistogramRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The `acquisition_run_id` of the acquisition to obtain data for

                If this is set to the `acquisition_run_id` of an acquisition which is in-progress, then
                updates containing the latest histogram data for that acquisition will be streamed regularly
                until that acquisition finishes (see `poll_time_seconds` below)

                Otherwise, if this is set to the `acquisition_run_id` of an acquisition which is finished,
                and for which final histogram data is available, then the final histogram data for that
                acquisition will be returned.  Final histogram data is available until it is cleared.

                Otherwise, if this parameter is not set, or is set to a value which is neither the
                `acquisition_run_id` of an acquisition which is in-progress, nor the `acquisition_run_id` of
                an acquisition for which final histogram data is available, then this call will fail with the
                status `INVALID_ARGUMENT`.
            poll_time_seconds (int, optional): How often to return new histogram data, in seconds

                If not specified, or set to `0`, then the poll time will be set to 60 seconds

                If data is being returned for an acquisition which is in progress, then one update will be
                sent when the call is first performed, then subsequently every `poll_time` after that, and
                then finally once again when the acquisition finishes.

                Otherwise, if final histogram data is being returned for an acquisition that has already
                finished, this parameter has no effect.  The final histogram data will be returned, and the
                call will complete.
            read_length_type (minknow_api.statistics_pb2.ReadLengthType, optional): The source of the read lengths in the histogram

                If MinKNOW is unable to supply data from the requested source (e.g. if the user requests
                BasecalledBases, but basecalling is not enabled), then this call will fail with the status
                `FAILED_PRECONDITION`.

                See `ReadLengthType` for further information about the available options.
            data_selection (minknow_api.statistics_pb2.DataSelection, optional): The desired read length range which histograms should cover.
                Units are as set in `read_length_type`, above.
            bucket_value_type (minknow_api.statistics_pb2.BucketValueType, optional): What data to accumulate in the read length histogram buckets

                See `BucketValueType` for further information about the available options.
            discard_outlier_percent (float, optional): If set greater than zero then discard some percent of data at the upper end of the source
                data before producing histograms and N50 values.

                This is intended to assist in the case where a small number of outliers with very long read
                lengths cause the histogram axes and N50 to be skewed.

                Defaults to 0 - no data discarded.
                Values should be specified in percent - a value of 0.05 will cause the top 5% of the data
                to be discarded before producing outputs.

                For histograms, the data discarded depends on the bucket_value_type.  If `ReadCounts`, then
                a percentage of the total number of reads reads will be discarded; if `ReadLengths` then a
                percentage of the total read lengths will be discarded.

                For the N50 value, `discard_outlier_percent` always causes a percentage of the total
                read lengths to be discarded (since it is always calculated from read length data)
            filtering (minknow_api.statistics_pb2.ReadLengthHistogramKey, optional): Define filtering parameters for streamed data.
            split (minknow_api.statistics_pb2.ReadLengthHistogramSplit, optional): Define how results are split for returned data.

        Returns:
            iter of minknow_api.statistics_pb2.StreamReadLengthHistogramResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_read_length_histogram,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamReadLengthHistogramRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_read_length_histogram requires a 'acquisition_run_id' argument")

        if "poll_time_seconds" in kwargs:
            unused_args.remove("poll_time_seconds")
            _message.poll_time_seconds = kwargs['poll_time_seconds']

        if "read_length_type" in kwargs:
            unused_args.remove("read_length_type")
            _message.read_length_type = kwargs['read_length_type']

        if "data_selection" in kwargs:
            unused_args.remove("data_selection")
            _message.data_selection.CopyFrom(kwargs['data_selection'])

        if "bucket_value_type" in kwargs:
            unused_args.remove("bucket_value_type")
            _message.bucket_value_type = kwargs['bucket_value_type']

        if "discard_outlier_percent" in kwargs:
            unused_args.remove("discard_outlier_percent")
            _message.discard_outlier_percent = kwargs['discard_outlier_percent']

        if "filtering" in kwargs:
            unused_args.remove("filtering")
            _message.filtering.extend(kwargs['filtering'])

        if "split" in kwargs:
            unused_args.remove("split")
            _message.split.CopyFrom(kwargs['split'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_read_length_histogram: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_read_length_histogram,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def get_read_length_types(self, _message=None, _timeout=None, **kwargs):
        """Gets a list of the types of read-length values for which a histogram is available

        Since 3.2

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.GetReadLengthTypesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            acquisition_run_id (str): The acquisition id of the experiment.

        Returns:
            minknow_api.statistics_pb2.GetReadLengthTypesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_read_length_types,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = GetReadLengthTypesRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("get_read_length_types requires a 'acquisition_run_id' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_read_length_types: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_read_length_types,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
    def stream_basecall_boxplots(self, _message=None, _timeout=None, **kwargs):
        """Returns the qscore over time metric represented as datasets (i.e. boxplots).

        These metrics apply to all the successfully called reads.

        A dataset is a collection of quantiles (min, max, q50 etc - please see BoxplotDataset) recorded for
        a fixed period of time, say dt. dt is specified in the configs, and it defaults to 10 min.

        When acquisition starts, MinKNOW accumulates these stats for each dt interval. Each dt generates
        a dataset streamed by this rpc. The stream can request aggregated stats by averaging the stats from
        consecutive dt periods.

        Notes:

        Each streamed message will return ALL the datasets (i.e. boxplots) from the start of the experiment.

        When using this rpc, basecalling needs to be enabled.

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.statistics_pb2.StreamBoxplotRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            acquisition_run_id (str): The acquisition id of the experiment.
            data_type (minknow_api.statistics_pb2.StreamBoxplotRequest.BoxplotType, optional): Type of boxplot data to return.
            dataset_width (int, optional): Defines, in minutes, the width of each dataset.
                This is how much time should each dataset (boxplot) cover. Note that MinKNOW stores
                all stats at a default granularity (specified in the config file, i.e. 10 min in MinKNOW 3.2).
                This dataset_width HAS to be a multiple of the default granularity!

                Note:
                When multiple buckets are aggregated into a single dataset, the resulting dataset will
                contain the average of the aggregated quantiles (with the exception of min/max)! This is not the
                same as using a larger granularity in MinKNOW configs - the values that MinKNOW stores
                are the true quantiles. Averaging quantiles will give a rough approximation, but not a quantile.
                If the finest granularity is not required, we strongly suggest changing the time coverage in the config,
                not the dataset_width in the rpc.
            poll_time (int, optional): How often to return messages in this stream, specified in seconds. Note that this stream will
                return results regardless of the stats updates (because it always returns all the datasets).
                poll_time should be larger than the basecalled stats update rate in MinKNOW -
                please see basecalled_stats_refresh_rate_seconds in the configs
                (set to 1 second in MinKNOW 3.2).

                If unspecified, defaults to 1 minute.

        Returns:
            iter of minknow_api.statistics_pb2.BoxplotResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_basecall_boxplots,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.statistics.StatisticsService")

        unused_args = set(kwargs.keys())

        _message = StreamBoxplotRequest()

        if "acquisition_run_id" in kwargs:
            unused_args.remove("acquisition_run_id")
            _message.acquisition_run_id = kwargs['acquisition_run_id']
        else:
            raise ArgumentError("stream_basecall_boxplots requires a 'acquisition_run_id' argument")

        if "data_type" in kwargs:
            unused_args.remove("data_type")
            _message.data_type = kwargs['data_type']

        if "dataset_width" in kwargs:
            unused_args.remove("dataset_width")
            _message.dataset_width = kwargs['dataset_width']

        if "poll_time" in kwargs:
            unused_args.remove("poll_time")
            _message.poll_time = kwargs['poll_time']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_basecall_boxplots: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_basecall_boxplots,
                              _message, _timeout,
                              [],
                              "minknow_api.statistics.StatisticsService")
