#!/usr/bin/env python
# flake8: noqa: E402

"""
A simple update tester for IRRd.
Sends random !g queries.
"""
import argparse
import random
import socket
import time


def main(host, port, count):
    queries = [b"!!\n"]
    for i in range(count):
        asn = random.randrange(1, 50000)
        query = f"!gAS{asn}\n".encode("ascii")
        queries.append(query)
    queries.append(b"!q\n")

    s = socket.socket()
    s.settimeout(600)
    s.connect((host, port))

    queries = b"""!!
!aAS-10021ARCSTAR
!aAS-10099NTT
!aAS-10204
!aAS-11114
!aAS-131248-CUST
!aAS-132132-TRANSIT
!aAS-132876
!aAS-133045-TRANSIT
!aAS-134842
!aAS-135377
!aAS-16524
!aAS-17534
!aAS-17666
!aAS-17958
!aAS-18149ARCSTAR
!aAS-18683-MWFN-TRANSIT
!aAS-19016
!aAS-19303
!aAS-1AND1
!aAS-20264
!aAS-20394-CUSTOMERS
!aAS-21VIANET
!aAS-23655-ALL
!aAS-24413
!aAS-2500-2914
!aAS-25766-DOWNSTREAM
!aAS-26167
!aAS-29802
!aAS-30517-ASSOCIATED
!aAS-30640
!aAS-31515ARCSTAR
!aAS-33606
!aAS-35916-TRANSIT
!aAS-38566
!aAS-395412-TRANSIT
!aAS-395662
!aAS-3TCOM
!aAS-3W-INFRA
!aAS-40676
!aAS-45903
!aAS-46043
!aAS-4628
!aAS-46475
!aAS-4648-Customers
!aAS-46652
!aAS-46844
!aAS-4693ARCSTAR
!aAS-4761
!aAS-48196
!aAS-4D-DC
!aAS-50010
!aAS-5009
!aAS-52551
!aAS-55532ARCSTAR
!aAS-55805
!aAS-55967
!aAS-5713
!aAS-57344
!aAS-58463
!aAS-58682
!aAS-59318-AS-KH
!aAS-60917
!aAS-61832-clientes
!aAS-62833-ny4
!aAS-63916
!aAS-7552
!aAS-7562
!aAS-9268ARCSTAR
!aAS-9381
!aAS-9416-TRANSIT
!aAS-9908VERIO
!aAS-9929ARCSTAR
!aAS-A2B
!aAS-AA
!aAS-AAMRA-ATL-BD
!aAS-ACCELERATED
!aAS-ACCESSFORALL
!aAS-ACCRETIVE
!aAS-ACESSO10
!aAS-ACORUS
!aAS-ADAM-EU
!aAS-ADAMOEU
!aAS-ADAMS
!aAS-ADHOST-PEERING
!aAS-ADNC-SAN
!aAS-ADNET
!aAS-ADNET-DC
!aAS-ADNET-DC6
!aAS-ADNET6
!aAS-AEG
!aAS-AFILIAS-FULLMONTY
!aAS-AGARTO
!aAS-AGARTO6
!aAS-AGILIT
!aAS-AGODA
!aAS-AI
!aAS-AIE
!aAS-AIRBANDUK
!aAS-AIRBANDUK-IPV6
!aAS-AIRWIRE
!aAS-AKAMAI
!aAS-ALCOM
!aAS-ALHAMBRA
!aAS-ALLIED_TELECOM
!aAS-ALTECOM
!aAS-AMATIS
!aAS-AMAZON
!aAS-AMC
!aAS-AMCL-BB
!aAS-AMERICANET-BR
!aAS-AMERIDOTCA
!aAS-AMERIDOTCA6
!aAS-AMPERSAND
!aAS-ANEXIA
!aAS-ANIN
!aAS-ANJOS
!aAS-ANTEL-ALL
!aAS-ANX
!aAS-ANYCAST
!aAS-AOFEI-Intl
!aAS-AOI
!aAS-AORTA
!aAS-AORTA6
!aAS-APPLE
!aAS-APPNOR
!aAS-ARENAONE
!aAS-ARI
!aAS-ARIN-NTT-SILICON-VALLEY
!aAS-ARIN-SERVICE-EAST
!aAS-ARMSTRONGPXY
!aAS-ARPNETWORKS
!aAS-AS29550
!aAS-AS29550-V6
!aAS-ASAHI-NET
!aAS-ASK4
!aAS-ASTRALUS
!aAS-ATOM86
!aAS-AUTOMATTIC
!aAS-AVIRADE
!aAS-AXNE
!aAS-AYERA
!aAS-AZERSATMEMBERS
!aAS-BANDWIDTH
!aAS-BBC
!aAS-BBCONNECT
!aAS-BBOI
!aAS-BDRV
!aAS-BEANFIELD
!aAS-BELBONEMEMBERS
!aAS-BELCLOUD
!aAS-BELCLOUD-V6
!aAS-BELNET
!aAS-BENDTEL
!aAS-BERTRAMWIRELESS
!aAS-BESTPATH
!aAS-BGCOM
!aAS-BGL
!aAS-BGPNET
!aAS-BIDSTRADING
!aAS-BIGPIPE
!aAS-BIH
!aAS-BINCNET
!aAS-BIT
!aAS-BIT6
!aAS-BKNIX
!aAS-BKVG
!aAS-BLACKNIGHT
!aAS-BLIZZARD
!aAS-BLRS
!aAS-BOGONS
!aAS-BORWOOD
!aAS-BOUYGTEL-ISP
!aAS-BRIDGEFIBRE
!aAS-BROADASPECT
!aAS-BSKYB-BROADBAND
!aAS-BT-GLOBAL
!aAS-BTC-UP
!aAS-BTC-UP-V6
!aAS-BTELOUT
!aAS-BTELOUT-V6
!aAS-BTS
!aAS-BTS-GLOBAL
!aAS-BULSATCOM
!aAS-BURSTFIRE-NTT
!aAS-BWFN
!aAS-BXI
!aAS-BYTEMARK
!aAS-BatBlue
!aAS-C4L
!aAS-CACHENETWORKS
!aAS-CADENCE
!aAS-CAIS
!aAS-CALL27
!aAS-CAMBRIUM
!aAS-CAMPAIGNMONITOR
!aAS-CANAR-TRANSIT
!aAS-CAPENET
!aAS-CAPITALONLINEDATAgit 
!aAS-CARPATHIA
!aAS-CATALYST2
!aAS-CATALYST2-V6
!aAS-CAVEO
!aAS-CBCCOM
!aAS-CBJAYABBAND
!aAS-CCCN
!aAS-CCI
!aAS-CCI-FL-CUST
!aAS-CCI-KS-CUST
!aAS-CCSLEEDS
!aAS-CDNETWORKS
!aAS-CELESTE
!aAS-CENTERPRESTADORA
!aAS-CENTRILOGIC
!aAS-CESNET
!aAS-CESNET6
!aAS-CETIN
!aAS-CHAOS
!aAS-CHIEF-TRANSIT
!aAS-CHOOPA
!aAS-CIFNET
!aAS-CIPHERKEY-TRANSIT
!aAS-CITIZENSCOOP
!aAS-CJH
!aAS-CLEARIP
!aAS-CLOUDFLARE
!aAS-CLOUDHELIX
!aAS-CLOUDMERGE
!aAS-CLOUVIDER
!aAS-CMI-ALL
!aAS-CN2
!aAS-CNA
!aAS-CNHAT
!aAS-CNHAT-V6
!aAS-CODETEL
!aAS-COLO-AU
!aAS-COLOAT
!aAS-COLOCLUE
!aAS-COLT
!aAS-COLT6
!aAS-COMSAVE
!aAS-COMVIVE
!aAS-CONNETU
!aAS-CONTINENT8-ASIA
!aAS-CORALNET
!aAS-COREIX
!aAS-CORESPACE-DAL
!aAS-COREXCHANGE-US
!aAS-CORPORATIVATELCOM
!aAS-COX-TRANSIT
!aAS-CPNET
!aAS-CPRM
!aAS-CRITEO-AP
!aAS-CSF
!aAS-CSLOXINFO-TRANSIT
!aAS-CTCX
!aAS-CTI-Telecom
!aAS-CTMTELEONE
!aAS-CUSTDC
!aAS-RAGINGWIRE
!aAS-RAINBOW
!aAS-RAKUTEN-RBN
!aAS-RATIONAL-CUS
!aAS-RBLHST
!aAS-RDSNET
!aAS-REBACOM
!aAS-REDIRIS
!aAS-RETELIT
!aAS-RETN
!aAS-RETN6
!aAS-RG-DFW
!aAS-RG-IAD
!aAS-RG-SEA
!aAS-RHTEC
!aAS-RHTEC6
!aAS-RICHTOPEC
!aAS-RINGCENTRAL
!aAS-RIOT
!aAS-RKOM
!aAS-RMI
!aAS-RMIFL
!aAS-RNP-TRANSIT
!aAS-ROCKISLAND
!aAS-ROKA
!aAS-ROSITE
!aAS-ROSITE6
!aAS-RPS
!aAS-RTD
!aAS-RUBICONPROJECT
!aAS-RWTS-DS
!aAS-SAKURA
!aAS-SALESFORCE
!aAS-SANNET
!aAS-SARENET
!aAS-SARGASSO-UK
!aAS-SAVVISJP
!aAS-SBN-IIG
!aAS-SCIS
!aAS-SDT
!aAS-SDT-V6
!aAS-SEABONE
!aAS-SEABONE-V6
!aAS-SECARMA
!aAS-SECBUBWC
!aAS-SECH-EAT
!aAS-SECURA
!aAS-SEEDNET
!aAS-SEMAPHORE
!aAS-SERVERCENTRAL
!aAS-SERVEREL
!aAS-SERVERSCOM
!aAS-SET-40356
!aAS-SET-9930
!aAS-SET-AFRIX
!aAS-SET-ANTAMEDIAKOM
!aAS-SET-BIGBAND
!aAS-SET-BSCCL
!aAS-SET-GTI
!aAS-SET-IPDC
!aAS-SET-SEACOM
!aAS-SET-TELBRU-APNIC
!aAS-SET-XLCG-GLOBAL
!aAS-SET6-38566
!aAS-SETPTCL
!aAS-SGGS
!aAS-SHARKS
!aAS-SHARKS6
!aAS-SHENTEL
!aAS-SINET4
!aAS-SINGTEL
!aAS-CWASIA
!aAS-CWCI
!aAS-CWCS-PS
!aAS-CYBERLYNK
!aAS-CYPRESSTEL
!aAS-CYSO
!aAS-Comporium-Transit
!aAS-Cybercon
!aAS-D-NET
!aAS-DACOM
!aAS-DAILYMOTION
!aAS-DALENYS
!aAS-DATA393-INV01
!aAS-DATAHOP
!aAS-DATAPIPE
!aAS-DCI
!aAS-DCLUX
!aAS-DDOS-GUARD
!aAS-DEFENSE
!aAS-DELTA
!aAS-DENIC
!aAS-DEVCLIC
!aAS-DGINET
!aAS-DIALTELECOM
!aAS-DIDICHUXING
!aAS-DIMENOC
!aAS-DINAMICA-BR
!aAS-DIRECT_PEERS
!aAS-DIYIXIAN
!aAS-DLIVE
!aAS-DMITINC
!aAS-DOCLER
!aAS-DOTRO
!aAS-DRUKNET-TRANSIT
!aAS-DSTORAGE
!aAS-DSTORAGE-V6
!aAS-DTN
!aAS-DUMARCA
!aAS-DUOCAST
!aAS-DWNI
!aAS-DXNET
!aAS-DXTLTECH
!aAS-DYNINC
!aAS-EASYNET
!aAS-EBT
!aAS-EC-MI
!aAS-EDGECAST
!aAS-EDION
!aAS-EDISON-CARRIER-SOLUTIONS
!aAS-EDXNETWORK
!aAS-EFAR
!aAS-EHIME-CATV
!aAS-EIGI
!aAS-EIGI-SC
!aAS-EIRCOM
!aAS-EISCO
!aAS-EISON-LTD
!aAS-EITC-DU
!aAS-EL-K-STIL
!aAS-ELASTX
!aAS-ELI
!aAS-ELIAS
!aAS-ELLIJAY
!aAS-EMAILVISION
!aAS-EMIX
!aAS-ENTELBOLIVIA
!aAS-ENTER
!aAS-ENTER-V6
!aAS-EONIX
!aAS-EQUANT-ASIA
!aAS-EQUINIX-AP
!aAS-EQUINIX-EC
!aAS-EQUINIX-EU
!aAS-EQUINIX-OS
!aAS-ESH
!aAS-ESNET
!aAS-ETHEROUTE
!aAS-ETOP
!aAS-EUNETWORKS
!aAS-EUTELSAT-TH2
!aAS-EVERESTDATA
!aAS-EXA
!aAS-EXASCALE
!aAS-EXATEL-INT
!aAS-EXN
!aAS-EXPEDIENT
!aAS-EXPONENTIAL-e
!aAS-EXPONENTIAL-e-6
!aAS-EnergyGroupNetworks
!aAS-Expedient6
!aAS-FARSIGHT
!aAS-FASTNET
!aAS-FBDC
!aAS-FHE3NET
!aAS-FHL
!aAS-FIBERHUB
!aAS-FIBERRING
!aAS-FIDONET
!aAS-FIRSTCOLO
!aAS-FLAGT
!aAS-FLUENCY
!aAS-FOBUL
!aAS-FOBUL-V6
!aAS-FORCEPOINT-CLOUD
!aAS-FOREMOST
!aAS-FORTEX
!aAS-FORTEX6
!aAS-FPP
!aAS-FPT
!aAS-FREECOMM
!aAS-FREENETDE
!aAS-FREENETDE6
!aAS-FROM-JP-FTMNET
!aAS-FSYS
!aAS-FUSE
!aAS-FUSIX
!aAS-FUZENET
!aAS-G8
!aAS-GAMMATELECOM
!aAS-GBLX
!aAS-GBXS
!aAS-GBXS6
!aAS-GCI
!aAS-GCNET
!aAS-GCNETV6
!aAS-GCOM-MD
!aAS-GCONNECT
!aAS-GCORE
!aAS-GCTR-JP
!aAS-GDG
!aAS-GENCAT
!aAS-GENESISADAPTIVE
!aAS-GFSB
!aAS-GIGAINFRA
!aAS-GIGAINFRA-V6
!aAS-GIGANEWS-ALL
!aAS-GIPNET
!aAS-GITS
!aAS-GLIDE
!aAS-GLOBAL
!aAS-GLOBALNOC
!aAS-GLOBALNOC6
!aAS-GLOBEINTERNET
!aAS-GLOBEINTERNET-IPv6
!aAS-GMO
!aAS-GNT
!aAS-GOOGLE
!aAS-GORILLASERVERS
!aAS-GOSCOMB
!aAS-GOSCOMB-V6
!aAS-GRAFIX-TRANSIT
!aAS-GRAJAUNET
!aAS-GRU
!aAS-GSVNET
!aAS-GTLD
!aAS-GVA
!aAS-GVM
!aAS-GVM6
!aAS-GXT
!aAS-GYRON
!aAS-GigaDefence
!aAS-HANABI
!aAS-HANABI4-MDDOS
!aAS-HANOITELECOM
!aAS-HARGRAY-TRANSIT
!aAS-HEAS
!aAS-HELINET-V4
!aAS-HELINET-V6
!aAS-HETZNER
!aAS-HGC-INTL
!aAS-HIBERNIA
!aAS-HIGE
!aAS-HIGHWINDS
!aAS-HKBN
!aAS-HKNET
!aAS-HOPONE
!aAS-HOSTIT-MK
!aAS-HOSTIT-NN
!aAS-HOSTMY
!aAS-HOSTSERVER
!aAS-HOSTWAY
!aAS-HOTnet-HOTCN
!aAS-HPC-MVM
!aAS-HURRICANE
!aAS-HURRICANEv6
!aAS-HUTCHCITY
!aAS-I-NET
!aAS-I123
!aAS-I3-BGP-CUSTOMERS
!aAS-IBGC
!aAS-IBMNET-JP
!aAS-IBOSS
!aAS-ICANN
!aAS-ICANN6
!aAS-ICNC
!aAS-ICTX
!aAS-IDAQ
!aAS-IDC
!aAS-IDC6
!aAS-IDNET
!aAS-IGNEMEA
!aAS-IGUANE
!aAS-IGW-SET
!aAS-IHENDERSON
!aAS-II-OKINAWA
!aAS-IIJ
!aAS-IIJ6
!aAS-IMGIX
!aAS-IN2NET
!aAS-INCAPSULA
!aAS-INCOMM
!aAS-INETBONE
!aAS-INETBONE-V6
!aAS-INETC
!aAS-INFOPACT
!aAS-SIOL
!aAS-SIOL6
!aAS-SIP
!aAS-SKBroadband
!aAS-SKYCABLE
!aAS-SKYVISION
!aAS-SLF-13760-DOWNSTREAM
!aAS-SLINC
!aAS-SLT-GLOBAL
!aAS-SMAID
!aAS-SO-NET6
!aAS-SOFIA-CONNECT
!aAS-SOFIA-CONNECT-V6
!aAS-SOFTLAYER
!aAS-SOHONET-UK
!aAS-SOLCON
!aAS-SOLCON6
!aAS-SOLNET
!aAS-SOMEADDRESS
!aAS-SONY-CGEI
!aAS-SOTACONNECT
!aAS-SOUTHEAST-TEXAS-GIGAPOP-VERIO
!aAS-SOVAM
!aAS-SPACENET
!aAS-SPACENET-V6
!aAS-SPACENETWORK
!aAS-SPNET
!aAS-SPOTIFY
!aAS-SRT
!aAS-SSCNETWORKS
!aAS-STACKPATH
!aAS-STARHUBINTERNET
!aAS-STARTNIX-EU
!aAS-STARTOUCH
!aAS-STCN
!aAS-STEADFAST
!aAS-STEALTH
!aAS-STRATUS-DOWNSTREAM
!aAS-STS-RO
!aAS-SUITABLETECH
!aAS-SUPERINTERNET
!aAS-SUPRANET
!aAS-SURETEC
!aAS-SURFNET
!aAS-SWCMGLOBAL
!aAS-SWIPNET
!aAS-SWITCHCO
!aAS-SYMC
!aAS-SYSELEVEN
!aAS-SZARANET
!aAS-So-Net
!aAS-TABOOLA
!aAS-TANGO
!aAS-TASHICELL
!aAS-TCTWest
!aAS-TDATANET
!aAS-TDCNET
!aAS-TDCNET-IPV6
!aAS-TDDE
!aAS-TECHNO
!aAS-TECHNO-V6
!aAS-TECNOCRATICA
!aAS-TELAPPLIANT
!aAS-TELCONET-TRANSIT-AS
!aAS-TELE2
!aAS-TELENET
!aAS-TELEPAK-C
!aAS-TELETRANS
!aAS-TELIKO
!aAS-TELMEX
!aAS-TELSTRA-INTL-CUSTOMERS
!aAS-TERTIARY
!aAS-TFN-TRANSIT1
!aAS-TGW
!aAS-THEGIGABIT
!aAS-THINFACTORY
!aAS-THIX
!aAS-THRESHINC
!aAS-TICGW
!aAS-TIG-GROUP
!aAS-TIGGEE
!aAS-TIMICO
!aAS-TIPNETIT
!aAS-TKPSA-UP
!aAS-TMHK
!aAS-TMNET-CUSTOMERS
!aAS-TMR
!aAS-TMX-PERU-TRANSIT
!aAS-TOTALUPTIME
!aAS-TOUCHTONE
!aAS-TOWARDEX
!aAS-TRANSIP
!aAS-TRANSIT-GLOBE
!aAS-TRANSITOS
!aAS-TRANSIX-E
!aAS-TRANSIX-W
!aAS-TREML-STURM
!aAS-TRIPLETNET
!aAS-TROYC-01
!aAS-TRUE
!aAS-TRUNKNETWORKS
!aAS-TTK
!aAS-TTK6
!aAS-TTNET
!aAS-TURN
!aAS-TVC
!aAS-TWIG
!aAS-TWITTER
!aAS-TWTIT
!aAS-Tecnocratica
!aAS-Telx
!aAS-Transit-NetNam
!aAS-U-NETSURF
!aAS-UCC
!aAS-UKBB6
!aAS-UKSERVERS
!aAS-ULTRACOM
!aAS-UNBELIEVABLE
!aAS-UNILINK
!aAS-UNILINK-V6
!aAS-UNILOGICNET
!aAS-UNISERVER
!aAS-UNITAS
!aAS-VAIONI
!aAS-VALVE
!aAS-VDC
!aAS-VECTANT
!aAS-VELIANET
!aAS-VELIANET-V6
!aAS-VERIO-65029
!aAS-VERIO-65031
!aAS-VERIO-65052
!aAS-VERIO-65053
!aAS-VERIO-65056
!aAS-VERIO-65061
!aAS-VERIO-65072
!aAS-VERIO-65073
!aAS-VERIO-65301
!aAS-VERIO-65304
!aAS-VERIXI
!aAS-VERSATEL-V6
!aAS-VIANET
!aAS-VIAWEST-TRANSIT
!aAS-VIPNETNTT
!aAS-VIRTELA-COMM
!aAS-VKONTAKTE
!aAS-VORBOSS
!aAS-VORBOSS6
!aAS-VOXILITY-SET
!aAS-VRNETZE-FRA
!aAS-WBTSJP-NET
!aAS-WEBAIR
!aAS-WEBDISCOUNT
!aAS-WEBEX
!aAS-WEBNX
!aAS-WERADIO
!aAS-WERITECH
!aAS-WIFIRST
!aAS-WIKIMEDIA
!aAS-WILDCARD
!aAS-WIMANX
!aAS-WINDSTREAM
!aAS-WINKY
!aAS-WINSPEED-TRANSIT
!aAS-WOLCOMM
!aAS-WOW
!aAS-WPT
!aAS-WWN
!aAS-WZ-EU
!aAS-WZ-US
!aAS-XEPHION
!aAS-XFERNET
!aAS-XMISSION
!aAS-XO
!aAS-XPNTI
!aAS-XTOM
!aAS-XTRAORDINARY
!aAS-ZAYO-ZCLOUD-ATL01
!aAS-ZEN
!aAS-ZENEDGE
!aAS-ZENLAYER
!aAS-ZILLO1
!aAS-anch-global
!aAS-enjoyvc-Kwai
!aAS-eo
!aAS-fnetlink
!aAS-globalfrag
!aAS-iTSCOM
!aAs-simwood
!aas-30666
!aas-AS19905
!aas-NewEdge
!aas-Peak10
!aas-cdn77
!aas-comms365
!aas-ebaymtbb
!aas-freethought
!aas-gorannet
!aas-gtld
!aas-gtt
!aas-infinitytelecom
!aas-iwonco-default
!aas-pldt
!aas-portlane
!aas-roblox
!aas-set-ipserverone
!aAS-PTISP
!aAS-QRATOR
!aAS-QTEL-SET
!aAS-QTS-11767
!aAS-QTS-20141
!aAS-QTS-394968
!aAS-QTS-40107
!aAS-QTS-40913
!aAS-QTS-4136
!aAS-QTS-53907
!aAS-QWEST
!aAS-RACE
!aAS-RACKCORP
!aAS-RACKSENSE
!aAS-RACKSENSE-IPV6
!aAS-RACKSPACE
!aAS-PHONOSCOPE
!aAS-PHYBER
!aAS-PLAYONLINE
!aAS-PLIXDC-MIX
!aAS-PLUSLINE
!aAS-PNAPACS
!aAS-PNAPAMS004
!aAS-PNAPCHG
!aAS-PNAPDALZ
!aAS-PNAPFRA002
!aAS-PNAPHKG001
!aAS-PNAPIRLAB
!aAS-PNAPLAX
!aAS-PNAPLON
!aAS-PNAPMIA
!aAS-PNAPNYM
!aAS-PNAPOSK001
!aAS-PNAPPAR
!aAS-PNAPSEF
!aAS-PNAPSJE
!aAS-PNAPSYD001
!aAS-PNAPTOK
!aAS-PNAPWDC002
!aAS-PNW-GIGAPOP-I
!aAS-POBOX
!aAS-POCKETINET
!aAS-PRIMACOM-ISP
!aAS-PRIMEXM-US
!aAS-PRLSS
!aAS-PROBENETWORKS
!aAS-PROBENETWORKS-v6
!aAS-PROLE
!aAS-PROLOCATION
!aAS-PROLOCATION-V6
!aAS-PROPER
!aAS-PROPER6
!aAS-PROTEXIA
!aAS-PSINET-US
!aAS-PSLIGHTWAVE
!aAS-PSN-ID
!aAS-PTA
!aAS-INFORELAY
!aAS-INFOSPHERE
!aAS-INFOWEB
!aAS-INFOWEB-V6
!aAS-INIT7
!aAS-INNET
!aAS-INOC
!aAS-INSTART
!aAS-INTERACTIVE3D
!aAS-INTERDOMINIOS
!aAS-INTERNETONE_CH
!aAS-INTEROUTE
!aAS-INTERVIA
!aAS-IOKO
!aAS-IOVATION
!aAS-IP-MAX
!aAS-IP-MAX-V6
!aAS-IPACCT
!aAS-IPB
!aAS-IPIFONY
!aAS-IPTRANSIT
!aAS-IQNETWORKS
!aAS-IRON
!aAS-IRONDNS
!aAS-IRONDNS-V6
!aAS-IS
!aAS-ISPNET
!aAS-ITANDTEL
!aAS-ITANDTEL-IPV6
!aAS-ITHOLDINGSCUSTOMERS
!aAS-ITSTG
!aAS-IUSA
!aAS-IVANET-ASIA
!aAS-IVZ
!aAS-IXREACH
!aAS-JAGUAR
!aAS-JAGUAR-V6
!aAS-JANIS
!aAS-JOINTTRANSIT
!aAS-JPRS
!aAS-JUMP
!aAS-KAKAO
!aAS-KCOMSPN
!aAS-KDDI6
!aAS-KDDIDMPEER4
!aAS-KEYCOM
!aAS-KINGSTONUK
!aAS-KINX-TRANSIT
!aAS-KMS
!aAS-KOMTEL
!aAS-KORNET
!aAS-KPNv6
!aAS-KPTNETWORK
!aAS-KQ
!aAS-KRYPTON
!aAS-KUENTOS-TRANSIT
!aAS-LAGIS
!aAS-LAGIS6
!aAS-LAHAI-SG
!aAS-LARENF
!aAS-LATINIP
!aAS-LCHOST
!aAS-LEASEWEB
!aAS-LEASEWEB-APAC
!aAS-LEASEWEB-NL
!aAS-LIBERTYI
!aAS-LINKAGE
!aAS-LINKEDIN-TRANSIT
!aAS-LINODE
!aAS-LINXTELECOM
!aAS-LIQUID
!aAS-LONSDALESOLWAY
!aAS-LOSNETTOS
!aAS-LOSNETTOS-IPv6
!aAS-LOTTOMATICA
!aAS-LROOT
!aAS-LSNET
!aAS-LUME
!aAS-LUMOS
!aAS-LUXNETWORK
!aAS-LWL
!aAS-LeaseNet-Customers
!aAS-MACROLYNX
!aAS-MACTELECOM
!aAS-MAEHDROS
!aAS-MANDA
!aAS-MCNET
!aAS-MEDIASAT
!aAS-MEDIAWEB-NET
!aAS-MEGADIAL
!aAS-MEGASPACE
!aAS-MELBICOM
!aAS-MEON
!aAS-MERULA
!aAS-MESH
!aAS-METROCAST
!aAS-METRONETUK
!aAS-METROSWITCH
!aAS-MEX
!aAS-MEX6
!aAS-MF-MGSM
!aAS-MFE-TRANSIT
!aAS-MHDD
!aAS-MICHNET
!aAS-MICROSOFT
!aAS-MIDCO
!aAS-MISTRAL
!aAS-MITENE
!aAS-MK-NETZDIENSTE
!aAS-MK-NETZDIENSTE-V6
!aAS-MNETDE
!aAS-MNS
!aAS-MOBILY
!aAS-MOHAWK-TRANSIT
!aAS-MOJI
!aAS-MTCCOMM
!aAS-MTEL-MO
!aAS-MYNET
!aAS-MYTHIC
!aAS-NBIP
!aAS-NBIP6
!aAS-NCOM
!aAS-NCSC-DNS
!aAS-NET1OUT
!aAS-NET2ONE
!aAS-NETACTUATE
!aAS-NETASSIST
!aAS-NETCONNEX
!aAS-NETERRA-INT
!aAS-NETFORTRIS
!aAS-NETGUARDBG
!aAS-NETHER
!aAS-NETIRD
!aAS-NETIRD-V6
!aAS-NETLOGICS
!aAS-NETNOD
!aAS-NETRIVER
!aAS-NETROUTING
!aAS-NETROUTING6
!aAS-NETUSE
!aAS-NETVISIONTEL
!aAS-NETWISE
!aAS-NETWORKPLATFORMS
!aAS-NETWORXBG
!aAS-NEWMEDIAEXPRESS
!aAS-NEXGEN
!aAS-NEXICA
!aAS-NEXICOM
!aAS-NEXTGLOBALSERV
!aAS-NEXTGLOBALSERV6
!aAS-NEXTLAYER
!aAS-NEXTLAYER-V6
!aAS-NEXUS-TELECOM
!aAS-NFCR
!aAS-NFL
!aAS-NFORCE
!aAS-NHN
!aAS-NHN-TECHORUS
!aAS-NIANDC
!aAS-NIANET
!aAS-NIANETV6
!aAS-NITEL-TRANSIT
!aAS-NOANET-PEERING
!aAS-NODE4
!aAS-NOELC
!aAS-NOMICAL
!aAS-NOMINET-NS
!aAS-NOMINET-RES1
!aAS-NOMINUM-SKYE
!aAS-NOOR
!aAS-NORDUNET
!aAS-NORIS
!aAS-NOVATEL
!aAS-NSCS-NET
!aAS-NSI-DC
!aAS-NSL-CUSTOMERS
!aAS-NSONE
!aAS-NT
!aAS-NTT-CISCO
!aAS-NTTCOMWARE
!aAS-NTTNETID
!aAS-NULL
!aAS-NUWAVE
!aAS-NYNEX
!aAS-Novatectelecom
!aAS-OBENETWORK
!aAS-OC-ASSET
!aAS-OCG
!aAS-OCN-ALL
!aAS-OCN-ALL-V6
!aAS-ODN
!aAS-ODN-V6
!aAS-ONERINGNETWORKS
!aAS-ONO-IPV6
!aAS-ONO-UPS
!aAS-ONYX
!aAS-OPAL
!aAS-OPENCARRIER
!aAS-OPENCARRIER6
!aAS-OPENDNS
!aAS-OPENTRANSIT
!aAS-OPERA
!aAS-OPERA-ASIA
!aAS-OPTINET
!aAS-ORBITAL
!aAS-OTL
!aAS-OVH
!aAS-OZ-ITHS
!aAS-PACIFICNET
!aAS-PACNET-DOWNSTREAM
!aAS-PALTEL
!aAS-PANTEL
!aAS-PARKER
!aAS-PARTAN
!aAS-PAVLOV
!aAS-PAXIO
!aAS-PAYPAL
!aAS-PCH
!aAS-PEGTECHCUSTOMERS
!aAS-PENGUIN
!aAS-PEOPLESCOM
!aAS-PHIBEE-TELECOM
!aAS-PHOENIXNAP
!q""".splitlines()

    queries_str = b"\n".join(queries) + b"\n"
    s.sendall(queries_str)

    start_time = time.perf_counter()
    while 1:
        data = s.recv(1024 * 1024)
        if not data:
            break

    count = len(queries) - 1
    elapsed = time.perf_counter() - start_time
    time_per_query = elapsed / count * 1000
    qps = int(count / elapsed)
    print(f"Ran {count} queries in {elapsed}s, time per query {time_per_query} ms, {qps} qps")


if __name__ == "__main__":  # pragma: no cover
    description = """A simple update tester for IRRd. Sends random !g queries."""
    parser = argparse.ArgumentParser(description=description)
    parser.add_argument(
        "--count",
        dest="count",
        type=int,
        default=5000,
        help=f"number of queries to main (default: 5000)",
    )
    parser.add_argument("host", type=str, help="hostname of instance")
    parser.add_argument("port", type=int, help="port of instance")
    args = parser.parse_args()

    main(args.host, args.port, args.count)
