#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# CERT UEFI Parser
#
# Copyright 2025 Carnegie Mellon University.
#
# NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING INSTITUTE MATERIAL
# IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY
# KIND, EITHER EXPRESSED OR IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO,
# WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED
# FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY
# KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
#
# Licensed under a BSD (SEI)-style license, please see license.txt or contact
# permission@sei.cmu.edu for full terms.
#
# [DISTRIBUTION STATEMENT A] This material has been approved for public release and
# unlimited distribution.  Please see Copyright notice for non-US Government use and
# distribution.
#
# This Software includes and/or makes use of Third-Party Software each subject to its own
# license.
#
# DM25-1401
"""
An icon for the CERT UEFI Parser application.
"""

# ----------------------------------------------------------------------------------------
# Icon attribution: https://www.freepik.com/icon/cpu-tower_2482418
# Part of the "Special Lineal color by Freepik" collection.

icon_data = """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"""

# ----------------------------------------------------------------------------------------
# Local Variables:
# mode: python
# fill-column: 90
# End:
