import io
from typing import Optional as OptionalType, Union as UnionType, Any, TypeVar
from typing_extensions import Self
from collections.abc import Callable, OrderedDict, dict_keys, dict_values, dict_items # type: ignore
from _typeshed import Incomplete

__author__: str
__version__: str

class ConstructError(Exception):
    path: Incomplete
    def __init__(self, message: str = '', path: Incomplete | None = None) -> None: ...

class SizeofError(ConstructError): ...
class AdaptationError(ConstructError): ...
class ValidationError(ConstructError): ...
class StreamError(ConstructError): ...
class FormatFieldError(ConstructError): ...
class IntegerError(ConstructError): ...
class StringError(ConstructError): ...
class MappingError(ConstructError): ...
class RangeError(ConstructError): ...
class RepeatError(ConstructError): ...
class ConstError(ConstructError): ...
class IndexFieldError(ConstructError): ...
class CheckError(ConstructError): ...
class ExplicitError(ConstructError): ...
class NamedTupleError(ConstructError): ...
class TimestampError(ConstructError): ...
class UnionError(ConstructError): ...
class SelectError(ConstructError): ...
class SwitchError(ConstructError): ...
class StopFieldError(ConstructError): ...
class PaddingError(ConstructError): ...
class TerminatedError(ConstructError): ...
class RawCopyError(ConstructError): ...
class RotationError(ConstructError): ...
class ChecksumError(ConstructError): ...
class CancelParsing(ConstructError): ...

#def singleton(arg): ...
def stream_read(stream: Any, length: int, path: Any) -> Any: ...
#def stream_read_entire(stream, path): ...
#def stream_write(stream, data, length, path) -> None: ...
def stream_seek(stream: Any, offset: int, whence: int, path: Any) -> int: ...
def stream_tell(stream: Any, path: Any) -> int: ...
#def stream_size(stream): ...
#def stream_iseof(stream): ...

class CodeGen:
    blocks: Incomplete
    nextid: int
    parsercache: Incomplete
    buildercache: Incomplete
    linkedinstances: Incomplete
    linkedparsers: Incomplete
    linkedbuilders: Incomplete
    #def __init__(self) -> None: ...
    #def allocateId(self): ...
    #def append(self, block) -> None: ...
    #def toString(self): ...

class KsyGen:
    instances: Incomplete
    enums: Incomplete
    types: Incomplete
    nextid: int
    #def __init__(self) -> None: ...
    #def allocateId(self): ...

#def hyphenatedict(d): ...
#def hyphenatelist(l): ...
def extractfield(sc: Construct) -> Construct: ...
def evaluate(param: Any, context: Any) -> Any: ...

RetVal = TypeVar('RetVal')  # Return type is a function of an input parameter.

class Construct:
    name: Incomplete
    docs: str
    flagbuildnone: bool
    parsed: Incomplete
    #def __init__(self) -> None: ...
    #def __copy__(self): ...
    def parse(self, data: UnionType[bytes, bytearray], **contextkw: Any) -> Any: ...
    def parse_stream(self, stream: Any, **contextkw: Any) -> Any: ...
    #def parse_file(self, filename, **contextkw): ...
    def build(self, obj: RetVal, **contextkw: Any) -> bytes: ...
    def _build(self, obj: RetVal, stream: Any, context: Container, path: str) -> bytes: ...
    #def build_stream(self, obj, stream, **contextkw) -> None: ...
    #def build_file(self, obj, filename, **contextkw) -> None: ...
    #def sizeof(self, **contextkw): ...
    #def compile(self, filename: Incomplete | None = None): ...
    #def benchmark(self, sampledata, filename: Incomplete | None = None): ...
    #def export_ksy(self, schemaname: str = 'unnamed_schema', filename: Incomplete | None = None): ...
    def __rtruediv__(self, name: str) -> Renamed: ...
    def __rdiv__(self, name: str) -> Renamed: ...
    #def __mul__(self, other): ...
    #def __rmul__(self, other): ...
    #def __add__(self, other): ...
    #def __rshift__(self, other): ...
    #def __getitem__(self, count): ...
    # MWD FIXME: Does __len__ & _build really exist?
    def __len__(self) -> int: ...
    # _parse returns the underlying Python type (e.g. int, str, bytes, etc.)
    def _parse(self, stream: Any, context: Container, path: str) -> Any: ...
    def _parsereport(self, stream: Any, context: Container, path: str) -> Any: ...
    def _sizeof(self, **contextkw: Any) -> int: ...

class Subconstruct(Construct):
    subcon: Construct
    flagbuildnone: Incomplete
    def __init__(self, subcon: Construct) -> None: ...

class Adapter(Subconstruct): ...
class SymmetricAdapter(Adapter): ...
class Validator(SymmetricAdapter): ...
class Tunnel(Subconstruct): ...

class Compiled(Construct):
    source: Incomplete
    defersubcon: Incomplete
    parsefunc: Incomplete
    buildfunc: Incomplete
    #def __init__(self, parsefunc, buildfunc) -> None: ...
    #def compile(self, filename: Incomplete | None = None): ...
    #def benchmark(self, sampledata, filename: Incomplete | None = None): ...

class Bytes(Construct):
    length: int
    def __init__(self, length: UnionType[Callable[[Any], int], int]) -> None: ...

class _GreedyBytes(Construct): ...
GreedyBytes: _GreedyBytes

#def Bitwise(subcon): ...
#def Bytewise(subcon): ...

class FormatField(Construct):
    fmtstr: Incomplete
    length: Incomplete
    def __init__(self, endianity: str, format: str) -> None: ...
    def __int__(self) -> int: ...

class BytesInteger(Construct):
    length: Incomplete
    signed: Incomplete
    swapped: Incomplete
    def __init__(self, length: int, signed: bool = False, swapped: bool = False) -> None: ...

class BitsInteger(Construct):
    length: Incomplete
    signed: Incomplete
    swapped: Incomplete
    def __init__(self, length: int, signed: bool = False, swapped: bool = False) -> None: ...

Bit = BitsInteger(1)
Nibble = BitsInteger(4)
Octet = BitsInteger(8)
Int8ub = FormatField(">", "B")
Int16ub = FormatField(">", "H")
Int32ub = FormatField(">", "L")
Int64ub = FormatField(">", "Q")
Int8sb = FormatField(">", "b")
Int16sb = FormatField(">", "h")
Int32sb = FormatField(">", "l")
Int64sb = FormatField(">", "q")
Int8ul = FormatField("<", "B")
Int16ul = FormatField("<", "H")
Int32ul = FormatField("<", "L")
Int64ul = FormatField("<", "Q")
Int8sl = FormatField("<", "b")
Int16sl = FormatField("<", "h")
Int32sl = FormatField("<", "l")
Int64sl = FormatField("<", "q")
Int8un = FormatField("=", "B")
Int16un = FormatField("=", "H")
Int32un = FormatField("=", "L")
Int64un = FormatField("=", "Q")
Int8sn = FormatField("=", "b")
Int16sn = FormatField("=", "h")
Int32sn = FormatField("=", "l")
Int64sn = FormatField("=", "q")
Byte = Int8ub
Short = Int16ub
Int = Int32ub
Long = Int64ub

Float16b = FormatField(">", "e")
Float16l = FormatField("<", "e")
Float16n = FormatField("=", "e")
Float32b = FormatField(">", "f")
Float32l = FormatField("<", "f")
Float32n = FormatField("=", "f")
Float64b = FormatField(">", "d")
Float64l = FormatField("<", "d")
Float64n = FormatField("=", "d")
Half = Float16b
Single = Float32b
Double = Float64b
native: Incomplete

Int24ub = BytesInteger(3, signed=False, swapped=False)
Int24ul = BytesInteger(3, signed=False, swapped=True)
Int24un = BytesInteger(3, signed=False, swapped=native)
Int24sb = BytesInteger(3, signed=True, swapped=False)
Int24sl = BytesInteger(3, signed=True, swapped=True)
Int24sn = BytesInteger(3, signed=True, swapped=native)

class _VarInt(Construct): ...
VarInt: _VarInt
class _ZigZag(Construct): ...
ZigZag: _ZigZag

possiblestringencodings: Incomplete

#def encodingunit(encoding): ...

class StringEncoded(Adapter):
    encoding: str
    #def __init__(self, subcon, encoding) -> None: ...
    def parse(self, data: UnionType[bytes, bytearray], **contextkw: Any) -> str: ...

def PaddedString(length: UnionType[Callable[..., int], int],
                 encoding: str) -> StringEncoded: ...
def PascalString(lengthfield: int, encoding: str) -> StringEncoded: ...
def CString(encoding: str) -> StringEncoded: ...
def GreedyString(encoding: str) -> StringEncoded: ...

# Faked by Cory...
class Container(OrderedDict[str, Any]): # type: ignore [misc]
    _: 'Container'
    _io: io.BytesIO
    def __getattr__(self, name: str) -> Any:
        pass

class _Flag(Construct): ...
Flag: _Flag

class EnumInteger(int): ...

class EnumIntegerString(str):
    def __int__(self) -> int: ...
    #@staticmethod
    #def new(intvalue, stringvalue): ...
    pass

class Enum(Adapter):
    encmapping: Incomplete
    decmapping: Incomplete
    ksymapping: Incomplete
    #def __init__(self, subcon, *merge, **mapping) -> None: ...
    #def __getattr__(self, name): ...

class BitwisableString(str):
    #def __or__(self, other): ...
    pass

class FlagsEnum(Adapter):
    flags: Incomplete
    reverseflags: Incomplete
    #def __init__(self, subcon, *merge, **flags) -> None: ...
    #def __getattr__(self, name): ...

class Mapping(Adapter):
    decmapping: Incomplete
    encmapping: Incomplete
    #def __init__(self, subcon: Construct, mapping) -> None: ...

class Struct(Construct):
    subcons: Incomplete
    flagbuildnone: Incomplete
    def __init__(self, *subcons: Construct, **subconskw: Any) -> None: ...
    def __getattr__(self, name: str) -> Any: ...

class Sequence(Construct):
    subcons: Incomplete
    flagbuildnone: Incomplete
    def __init__(self, *subcons: Construct, **subconskw: Any) -> None: ...
    def __getattr__(self, name: str) -> Any: ...

class Array(Subconstruct):
    count: Incomplete
    discard: Incomplete
    def __init__(self, count: UnionType[Callable[[Any], int], int],
                 subcon: Construct, discard: bool = False) -> None: ...

class GreedyRange(Subconstruct):
    discard: Incomplete
    def __init__(self, subcon: Construct, discard: bool = False) -> None: ...

class RepeatUntil(Subconstruct):
    predicate: Incomplete
    discard: Incomplete
    def __init__(self, predicate: Callable[[Any, Any, Any], Any],
                 subcon: Construct, discard: bool = False) -> None: ...

class Renamed(Subconstruct):
    name: Incomplete
    docs: Incomplete
    parsed: Incomplete
    #def __init__(self, subcon, newname: Incomplete | None = None, newdocs: Incomplete | None = None, newparsed: Incomplete | None = None) -> None: ...
    #def __getattr__(self, name): ...

class Const(Subconstruct):
    value: Incomplete
    flagbuildnone: bool
    def __init__(self, value: UnionType[int, bytes],
                 subcon: OptionalType[Construct] = None) -> None: ...

class Computed(Construct):
    func: Incomplete
    flagbuildnone: bool
    def __init__(self, func: Any) -> None: ...

class _Index(Construct):
    flagbuildnone: bool
    def __init__(self) -> None: ...
Index: _Index

class Rebuild(Subconstruct):
    func: Incomplete
    flagbuildnone: bool
    def __init__(self, subcon: Construct, func: Callable[[Any], Any]) -> None: ...

class Default(Subconstruct):
    value: Incomplete
    flagbuildnone: bool
    #def __init__(self, subcon: Construct, value) -> None: ...

class Check(Construct):
    func: Incomplete
    flagbuildnone: bool
    def __init__(self, func: Incomplete) -> None: ...

class _Error(Construct):
    flagbuildnone: bool
    def __init__(self) -> None: ...
Error: _Error

class FocusedSeq(Construct):
    parsebuildfrom: Incomplete
    subcons: Incomplete
    #def __init__(self, parsebuildfrom, *subcons, **subconskw) -> None: ...
    #def __getattr__(self, name): ...

class _Pickled(Construct): ...
Pickled: _Pickled

class _Numpy(Construct): ...
Numpy: _Numpy

class NamedTuple(Adapter):
    tuplename: Incomplete
    tuplefields: Incomplete
    factory: Incomplete
    #def __init__(self, tuplename, tuplefields, subcon) -> None: ...

class TimestampAdapter(Adapter): ...

#def Timestamp(subcon, unit, epoch): ...

class Hex(Adapter): ...
class HexDump(Adapter): ...

class Union(Construct):
    parsefrom: Incomplete
    subcons: Incomplete
    def __init__(self, parsefrom: OptionalType[UnionType[int, str]], *subcons: Construct, **subconskw: Any) -> None: ...
    def __getattr__(self, name: str) -> Any: ...

class Select(Construct):
    subcons: Incomplete
    flagbuildnone: Incomplete
    def __init__(self, *subcons: Construct, **subconskw: Any) -> None: ...

def Optional(subcon: Construct) -> Construct: ...
def If(condfunc: Callable[[Container], bool], subcon: Construct) -> Construct: ...

class IfThenElse(Construct):
    condfunc: Incomplete
    thensubcon: Incomplete
    elsesubcon: Incomplete
    flagbuildnone: Incomplete
    def __init__(self, condfunc: Callable[[Any], bool],
                 thensubcon: Construct, elsesubcon: Construct) -> None: ...

class Switch(Construct):
    keyfunc: Incomplete
    cases: Incomplete
    default: Incomplete
    flagbuildnone: Incomplete
    def __init__(self, keyfunc: Callable[[Any], Any],
                 cases: dict[Any, Any], default: OptionalType[Incomplete] = None) -> None: ...

class StopIf(Construct):
    condfunc: Incomplete
    flagbuildnone: bool
    #def __init__(self, condfunc) -> None: ...

#def Padding(length, pattern: bytes = b'\x00'): ...

class Padded(Subconstruct):
    length: Incomplete
    pattern: Incomplete
    def __init__(self, length: int, subcon: Construct, pattern: bytes = b'\x00') -> None: ...

class Aligned(Subconstruct):
    modulus: Incomplete
    pattern: Incomplete
    def __init__(self, modulus: int, subcon: Construct, pattern: bytes = b'\x00') -> None: ...

#def AlignedStruct(modulus, *subcons, **subconskw): ...
#def BitStruct(*subcons, **subconskw): ...

class Pointer(Subconstruct):
    offset: Incomplete
    stream: Incomplete
    def __init__(self, offset: UnionType[Callable[[Any], int], int], subcon: Construct,
                 stream: OptionalType[Incomplete] = None) -> None: ...

class Peek(Subconstruct):
    flagbuildnone: bool
    def __init__(self, subcon: Construct) -> None: ...

class Seek(Construct):
    at: Incomplete
    whence: Incomplete
    flagbuildnone: bool
    def __init__(self, at: int, whence: int = 0) -> None: ...

class _Tell(Construct):
    flagbuildnone: bool
    def __init__(self) -> None: ...
Tell: _Tell

class _Pass(Construct):
    flagbuildnone: bool
    def __init__(self) -> None: ...
Pass: _Pass

class _Terminated(Construct):
    flagbuildnone: bool
    #def __init__(self) -> None: ...
Terminated: _Terminated

class RawCopy(Subconstruct): ...

#def ByteSwapped(subcon): ...
#def BitsSwapped(subcon): ...

class Prefixed(Subconstruct):
    lengthfield: Incomplete
    includelength: Incomplete
    #def __init__(self, lengthfield, subcon, includelength: bool = False) -> None: ...

#def PrefixedArray(countfield, subcon): ...

class FixedSized(Subconstruct):
    length: Incomplete
    def __init__(self, length: UnionType[Callable[[Any], int], int], subcon: Construct) -> None: ...

class NullTerminated(Subconstruct):
    term: Incomplete
    include: Incomplete
    consume: Incomplete
    require: Incomplete
    #def __init__(self, subcon, term: bytes = b'\x00', include: bool = False, consume: bool = True, require: bool = True) -> None: ...

class NullStripped(Subconstruct):
    pad: Incomplete
    #def __init__(self, subcon, pad: bytes = b'\x00') -> None: ...

class RestreamData(Subconstruct):
    datafunc: Incomplete
    flagbuildnone: bool
    #def __init__(self, datafunc, subcon) -> None: ...

class Transformed(Subconstruct):
    decodefunc: Incomplete
    decodeamount: Incomplete
    encodefunc: Incomplete
    encodeamount: Incomplete
    #def __init__(self, subcon, decodefunc, decodeamount, encodefunc, encodeamount) -> None: ...

class Restreamed(Subconstruct):
    decoder: Incomplete
    decoderunit: Incomplete
    encoder: Incomplete
    encoderunit: Incomplete
    sizecomputer: Incomplete
    #def __init__(self, subcon, decoder, decoderunit, encoder, encoderunit, sizecomputer) -> None: ...

class ProcessXor(Subconstruct):
    padfunc: Incomplete
    #def __init__(self, padfunc, subcon) -> None: ...

class ProcessRotateLeft(Subconstruct):
    precomputed_single_rotations: Incomplete
    amount: Incomplete
    group: Incomplete
    #def __init__(self, amount, group, subcon) -> None: ...

class Checksum(Construct):
    checksumfield: Incomplete
    hashfunc: Incomplete
    bytesfunc: Incomplete
    flagbuildnone: bool
    #def __init__(self, checksumfield, hashfunc, bytesfunc) -> None: ...

class Compressed(Tunnel):
    encoding: Incomplete
    level: Incomplete
    lib: Incomplete
    #def __init__(self, subcon, encoding, level: Incomplete | None = None) -> None: ...

class CompressedLZ4(Tunnel):
    lib: Incomplete
    #def __init__(self, subcon) -> None: ...

class Rebuffered(Subconstruct):
    stream2: Incomplete
    #def __init__(self, subcon, tailcutoff: Incomplete | None = None) -> None: ...

class Lazy(Subconstruct):
    #def __init__(self, subcon) -> None: ...
    pass

class LazyContainer(dict[Any, Any]):
    #def __init__(self, struct, stream, offsets, values, context, path) -> None: ...
    def __getattr__(self, name: str) -> Any: ...
    def __getitem__(self, index: int) -> Any: ...
    def __len__(self) -> int: ...
    def keys(self) -> dict_keys[Any, Any]: ...
    def values(self) -> dict_values[Any, Any]: ...
    def items(self) -> dict_items[Any, Any]: ...
    __iter__ = keys
    #def __eq__(self, other): ...

class LazyStruct(Construct):
    subcons: Incomplete
    flagbuildnone: Incomplete
    #def __init__(self, *subcons, **subconskw) -> None: ...
    #def __getattr__(self, name): ...

class ListContainer(list[Any]):
    pass

class LazyListContainer(list[Any]):
    #def __init__(self, subcon, stream, count, offsets, values, context, path) -> None: ...
    #def __getitem__(self, index): ...
    #def __getslice__(self, start, stop): ...
    def __len__(self) -> int: ...
    #def __iter__(self): ...
    #def __eq__(self, other): ...

class LazyArray(Subconstruct):
    count: Incomplete
    #def __init__(self, count, subcon) -> None: ...

class LazyBound(Construct):
    subconfunc: Incomplete
    #def __init__(self, subconfunc) -> None: ...

class ExprAdapter(Adapter):
    #def __init__(self, subcon, decoder, encoder) -> None: ...
    pass

class ExprSymmetricAdapter(ExprAdapter):
    #def __init__(self, subcon, encoder) -> None: ...
    pass

class ExprValidator(Validator):
    def __init__(self, subcon: Construct, validator: Callable[..., bool]) -> None: ...

#def OneOf(subcon, valids): ...
#def NoneOf(subcon, invalids): ...
#def Filter(predicate, subcon): ...

class Slicing(Adapter):
    count: Incomplete
    start: Incomplete
    stop: Incomplete
    step: Incomplete
    empty: Incomplete
    #def __init__(self, subcon, count, start, stop, step: int = 1, empty: Incomplete | None = None) -> None: ...

class Indexing(Adapter):
    count: Incomplete
    index: Incomplete
    empty: Incomplete
    #def __init__(self, subcon, count, index, empty: Incomplete | None = None) -> None: ...

this: Any

# Names in __all__ with no definition:
#   BitwisableString
#   Bitwise
#   Container
#   Debugger
#   FocusedSeq
#   FormatField
#   FormatFieldError
#   FuncPath
#   ListContainer
#   Path
#   Path2
#   Probe
#   RebufferedBytesIO
#   RestreamedBytesIO
#   StringEncoded
#   abs_
#   globalPrintFalseFlags
#   globalPrintFullStrings
#   len_
#   list_
#   max_
#   min_
#   obj_
#   possiblestringencodings
#   release_date
#   setGlobalPrintFalseFlags
#   setGlobalPrintFullStrings
#   setGlobalPrintPrivateEntries
#   sum_
#   version
#   version_string
