# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['dp_cgans',
 'dp_cgans.constraints',
 'dp_cgans.metadata',
 'dp_cgans.synthesizers']

package_data = \
{'': ['*']}

install_requires = \
['copulas',
 'faker',
 'graphviz',
 'numpy',
 'pandas',
 'pyreadstat',
 'rdt==0.6.4',
 'scipy',
 'sdv==0.14.0',
 'sklearn',
 'torch',
 'typer',
 'wheel']

entry_points = \
{'console_scripts': ['dp-cgans = dp_cgans.__main__:cli']}

setup_kwargs = {
    'name': 'dp-cgans',
    'version': '0.0.4',
    'description': 'A library to generate synthetic tabular data using Conditional Generative Adversary Networks (GANs) combined with Differential Privacy techniques.',
    'long_description': '# 👯 DP-CGANS (Differentially Private - Conditional Generative Adversarial NetworkS)\n\n[![PyPi Shield](https://img.shields.io/pypi/v/dp-cgans)](https://pypi.org/project/dp-cgans/) [![Py versions](https://img.shields.io/pypi/pyversions/dp-cgans)](https://pypi.org/project/dp-cgans/) [![Test package](https://github.com/sunchang0124/dp_cgans/actions/workflows/test.yml/badge.svg)](https://github.com/sunchang0124/dp_cgans/actions/workflows/test.yml) [![Publish package](https://github.com/sunchang0124/dp_cgans/actions/workflows/publish.yml/badge.svg)](https://github.com/sunchang0124/dp_cgans/actions/workflows/publish.yml)\n\n\n\n<!-- [![Development Status](https://img.shields.io/badge/Development%20Status-2%20--%20Pre--Alpha-yellow)](https://pypi.org/search/?c=Development+Status+%3A%3A+2+-+Pre-Alpha) -->\n<!-- [![PyPi Shield](https://img.shields.io/badge/pypi-v0.0.2-blue)](https://pypi.org/project/dp-cgans/) -->\n<!-- [![Tests](https://github.com/sdv-dev/SDV/workflows/Run%20Tests/badge.svg)](https://github.com/sdv-dev/SDV/actions?query=workflow%3A%22Run+Tests%22+branch%3Amaster) -->\n\n**Abstract**: This repository presents a Conditional Generative Adversary Networks (GANs) on tabular data (and RDF data) combining with Differential Privacy techniques. Our pre-print publication: [Improving Correlation Capture in Generating Imbalanced Data using Differentially Private Conditional GANs](https://arxiv.org/abs/2206.13787).\n\n**Author**: Chang Sun, Institute of Data Science, Maastricht University\n**Start date**: Nov-2021\n**Status**: Under development\n\n**Note**: "Standing on the shoulders of giants". This repository is inspired by the excellent work of [CTGAN](https://github.com/sdv-dev/CTGAN) from [Synthetic Data Vault (SDV)](https://github.com/sdv-dev/SDV), [Tensorflow Privacy](https://github.com/tensorflow/privacy), and [RdfPdans](https://github.com/cadmiumkitty/rdfpandas). Highly appreciate they shared the ideas and implementations, made code publicly available, well-written documentation. More related work can be found in the References below.  \n\nThis package is extended from SDV (https://github.com/sdv-dev/SDV), CTGAN (https://github.com/sdv-dev/CTGAN), and Differential Privacy in GANs (https://github.com/civisanalytics/dpwgan). The author modified the conditional matrix and cost functions to emphasize on the relations between variables. The main changes are in ctgan/synthesizers/ctgan.py ../data_sampler.py ../data_transformer.py\n\n\n## 📥️ Installation\n\nYou will need Python >=3.8+ and <3.10\n\n```shell\npip install dp-cgans\n```\n\n## 🪄 Usage\n\n### ⌨️ Use as a command-line interface\n\nYou can easily generate synthetic data for a file using your terminal after installing `dp-cgans` with pip.\n\nTo quickly run our example, you can download the [example data](https://raw.githubusercontent.com/sunchang0124/dp_cgans/main/resources/example_tabular_data_UCIAdult.csv):\n\n```bash\nwget https://raw.githubusercontent.com/sunchang0124/dp_cgans/main/resources/example_tabular_data_UCIAdult.csv\n```\n\nThen run `dp-cgans`:\n\n```bash\ndp-cgans gen example_tabular_data_UCIAdult.csv --epochs 2 --output out.csv --gen-size 100\n```\n\nGet a full rundown of the available options for generating synthetic data with:\n\n```bash\ndp-cgans gen --help\n```\n\n### 🐍 Use with python \n\nThis library can also be used directly in python scripts\n\nIf your input is tabular data (e.g., csv):\n\n ```python\nfrom dp_cgans import DP_CGAN\nimport pandas as pd\n\ntabular_data=pd.read_csv("../resources/example_tabular_data_UCIAdult.csv")\n\n# We adjusted the original CTGAN model from SDV. Instead of looking at the distribution of individual variable, we extended to two variables and keep their corrll\nmodel = DP_CGAN(\n    epochs=100, # number of training epochs\n    batch_size=1000, # the size of each batch\n    log_frequency=True,\n    verbose=True,\n    generator_dim=(128, 128, 128),\n    discriminator_dim=(128, 128, 128),\n    generator_lr=2e-4, \n    discriminator_lr=2e-4,\n    discriminator_steps=1, \n    private=False,\n)\n\nprint("Start training model")\nmodel.fit(tabular_data)\nmodel.save("generator.pkl")\n\n# Generate 100 synthetic rows\nsyn_data = model.sample(100)\nsyn_data.to_csv("syn_data_file.csv")\n ```\n\n<!-- \n2. If your input data is in RDF format:\n\n  ```python\nfrom dp_cgans import DP_CGAN\nfrom dp_cgans import RDF_to_Tabular\n\n# Step 1. Load RDF to a plain table (dataframe)\nplain_tabular=RDF_to_Tabular(file_path="../resources/example_rdf_data.ttl")\n\n# Step 2. Convert plain table to a structured table \n# After step 1, RDF data will be converted a plain tabular dataset (all the nodes/entities will be presented as rows. Step 2 will structure the table by recognizing and sorting the types of the entities, replacing the URI with actual value which is attached to that URI. Users can decide how many levels they want to unfold their RDF models to tabular datasets.)\ntabular_data,rel_pred_obj=plain_tabular.fit_convert(user_define_data_instance="http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#C16960", \n                                                    user_define_is_a=["rdf:type{URIRef}"], \n                                                    user_define_has_value=["http://www.cancerdata.org/roo/P100042"], \n                                                    set_level="full", \n                                                    as_column=\'object\', \n                                                    remove_columns_unique_values=True)\n\n# Step 3. Define your GANS model\nmodel = DP_CGAN(\n    epochs=100, # number of training epochs\n    batch_size=1000, # the size of each batch\n    log_frequency=True,\n    verbose=True,\n    generator_dim=(128, 128, 128),\n    discriminator_dim=(128, 128, 128),\n    generator_lr=2e-4, \n    discriminator_lr=2e-4,\n    discriminator_steps=1, \n    private=False,\n)\n\nprint("Start training model")\nmodel.fit(tabular_data)\n\n# Sample the generated synthetic data\nmodel.sample(100)\n  ```\n-->\n\n\n## 🧑\u200d💻 Development setup\n\n<details>\n<summary>You will need to <a href="https://python-poetry.org/docs">install Poetry</a></summary><br/>\n\nBe careful as poetry sometime uses a weird python version by default, you can check for the environment used by poetry for the current folder by running:\n\n```bash\npoetry env list\n```\n\nYou can easily tell `poetry` to use your current version of python for this folder by running the following command:\n\n```bash\npoetry env use $(which python)\n```\n</details>\n\n\n### Install\n\nClone the repository:\n\n```bash\ngit clone https://github.com/sunchang0124/dp_cgans\ncd dp_cgans\n```\n\nInstall the dependencies:\n\n```bash\npoetry install\n```\n\n### Run\n\nRun the library with the CLI:\n\n```bash\npoetry run dp-cgans gen --help\n```\n\nRun the tests locally:\n\n```bash\npoetry run pytest -s\n```\n\n### Add a new dependency\n\nYou can change the `pyproject.toml` file and run:\n\n```bash\npoetry update\n```\n\nOr you can do it directly with the CLI (e.g. for `pandas` here):\n\n```bash\npoetry add pandas\n```\n\n### Build and publish\n\nBuild:\n\n```bash\npoetry build\n```\n\nPublishing a new release is automatically done by a GitHub Action workflow when a release is created on GitHub:\n\n```bash\npoetry publish\n```\n\n## 📦️ New release process\n\nThe deployment of new releases is done automatically by a GitHub Action workflow when a new release is created on GitHub. To release a new version:\n\n1. Make sure the `PYPI_API_TOKEN` secret has been defined in the GitHub repository (in Settings > Secrets > Actions). You can get an API token from PyPI [here](https://pypi.org/manage/account/).\n2. Increment the `version` number in the `pyproject.toml` file in the root folder of the repository.\n3. Create a new release on GitHub, which will automatically trigger the publish workflow, and publish the new release to PyPI.\n\nYou can also manually trigger the workflow from the Actions tab in your GitHub repository webpage.\n\n## 📚️ References / Further reading \n\nThere are many excellent work on generating synthetic data using GANS and other methods. We list the studies that made great conbributions for the field and inspiring for our work.\n\n##### GANS\n\n   1. Synthetic Data Vault (SDV) [[Paper](https://dai.lids.mit.edu/wp-content/uploads/2018/03/SDV.pdf)] [[Github](https://github.com/sdv-dev/SDV)]\n   2. Modeling Tabular Data using Conditional GAN (a part of SDV) [[Paper](https://arxiv.org/abs/1907.00503)] [[Github](https://github.com/sdv-dev/CTGAN)]\n   3. Wasserstein GAN [[Paper](https://arxiv.org/pdf/1701.07875.pdf)]\n   4. Improved Training of Wasserstein GANs [[Paper](https://papers.nips.cc/paper/2017/file/892c3b1c6dccd52936e27cbd0ff683d6-Paper.pdf)]\n   5. Synthesising Tabular Data using Wasserstein Conditional GANs with Gradient Penalty (WCGAN-GP) [[Paper](http://ceur-ws.org/Vol-2771/AICS2020_paper_57.pdf)]\n   6. PacGAN: The power of two samples in generative adversarial networks [[Paper](https://proceedings.neurips.cc/paper/2018/file/288cc0ff022877bd3df94bc9360b9c5d-Paper.pdf)]\n   7. CTAB-GAN: Effective Table Data Synthesizing [[Paper](https://arxiv.org/pdf/2102.08369.pdf)]\n   8. Conditional Tabular GAN-Based Two-Stage Data Generation Scheme for Short-Term Load Forecasting [[Paper](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=9253644)]\n   9. TabFairGAN: Fair Tabular Data Generation with Generative Adversarial Networks [[Paper](https://arxiv.org/pdf/2109.00666.pdf)]\n   10. Conditional Wasserstein GAN-based Oversampling of Tabular Data for Imbalanced Learning [[Paper](https://arxiv.org/pdf/2008.09202.pdf)]\n\n   ##### Differential Privacy\n\n   1. Tensorflow Privacy [[Github](https://github.com/tensorflow/privacy)]\n   2. Renyi Differential Privacy [[Paper](https://static.googleusercontent.com/media/research.google.com/en//pubs/archive/46029.pdf)]\n   3. DP-CGAN : Differentially Private Synthetic Data and Label Generation [[Paper](https://arxiv.org/pdf/2001.09700.pdf)]\n   4. Differentially Private Generative Adversarial Network [[Paper](https://arxiv.org/pdf/1802.06739.pdf)] [[Github](https://github.com/illidanlab/dpgan)] Another implementation [[Github](https://github.com/civisanalytics/dpwgan)]\n   5. Private Data Generation Toolbox [[Github](https://github.com/BorealisAI/private-data-generation)]\n   6. autodp: Automating differential privacy computation [[Github](https://github.com/yuxiangw/autodp)]\n   7. Differentially Private Synthetic Medical Data Generation using Convolutional GANs [[Paper](https://arxiv.org/pdf/2012.11774.pdf)]\n   8. DTGAN: Differential Private Training for Tabular GANs [[Paper](https://arxiv.org/pdf/2107.02521.pdf)]\n   9. DIFFERENTIALLY PRIVATE SYNTHETIC DATA: APPLIED EVALUATIONS AND ENHANCEMENTS [[Paper](https://arxiv.org/pdf/2011.05537.pdf)]\n   10. FFPDG: FAST, FAIR AND PRIVATE DATA GENERATION [[Paper](https://sdg-quality-privacy-bias.github.io/papers/SDG_paper_19.pdf)]\n\n##### Others\n\n   1. EvoGen: a Generator for Synthetic Versioned RDF [[Paper](http://ceur-ws.org/Vol-1558/paper9.pdf)]\n   2. Generation and evaluation of synthetic patient data [[Paper](https://bmcmedresmethodol.biomedcentral.com/track/pdf/10.1186/s12874-020-00977-1.pdf)]\n   3. Fake It Till You Make It: Guidelines for Effective Synthetic Data Generation [[Paper](https://www.mdpi.com/2076-3417/11/5/2158)]\n   4. Generating and evaluating cross-sectional synthetic electronic healthcare data: Preserving data utility and patient privacy [[Paper](https://onlinelibrary.wiley.com/doi/epdf/10.1111/coin.12427)]\n   5. Synthetic data for open and reproducible methodological research in social sciences and official statistics [[Paper](https://link.springer.com/article/10.1007/s11943-017-0214-8#Sec2)]\n   6. A Study of the Impact of Synthetic Data Generation Techniques on Data Utility using the 1991 UK Samples of Anonymised Records [[Paper](https://unece.org/fileadmin/DAM/stats/documents/ece/ces/ge.46/2017/4_utility_paper.pdf)]\n',
    'author': 'Chang Sun',
    'author_email': 'sunchang0124@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/sunchang0124/dp_cgans',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.10',
}


setup(**setup_kwargs)
