# -*- tab-width: 4; indent-tabs-mode: nil; py-indent-offset: 4 -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
# This file incorporates work covered by the following license notice:
#
#   Licensed to the Apache Software Foundation (ASF) under one or more
#   contributor license agreements. See the NOTICE file distributed
#   with this work for additional information regarding copyright
#   ownership. The ASF licenses this file to you under the Apache
#   License, Version 2.0 (the "License"); you may not use this file
#   except in compliance with the License. You may obtain a copy of
#   the License at http://www.apache.org/licenses/LICENSE-2.0 .
#
from typing import Any, Dict, Iterable, Tuple


def inspect( obj: Any  , out: Any ) -> None: ...
def createSingleServiceFactory( clazz, implementationName: str, serviceNames: Tuple[str, ...] ) -> _FactoryHelper_:...

class _ImplementationHelperEntry:
    def __init__(self, ctor: Any, serviceNames: Iterable[str]):...  
    @property
    def ctor(self) -> Any:...
    @property
    def serviceNames(self) -> Iterable[str]: ...

class ImplementationHelper:
    def __init__(self) -> None:...
    def addImplementation( self, ctor: Any, implementationName: str, serviceNames: Iterable[str] ):...
    def writeRegistryInfo( self, regKey: Any, smgr: Any ) -> int: ...
    def getComponentFactory( self, implementationName: str , regKey: Any, smgr: Any ) -> Any:...
    def getSupportedServiceNames( self, implementationName: str ) -> Iterable[str]:...
    def supportsService( self, implementationName: str, serviceName: str ) -> Iterable[str]:...


class ImplementationEntry:
    def __init__(self, implName: str, supportedServices: Iterable[str], clazz: Any ) -> None:...
    @property
    def impName(self) -> str:...
    @property
    def supportedServices(self) -> Iterable[str]: ...
    @property
    def clazz(self) -> Any: ...
    
def writeRegistryInfoHelper( smgr: Any, regKey: Any, seqEntries: Iterable[ImplementationEntry] ) -> None:...
def systemPathToFileUrl( systemPath: str ) -> str:
    "returns a file-url for the given system path"
def fileUrlToSystemPath( url: str )-> str:
    "returns a system path (determined by the system, the python interpreter is running on)"
def absolutize( path: str, relativeUrl: str ) -> str:
    "returns an absolute file url from the given urls"
def getComponentFactoryHelper( implementationName: str, smgr: Any, regKey: Any, seqEntries ) -> Any: ...
def addComponentsToContext( toBeExtendedContext: Any, contextRuntime: Any, componentUrls: Iterable[str], loaderName: str ) -> None:...

class Base:
    def getTypes( self ) -> Tuple[object, ...]:...
    def getImplementationId(self) -> Tuple[int, ...]:...

class CurrentContext:
    """a current context implementation, which first does a lookup in the given
       hashmap and if the key cannot be found, it delegates to the predecessor
       if available
    """
    def __init__( self, oldContext: Any, hashMap: Dict[str, Any] ) -> None:...
    def getValueByName( self, name: str ) -> Any:...
    @property
    def hashMap(self) -> Dict[str, Any]: ...
    @property
    def oldcontent(self) -> Any: ...

# -------------------------------------------------
# implementation details
# -------------------------------------------------
class _FactoryHelper_:
    def __init__( self, clazz: Any, implementationName: str, serviceNames: Iterable[str]) -> None:...
    def getImplementationName( self ) -> str:...
    def supportsService( self, ServiceName: str ) -> bool:...
    def getSupportedServiceNames( self ) -> Iterable[str]:...
    def createInstanceWithContext( self, context: Any ) -> Any:...
    def createInstanceWithArgumentsAndContext( self, args: Tuple[Any, ...], context: Any ) -> Any:...

