ble_address_type = {
    'gap_address_type_public': 0,
    'gap_address_type_random': 1
}
gap_discoverable_mode = {
    'non_discoverable': 0x00,
    'limited_discoverable': 0x01,
    'general_discoverable': 0x02,
    'broadcast': 0x03,
    'user_data': 0x04,
    'enhanced_broadcasting': 0x80
}
gap_connectable_mode = {
    'non_connectable': 0x00,
    'directed_connectable': 0x01,
    'undirected_connectable': 0x02,
    'scannable_non_connectable': 0x03,
}
gap_discover_mode = {
    'limited': 0x00,
    'generic': 0x01,
    'observation': 0x02,
}
bonding = {  # create bonding if devices not already bonded
    'do_not_create_bonding': 0x00,
    'create_bonding': 0x01,
}
bondable = {
    'no': 0x00,
    'yes': 0x01,
}
connection_status_flag = {
    'connected': 0x01,
    'encrypted': 0x02,
    'completed': 0x04,
    'parameters_change': 0x08,
}
scan_response_packet_type = {
    0x00: 'connectable_advertisement_packet',
    0x02: 'non-connectable_advertisement_packet',
    0x04: 'scan_response_packet',
    0x06: 'discoverable_advertisement_packet',
}
scan_response_data_type = {
    0x01: 'flags',
    0x02: 'incomplete_list_16-bit_service_class_uuids',
    0x03: 'complete_list_16-bit_service_class_uuids',
    0x04: 'incomplete_list_32-bit_service_class_uuids',
    0x05: 'complete_list_32-bit_service_class_uuids',
    0x06: 'incomplete_list_128-bit_service_class_uuids',
    0x07: 'complete_list_128-bit_service_class_uuids',
    0x08: 'shortened_local_name',
    0x09: 'complete_local_name',
    0x0A: 'tx_power_level',
    0x0D: 'class_of_device',
    0x0E: 'simple_pairing_hash_c/c-192',
    0x0F: 'simple_pairing_randomizer_r/r-192',
    0x10: 'device_id/security_manager_tk_value',
    0x11: 'security_manager_out_of_band_flags',
    0x12: 'slave_connection_interval_range',
    0x14: 'list_of_16-bit_service_solicitation_uuids',
    0x1F: 'list_of_32-bit_service_solicitation_uuids',
    0x15: 'list_of_128-bit_service_solicitation_uuids',
    0x16: 'service_data/service_data-16-bit_uuid',
    0x20: 'service_data-32-bit_uuid',
    0x21: 'service_data-128-bit_uuid',
    0x22: 'LE_secure_connections_confirmation_value',
    0x23: 'LE_secure_connections_random_value',
    0x17: 'public_target_address',
    0x18: 'random_target_address',
    0x19: 'appearance',
    0x1A: 'advertising_interval',
    0x1B: 'LE_bluetooth_device_address',
    0x1C: 'LE_role',
    0x1D: 'simple_pairing_hash_c-256',
    0x1E: 'simple_pairing_randomizer_r-256',
    0x3D: '3D_information_data',
    0xFF: 'manufacturer_specific_data',
}

# GATT
gatt_service_uuid = {
    'generic_access_profile': bytearray([0x18, 0x00]),
    'generic_attribute_profile': bytearray([0x18, 0x01]),
}
gatt_attribute_type_uuid = {
    'primary_service': bytearray([0x28, 0x00]),
    'secondary_service': bytearray([0x28, 0x01]),
    'include': bytearray([0x28, 0x02]),
    'characteristic': bytearray([0x28, 0x03]),
}
gatt_characteristic_descriptor_uuid = {
    'characteristic_extended_properties': bytearray([0x29, 0x00]),
    'characteristic_user_description': bytearray([0x29, 0x01]),
    'client_characteristic_configuration': bytearray([0x29, 0x02]),
    'server_characteristic_configuration': bytearray([0x29, 0x03]),
    'characteristic_format': bytearray([0x29, 0x04]),
    'characteristic_aggregate_format': bytearray([0x29, 0x05]),
}
gatt_characteristic_type_uuid = {
    'aerobic_heart_rate_lower_limit': bytearray([0x2A, 0x7E]),
    'aerobic_heart_rate_upper_limit': bytearray([0x2A, 0x84]),
    'aerobic_threshold': bytearray([0x2A, 0x7F]),
    'age': bytearray([0x2A, 0x80]),
    'aggregate': bytearray([0x2A, 0x5A]),
    'alert_category_id': bytearray([0x2A, 0x43]),
    'alert_category_id_bit_mask': bytearray([0x2A, 0x42]),
    'alert_level': bytearray([0x2A, 0x06]),
    'alert_notification_control_point': bytearray([0x2A, 0x44]),
    'alert_status': bytearray([0x2A, 0x3F]),
    'altitude': bytearray([0x2A, 0xB3]),
    'anaerobic_heart_rate_lower_limit': bytearray([0x2A, 0x81]),
    'anaerobic_heart_rate_upper_limit': bytearray([0x2A, 0x82]),
    'anaerobic_threshold': bytearray([0x2A, 0x83]),
    'analog': bytearray([0x2A, 0x58]),
    'apparent_wind_direction': bytearray([0x2A, 0x73]),
    'apparent_wind_speed': bytearray([0x2A, 0x72]),
    'appearance': bytearray([0x2A, 0x01]),
    'barometric_pressure_trend': bytearray([0x2A, 0xA3]),
    'battery_level': bytearray([0x2A, 0x19]),
    'blood_pressure_feature': bytearray([0x2A, 0x49]),
    'blood_pressure_measurement': bytearray([0x2A, 0x35]),
    'body_composition_feature': bytearray([0x2A, 0x9B]),
    'body_composition_measurement': bytearray([0x2A, 0x9C]),
    'body_sensor_location': bytearray([0x2A, 0x38]),
    'bond_management_control_point': bytearray([0x2A, 0xA4]),
    'bond_management_feature': bytearray([0x2A, 0xA5]),
    'boot_keyboard_input_report': bytearray([0x2A, 0x22]),
    'boot_keyboard_output_report': bytearray([0x2A, 0x32]),
    'boot_mouse_input_report': bytearray([0x2A, 0x33]),
    'central_address_resolution_support': bytearray([0x2A, 0xA6]),
    'cgm_feature': bytearray([0x2A, 0xA8]),
    'cgm_measurement': bytearray([0x2A, 0xA7]),
    'cgm_session_run_time': bytearray([0x2A, 0xAB]),
    'cgm_session_start_time': bytearray([0x2A, 0xAA]),
    'cgm_specific_ops_control_point': bytearray([0x2A, 0xAC]),
    'cgm_status': bytearray([0x2A, 0xA9]),
    'csc_feature': bytearray([0x2A, 0x5C]),
    'csc_measurement': bytearray([0x2A, 0x5B]),
    'current_time': bytearray([0x2A, 0x2B]),
    'cycling_power_control_point': bytearray([0x2A, 0x66]),
    'cycling_power_feature': bytearray([0x2A, 0x65]),
    'cycling_power_measurement': bytearray([0x2A, 0x63]),
    'cycling_power_vector': bytearray([0x2A, 0x64]),
    'database_change_increment': bytearray([0x2A, 0x99]),
    'date_of_birth': bytearray([0x2A, 0x85]),
    'date_of_threshold_assessment': bytearray([0x2A, 0x86]),
    'date_time': bytearray([0x2A, 0x08]),
    'day_date_time': bytearray([0x2A, 0x0A]),
    'day_of_week': bytearray([0x2A, 0x09]),
    'descriptor_value_changed': bytearray([0x2A, 0x7D]),
    'device_name': bytearray([0x2A, 0x00]),
    'dew_point': bytearray([0x2A, 0x7B]),
    'digital': bytearray([0x2A, 0x56]),
    'dst_offset': bytearray([0x2A, 0x0D]),
    'elevation': bytearray([0x2A, 0x6C]),
    'email_address': bytearray([0x2A, 0x87]),
    'exact_time_256': bytearray([0x2A, 0x0C]),
    'fat_burn_heart_rate_lower_limit': bytearray([0x2A, 0x88]),
    'fat_burn_heart_rate_upper_limit': bytearray([0x2A, 0x89]),
    'firmware_revision_string': bytearray([0x2A, 0x26]),
    'first_name': bytearray([0x2A, 0x8A]),
    'five_zone_heart_rate_limits': bytearray([0x2A, 0x8B]),
    'floor_number': bytearray([0x2A, 0xB2]),
    'gender': bytearray([0x2A, 0x8C]),
    'glucose_feature': bytearray([0x2A, 0x51]),
    'glucose_measurement': bytearray([0x2A, 0x18]),
    'glucose_measurement_context': bytearray([0x2A, 0x34]),
    'gust_factor': bytearray([0x2A, 0x74]),
    'hardware_revision_string': bytearray([0x2A, 0x27]),
    'heart_rate_control_point': bytearray([0x2A, 0x39]),
    'heart_rate_max': bytearray([0x2A, 0x8D]),
    'heart_rate_measurement': bytearray([0x2A, 0x37]),
    'heat_index': bytearray([0x2A, 0x7A]),
    'height': bytearray([0x2A, 0x8E]),
    'hid_control_point': bytearray([0x2A, 0x4C]),
    'hid_information': bytearray([0x2A, 0x4A]),
    'hip_circumference': bytearray([0x2A, 0x8F]),
    'http_control_point': bytearray([0x2A, 0xBA]),
    'http_entity_body': bytearray([0x2A, 0xB9]),
    'http_headers': bytearray([0x2A, 0xB7]),
    'http_status_code': bytearray([0x2A, 0xB8]),
    'https_security': bytearray([0x2A, 0xBB]),
    'humidity': bytearray([0x2A, 0x6F]),
    'ieee_11073-20601_regulatory_certification_data_list': bytearray([0x2A, 0x2A]),  # noqa
    'indoor_positioning_configuration': bytearray([0x2A, 0xAD]),
    'intermediate_cuff_pressure': bytearray([0x2A, 0x36]),
    'intermediate_temperature': bytearray([0x2A, 0x1E]),
    'irradiance': bytearray([0x2A, 0x77]),
    'language': bytearray([0x2A, 0xA2]),
    'last_name': bytearray([0x2A, 0x90]),
    'latitude': bytearray([0x2A, 0xAE]),
    'ln_control_point': bytearray([0x2A, 0x6B]),
    'ln_feature': bytearray([0x2A, 0x6A]),
    'local_east_coordinate': bytearray([0x2A, 0xB1]),
    'local_north_coordinate': bytearray([0x2A, 0xB0]),
    'local_time_information': bytearray([0x2A, 0x0F]),
    'location_and_speed': bytearray([0x2A, 0x67]),
    'location_name': bytearray([0x2A, 0xB5]),
    'longitude': bytearray([0x2A, 0xAF]),
    'magnetic_declination': bytearray([0x2A, 0x2C]),
    'magnetic_flux_density_2D': bytearray([0x2A, 0xA0]),
    'magnetic_flux_density_3D': bytearray([0x2A, 0xA1]),
    'manufacturer_name_string': bytearray([0x2A, 0x29]),
    'maximum_recommended_heart_rate': bytearray([0x2A, 0x91]),
    'measurement_interval': bytearray([0x2A, 0x21]),
    'model_number_string': bytearray([0x2A, 0x24]),
    'navigation': bytearray([0x2A, 0x68]),
    'new_alert': bytearray([0x2A, 0x46]),
    'object_action_control_point': bytearray([0x2A, 0xC5]),
    'object_changed': bytearray([0x2A, 0xC8]),
    'object_first_created': bytearray([0x2A, 0xC1]),
    'object_id': bytearray([0x2A, 0xC3]),
    'object_last_modified': bytearray([0x2A, 0xC2]),
    'object_list_control_point': bytearray([0x2A, 0xC6]),
    'object_list_filter': bytearray([0x2A, 0xC7]),
    'object_name': bytearray([0x2A, 0xBE]),
    'object_properties': bytearray([0x2A, 0xC4]),
    'object_size': bytearray([0x2A, 0xC0]),
    'object_type': bytearray([0x2A, 0xBF]),
    'ots_feature': bytearray([0x2A, 0xBD]),
    'peripheral_preferred_connection_parameters': bytearray([0x2A, 0x04]),
    'peripheral_privacy_flag': bytearray([0x2A, 0x02]),
    'plx_continuous_measurement': bytearray([0x2A, 0x5F]),
    'plx_features': bytearray([0x2A, 0x60]),
    'plx_spot_check_measurement': bytearray([0x2A, 0x5E]),
    'pnp_id': bytearray([0x2A, 0x50]),
    'pollen_concentration': bytearray([0x2A, 0x75]),
    'position_quality': bytearray([0x2A, 0x69]),
    'pressure': bytearray([0x2A, 0x6D]),
    'protocol_mode': bytearray([0x2A, 0x4E]),
    'rainfall': bytearray([0x2A, 0x78]),
    'reconnection_address': bytearray([0x2A, 0x03]),
    'record_access_control_point': bytearray([0x2A, 0x52]),
    'reference_time_information': bytearray([0x2A, 0x14]),
    'report': bytearray([0x2A, 0x4D]),
    'report_map': bytearray([0x2A, 0x4B]),
    'resting_heart_rate': bytearray([0x2A, 0x92]),
    'ringer_control_point': bytearray([0x2A, 0x40]),
    'ringer_setting': bytearray([0x2A, 0x41]),
    'rsc_feature': bytearray([0x2A, 0x54]),
    'rsc_measurement': bytearray([0x2A, 0x53]),
    'sc_control_point': bytearray([0x2A, 0x55]),
    'scan_interval_window': bytearray([0x2A, 0x4F]),
    'scan_refresh': bytearray([0x2A, 0x31]),
    'sensor_location': bytearray([0x2A, 0x5D]),
    'serial_number_string': bytearray([0x2A, 0x25]),
    'service_changed': bytearray([0x2A, 0x05]),
    'software_revision_string': bytearray([0x2A, 0x28]),
    'sport_type_for_aerobic_and_anaerobic_thresholds': bytearray([0x2A, 0x93]),
    'supported_new_alert_category': bytearray([0x2A, 0x47]),
    'supported_unread_alert_category': bytearray([0x2A, 0x48]),
    'system_id': bytearray([0x2A, 0x23]),
    'tds_control_point': bytearray([0x2A, 0xBC]),
    'temperature': bytearray([0x2A, 0x6E]),
    'temperature_measurement': bytearray([0x2A, 0x1C]),
    'temperature_type': bytearray([0x2A, 0x1D]),
    'three_zone_heart_rate_limits': bytearray([0x2A, 0x94]),
    'time_accuracy': bytearray([0x2A, 0x12]),
    'time_source': bytearray([0x2A, 0x13]),
    'time_update_control_point': bytearray([0x2A, 0x16]),
    'time_update_state': bytearray([0x2A, 0x17]),
    'time_with_dst': bytearray([0x2A, 0x11]),
    'time_zone': bytearray([0x2A, 0x0E]),
    'true_wind_direction': bytearray([0x2A, 0x71]),
    'true_wind_speed': bytearray([0x2A, 0x70]),
    'two_zone_heart_rate_limit': bytearray([0x2A, 0x95]),
    'tx_power_level': bytearray([0x2A, 0x07]),
    'uncertainty': bytearray([0x2A, 0xB4]),
    'unread_alert_status': bytearray([0x2A, 0x45]),
    'uri': bytearray([0x2A, 0xB6]),
    'user_control_point': bytearray([0x2A, 0x9F]),
    'user_index': bytearray([0x2A, 0x9A]),
    'uv_index': bytearray([0x2A, 0x76]),
    'vo2_max': bytearray([0x2A, 0x96]),
    'waist_circumference': bytearray([0x2A, 0x97]),
    'weight': bytearray([0x2A, 0x98]),
    'weight_measurement': bytearray([0x2A, 0x9D]),
    'weight_scale_feature': bytearray([0x2A, 0x9E]),
    'wind_chill': bytearray([0x2A, 0x79]),
}
