from setuptools import setup
from os import path

this_directory = path.abspath(path.dirname(__file__))

with open(path.join(this_directory, 'README'), encoding='utf-8') as f:
    long_description = f.read()

setup(
  name = 'webkage',
  packages = ['webkage'],
  version = '0.4',
  author = 'Oloruntobi Balogun',
  author_email = 'tobitobitobiwhy@gmail.com',
  url = 'https://github.com/laybug/webkage',
  download_url = 'https://github.com/LayBug/webkage/archive/v0.4.tar.gz',
  keywords = ['Framework', 'Web', 'Wsgi'],
  install_requires=[
          'jinja2'
      ],
  classifiers=[
    'Development Status :: 3 - Alpha',   
    'Intended Audience :: Developers',  
    'Topic :: Software Development :: Build Tools',
    'License :: OSI Approved :: MIT License',
    'Programming Language :: Python :: 3',
    'Programming Language :: Python :: 3.4',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
    'Programming Language :: Python :: 3.7',
    'Programming Language :: Python :: 3.8',
    'Programming Language :: Python :: 3.9',
    
  ],
  long_description=long_description,
  long_description_content_type='text/markdown',
  
)
