"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.awsCredentialStep = void 0;
function awsCredentialStep(stepName, props) {
    const params = {};
    // Neither of these checks should occur, since this method is internal,
    // but they are here just in case.
    if (!props.gitHubActionRoleArn && !(props.accessKeyId && props.secretAccessKey)) {
        throw new Error('AWS authentication not found via OIDC or GitHub secrets');
    }
    if (props.gitHubActionRoleArn && (props.accessKeyId || props.secretAccessKey)) {
        throw new Error('Please provide one method of authentication, not both');
    }
    params['aws-region'] = props.region;
    params['role-duration-seconds'] = 30 * 60;
    // Session tagging requires the role to have `sts:TagSession` permissions,
    // which CDK bootstrapped roles do not currently have.
    params['role-skip-session-tagging'] = props.roleSkipSessionTagging ?? true;
    if (props.gitHubActionRoleArn) {
        params['role-to-assume'] = props.gitHubActionRoleArn;
    }
    else {
        params['aws-access-key-id'] = props.accessKeyId;
        params['aws-secret-access-key'] = props.secretAccessKey;
        if (props.sessionToken) {
            params['aws-session-token'] = props.sessionToken;
        }
        if (props.roleToAssume) {
            params['role-to-assume'] = props.roleToAssume;
            params['role-external-id'] = 'Pipeline';
        }
    }
    return {
        name: stepName,
        uses: 'aws-actions/configure-aws-credentials@v1',
        with: params,
    };
}
exports.awsCredentialStep = awsCredentialStep;
//# sourceMappingURL=data:application/json;base64,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