from typing import Optional
from selenium import webdriver
from selenium.webdriver.firefox.firefox_binary import FirefoxBinary
import time
import random

class ExploitBuilder:
    def __init__(self, protocol: str, hostname: str, stealth: Optional[bool]=False, firefox_binary_path: Optional[str]="/opt/firefox/firefox"):
        self.protocol = protocol
        self.hostname = hostname
        binary = FirefoxBinary(firefox_binary_path)
        self.driver = webdriver.Firefox(firefox_binary=binary)
        self.stealth = stealth

    def get(self, endpoint: str):
        self.driver.get(self._format(endpoint))
        return self

    def login(self, endpoint: str, username: str, password: str, username_id: str, password_id: str, submit_id: str):
        (
            self.get(endpoint)
                .type_by_id(username_id, username)
                .type_by_id(password_id, password)
                .click(submit_id)
        )
        return self

    def type_by_id(self, field: str, entry: str):
        self.wait_for_stealth(entry)
        element = self.driver.find_element_by_id(field)
        element.send_keys(entry)
        return self

    def get_contents(self, field: str):
        return self.driver.find_element_by_id(field).text

    def click(self, button_id: str):
        self.driver.find_element_by_id(button_id).click()
        return self

    def _format(self, endpoint: str) -> str:
        return f"{self.protocol}://{self.hostname}{endpoint}"

    def dump_cookies(self):
        for cookie in self.driver.get_cookies():
            print(cookie)
        return self

    def wait_for_stealth(self, entry=""):
        if self.stealth:
            time.sleep(len(entry) / 5 + random.uniform(0.2, 1))
