"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            coreDnsComputeType: (_b = props.coreDnsComputeType) !== null && _b !== void 0 ? _b : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_eks_FargateClusterProps(props);
        this.defaultProfile = this.addFargateProfile((_d = (_c = props.defaultProfile) === null || _c === void 0 ? void 0 : _c.fargateProfileName) !== null && _d !== void 0 ? _d : (props.defaultProfile ? 'custom' : 'default'), (_e = props.defaultProfile) !== null && _e !== void 0 ? _e : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
_a = JSII_RTTI_SYMBOL_1;
FargateCluster[_a] = { fqn: "@aws-cdk/aws-eks.FargateCluster", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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