"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
/**
 * An Origin that represents a group.
 *
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 *
 * @stability stable
 */
class OriginGroup {
    /**
     * @stability stable
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @stability stable
     */
    bind(scope, options) {
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
exports.OriginGroup = OriginGroup;
//# sourceMappingURL=data:application/json;base64,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