/**
 * sample_random_test.sv
 * Random stimulus test for sample design
 * 
 * Module:      sample_design
 * Design File: sample_design.v
 * Project:     test_project
 * 
 * Description:
 *     Generates randomized transactions to verify design functionality
 *     under various input conditions. Tests data path integrity,
 *     control signal handling, and edge cases.
 * 
 * Sequence Used:
 *     - sample_random_seq
 *     - Generates fully randomized transactions
 * 
 * Config Inputs:
 *     cfg.num_transactions  : Number of random transactions
 *     cfg.data_width        : Width of data bus
 *     cfg.enable_errors     : Enable error injection
 */

`ifndef SAMPLE_RANDOM_TEST_DEF
`define SAMPLE_RANDOM_TEST_DEF

class sample_random_test extends sample_base_test;
  
  `uvm_component_utils(sample_random_test)
  
  /**
   * Constructor: new
   * Creates test instance
   */
  function new(string name = "sample_random_test", uvm_component parent = null);
    super.new(name, parent);
  endfunction
  
  /**
   * Function: build_phase
   * Override to set specific configuration
   */
  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
    cfg.num_transactions = 1000;
    cfg.enable_errors = 1;
  endfunction
  
  /**
   * Task: run_phase
   * Executes the random test sequence
   */
  virtual task run_phase(uvm_phase phase);
    sample_random_seq seq;
    
    phase.raise_objection(this);
    
    seq = sample_random_seq::type_id::create("seq");
    seq.start(env.input_agent.sequencer);
    
    phase.drop_objection(this);
  endtask
  
endclass

`endif // SAMPLE_RANDOM_TEST_DEF
