/**
 * sample_directed_test.sv
 * Directed test case for specific scenarios
 * 
 * Module:      sample_design
 * Design File: sample_design.v
 * Project:     test_project
 * 
 * Description:
 *     Executes directed test scenarios with specific data patterns
 *     to verify corner cases, boundary conditions, and protocol
 *     compliance.
 * 
 * Test Scenarios:
 *     1. Minimum/maximum value handling
 *     2. Zero crossing behavior
 *     3. Back-to-back transactions
 *     4. Protocol violations (negative testing)
 */

`ifndef SAMPLE_DIRECTED_TEST_DEF
`define SAMPLE_DIRECTED_TEST_DEF

class sample_directed_test extends sample_base_test;
  
  `uvm_component_utils(sample_directed_test)
  
  function new(string name = "sample_directed_test", uvm_component parent = null);
    super.new(name, parent);
  endfunction
  
  virtual task run_phase(uvm_phase phase);
    sample_directed_seq seq;
    
    phase.raise_objection(this);
    
    `uvm_info(get_type_name(), "Starting directed test", UVM_LOW)
    
    seq = sample_directed_seq::type_id::create("seq");
    seq.start(env.input_agent.sequencer);
    
    #100ns; // Wait for responses
    
    phase.drop_objection(this);
  endtask
  
endclass

`endif // SAMPLE_DIRECTED_TEST_DEF
