/**
 * File: sample_top_tb.sv
 * Brief: Top-level testbench for sample design
 * 
 * This is a simple testbench wrapper that can exist in both
 * env and pyenv directories for mixed-language testing.
 */

`ifndef SAMPLE_TOP_TB_DEF
`define SAMPLE_TOP_TB_DEF

module sample_top_tb;

  // Clock and reset
  logic clk;
  logic rst_n;
  
  // DUT signals
  logic [31:0] data_in;
  logic [31:0] data_out;
  logic valid_in;
  logic valid_out;
  
  // Clock generation
  initial begin
    clk = 0;
    forever #5ns clk = ~clk;
  end
  
  // Reset generation
  initial begin
    rst_n = 0;
    #100ns rst_n = 1;
  end

endmodule

`endif // SAMPLE_TOP_TB_DEF
