#!/usr/bin/env python3
"""
Setup script for sphinx-doc package.
"""
from setuptools import setup, find_packages
from pathlib import Path

# Read the long description from README
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text(encoding='utf-8')

setup(
    name="sphinx-doc",
    version="1.0.7",
    author="Sanjay Singh",
    author_email="your.email@example.com",
    description="Automated Sphinx documentation generator for SystemVerilog and Python UVM testbenches",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/sphinx-doc",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Documentation",
        "Topic :: Software Development :: Code Generators",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.8",
    install_requires=[
        "sphinx>=5.0.0",
        "sphinx-rtd-theme>=1.0.0",
        "sphinx-verilog-domain>=0.2.0",
        "pyuvm>=2.8.0",
        "cocotb>=1.6.0",
    ],
    entry_points={
        "console_scripts": [
            "sphinx-doc=sphinx_doc.cli:main",
        ],
    },
    include_package_data=True,
    package_data={
        "sphinx_doc": ["test/*"],
    },
    keywords="systemverilog sphinx documentation uvm testbench verification",
    project_urls={
        "Bug Reports": "https://github.com/yourusername/sphinx-doc/issues",
        "Source": "https://github.com/yourusername/sphinx-doc",
    },
)
