def цветной_терминал(текст, цвет=None, стиль=None):
    def rgb(R, G, B):
        return R, G, B  

    ЦВЕТА = {
        'красный': rgb(255, 0, 0),
        'оранжевый': rgb(255, 81, 0),
        'жёлтый': rgb(255, 255, 25),
        'зелёный': rgb(43, 152, 19)
    }

    СТИЛИ = {
        'ж': "1", # жирный
        'т': "2", # тонкий
        'к': "3", # курсивый
        'п': "4", # подчёркнутый
        'з': "9", # зачёркнутый
    }

    def определить_стиль():
        if стиль == None:
            return ''
        ответ = ""
        for буква in стиль:
            if буква in СТИЛИ.keys():
                ответ += ";" + СТИЛИ.get(буква)
        return ответ

    # Чтобы остановить выполнение функции при неудобных условиях (например, если может возникнуть ошибка), прописываем это условие в if и после него делаем return
    if цвет not in ЦВЕТА.keys():
        R = G = B = 200
    else:
        R, G, B = ЦВЕТА.get(цвет)
    стиль_чистый = определить_стиль()
    ответ = f'\x1B[38;2;{R};{G};{B}{стиль_чистый}m{текст}\x1B[0m'
    return ответ

def список_файлов(папка, подпапки=False):
    import os
    ответ = {
        "статус": "",
        "файлы": [],
        "список файлов": [],
        "папки": []
    }
    предварительный_список = list(os.walk(папка))
    if len(предварительный_список) == 0:
        ответ["статус"] = 'Такой папки не существует'
        return ответ
    корневая_папка = предварительный_список[0][0]
    папки = предварительный_список[0][1]
    файлы = предварительный_список[0][2]
    if len(папки) == len(файлы) == 0:
        ответ["статус"] = 'Выбранная папка пуста'
        return ответ
    
    ответ["статус"] = "ок"
    for файл in файлы:
        расширение = "." + файл.split(".")[-1]
        ответ["файлы"].append({
            "путь": f'{корневая_папка}\\{файл}',
            "папка": f'{корневая_папка}',
            "расширение": расширение,
            "имя": файл[:len(расширение) * - 1]
        })
        ответ["список файлов"].append(f'{корневая_папка}\\{файл}')

    for папка in папки:
        ответ["папки"].append(f'{корневая_папка}\\{папка}')
        if подпапки:
            # рекурсивным называется такой запуск, когда функция вызывает саму себя
            рекурсия = список_файлов(f'{корневая_папка}\\{папка}', подпапки)
            ответ["файлы"].extend(рекурсия["файлы"])
            ответ["папки"].extend(рекурсия["папки"])
            ответ["список файлов"].extend(рекурсия["список файлов"])

    return ответ

if __name__ == '__main__':
    # print(цветной_терминал("красный жирный курсивый текст", цвет="красный"))
    # print(цветной_терминал("зелёный жирный курсивый подчёркнутый зачёркнутый текст", "зелёный", "жкпз"))
    # print("обычный текст")
    все_файлы = список_файлов(r"C:\Users\Тарасов Никита\Downloads")
    for файл in все_файлы:
        print(файл.get("имя"))