"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = exports.DnsResponseType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum of DNS service discovery response type
 */
var DnsResponseType;
(function (DnsResponseType) {
    /**
     * DNS resolver returns a loadbalanced set of endpoints and the traffic would be sent to the given endpoints.
     * It would not drain existing connections to other endpoints that are not part of this list.
     */
    DnsResponseType["LOAD_BALANCER"] = "LOADBALANCER";
    /**
     * DNS resolver is returning all the endpoints.
     * This also means that if an endpoint is missing, it would drain the current connections to the missing endpoint.
     */
    DnsResponseType["ENDPOINTS"] = "ENDPOINTS";
})(DnsResponseType = exports.DnsResponseType || (exports.DnsResponseType = {}));
/**
 * Provides the Service Discovery method a VirtualNode uses
 */
class ServiceDiscovery {
    /**
     * Returns DNS based service discovery
     *
     * @param hostname
     * @param responseType Specifies the DNS response type for the virtual node.
     *  The default is `DnsResponseType.LOAD_BALANCER`.
     */
    static dns(hostname, responseType) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_DnsResponseType(responseType);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dns);
            }
            throw error;
        }
        return new DnsServiceDiscovery(hostname, responseType);
    }
    /**
     * Returns Cloud Map based service discovery
     *
     * @param service The AWS Cloud Map Service to use for service discovery
     * @param instanceAttributes A string map that contains attributes with values that you can use to
     *  filter instances by any custom attribute that you specified when you
     *  registered the instance. Only instances that match all of the specified
     *  key/value pairs will be returned.
     */
    static cloudMap(service, instanceAttributes) {
        return new CloudMapServiceDiscovery(service, instanceAttributes);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
_a = JSII_RTTI_SYMBOL_1;
ServiceDiscovery[_a] = { fqn: "@aws-cdk/aws-appmesh.ServiceDiscovery", version: "1.182.0" };
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname, responseType) {
        super();
        this.hostname = hostname;
        this.responseType = responseType;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
                responseType: this.responseType,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(service, instanceAttributes) {
        super();
        this.service = service;
        this.instanceAttributes = instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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