"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const resourcegroups = require("aws-cdk-lib/aws-resourcegroups");
const utils = require("../common/utils");
class BaseStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.stage = props.stage;
    }
    addBaseTags(model, props) {
        utils.addBaseTags(model, props);
    }
    createResourcesGroup() {
        let cfnGroup = new resourcegroups.CfnGroup(this, `resources-group-${this.stackName}`, {
            name: this.stackName,
            resourceQuery: {
                query: {
                    stackIdentifier: this.stackId,
                },
            },
        });
        return cfnGroup;
    }
}
exports.BaseStack = BaseStack;
_a = JSII_RTTI_SYMBOL_1;
BaseStack[_a] = { fqn: "neulabs-cdk-constructs.stacks.BaseStack", version: "0.1.6" };
//# sourceMappingURL=data:application/json;base64,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