"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpnPort = exports.TransportProtocol = void 0;
/**
 * Transport protocol for client VPN.
 *
 * @stability stable
 */
var TransportProtocol;
(function (TransportProtocol) {
    TransportProtocol["TCP"] = "tcp";
    TransportProtocol["UDP"] = "udp";
})(TransportProtocol = exports.TransportProtocol || (exports.TransportProtocol = {}));
/**
 * Port for client VPN.
 *
 * @stability stable
 */
var VpnPort;
(function (VpnPort) {
    VpnPort[VpnPort["HTTPS"] = 443] = "HTTPS";
    VpnPort[VpnPort["OPENVPN"] = 1194] = "OPENVPN";
})(VpnPort = exports.VpnPort || (exports.VpnPort = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xpZW50LXZwbi1lbmRwb2ludC10eXBlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsaWVudC12cG4tZW5kcG9pbnQtdHlwZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFzQkEsSUFBWSxpQkFLWDtBQUxELFdBQVksaUJBQWlCO0lBRTNCLGdDQUFXLENBQUE7SUFFWCxnQ0FBVyxDQUFBO0FBQ2IsQ0FBQyxFQUxXLGlCQUFpQixHQUFqQix5QkFBaUIsS0FBakIseUJBQWlCLFFBSzVCOzs7Ozs7QUFHRCxJQUFZLE9BS1g7QUFMRCxXQUFZLE9BQU87SUFFakIseUNBQVcsQ0FBQTtJQUVYLDhDQUFjLENBQUE7QUFDaEIsQ0FBQyxFQUxXLE9BQU8sR0FBUCxlQUFPLEtBQVAsZUFBTyxRQUtsQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElEZXBlbmRhYmxlLCBJUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IElDb25uZWN0YWJsZSB9IGZyb20gJy4vY29ubmVjdGlvbnMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJQ2xpZW50VnBuRW5kcG9pbnQgZXh0ZW5kcyBJUmVzb3VyY2UsIElDb25uZWN0YWJsZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlbmRwb2ludElkOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGFyZ2V0TmV0d29ya3NBc3NvY2lhdGVkOiBJRGVwZW5kYWJsZTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUNsaWVudFZwbkNvbm5lY3Rpb25IYW5kbGVyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZ1bmN0aW9uTmFtZTogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmdW5jdGlvbkFybjogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gVHJhbnNwb3J0UHJvdG9jb2wge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVENQID0gJ3RjcCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFVEUCA9ICd1ZHAnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIFZwblBvcnQge1xuICAgICAgICAgICAgICBcbiAgSFRUUFMgPSA0NDMsXG4gICAgICAgICAgICAgICAgXG4gIE9QRU5WUE4gPSAxMTk0LFxufVxuIl19