"""
This is library of space group information for all space groups.
Presently only the standard setting is available.
"""



class Sg1:
    def __init__(self,cell_choice='standard'):
        self.no = 1
        self.name = "P1"
        self.crystal_system = "triclinic"
        self.Laue = "-1"
        self.nsymop = 1
        self.nuniq = 1
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [[[1,0,0],[0,1,0],[0,0,1]],
                    ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                ]

class Sg2:
    def __init__(self,cell_choice='standard'):
        self.no = 2
        self.name = "P-1"
        self.crystal_system = "triclinic"
        self.Laue = "-1"
        self.nsymop = 2
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg3:
    def __init__(self,cell_choice='standard'):
        self.no = 3
        self.name = "P2"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 2
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg4:
    def __init__(self,cell_choice='standard'):
        self.no = 4
        self.name = "P21"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 2
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                ]

class Sg5:
    def __init__(self,cell_choice='standard'):
        self.no = 5
        self.name = "C2"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 4
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg6:
    def __init__(self,cell_choice='standard'):
        self.no = 6
        self.name = "Pm"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 2
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg7:
    def __init__(self,cell_choice='standard'):
        self.no = 7
        self.name = "Pc"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 2
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                ]

class Sg8:
    def __init__(self,cell_choice='standard'):
        self.no = 8
        self.name = "Cm"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 4
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg9:
    def __init__(self,cell_choice='standard'):
        self.no = 9
        self.name = "Cc"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 4
        self.nuniq = 2
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                ]

class Sg10:
    def __init__(self,cell_choice='standard'):
        self.no = 10
        self.name = "P2/m"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg11:
    def __init__(self,cell_choice='standard'):
        self.no = 11
        self.name = "P21/m"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                ]

class Sg12:
    def __init__(self,cell_choice='standard'):
        self.no = 12
        self.name = "C2/m"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg13:
    def __init__(self,cell_choice='standard'):
        self.no = 13
        self.name = "P2/c"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                ]

class Sg14:
    def __init__(self,cell_choice='standard'):
        self.no = 14
        self.name = "P21/c"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                ]

class Sg15:
    def __init__(self,cell_choice='standard'):
        self.no = 15
        self.name = "C2/c"
        self.crystal_system = "monoclinic"
        self.Laue = "2/m"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                ]

class Sg16:
    def __init__(self,cell_choice='standard'):
        self.no = 16
        self.name = "P222"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg17:
    def __init__(self,cell_choice='standard'):
        self.no = 17
        self.name = "P2221"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                ]

class Sg18:
    def __init__(self,cell_choice='standard'):
        self.no = 18
        self.name = "P21212"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg19:
    def __init__(self,cell_choice='standard'):
        self.no = 19
        self.name = "P212121"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                ]

class Sg20:
    def __init__(self,cell_choice='standard'):
        self.no = 20
        self.name = "C2221"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                ]

class Sg21:
    def __init__(self,cell_choice='standard'):
        self.no = 21
        self.name = "C222"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg22:
    def __init__(self,cell_choice='standard'):
        self.no = 22
        self.name = "F222"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg23:
    def __init__(self,cell_choice='standard'):
        self.no = 23
        self.name = "I222"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg24:
    def __init__(self,cell_choice='standard'):
        self.no = 24
        self.name = "I212121"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                ]

class Sg25:
    def __init__(self,cell_choice='standard'):
        self.no = 25
        self.name = "Pmm2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg26:
    def __init__(self,cell_choice='standard'):
        self.no = 26
        self.name = "Pmc21"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                ]

class Sg27:
    def __init__(self,cell_choice='standard'):
        self.no = 27
        self.name = "Pcc2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg28:
    def __init__(self,cell_choice='standard'):
        self.no = 28
        self.name = "Pma2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                ]

class Sg29:
    def __init__(self,cell_choice='standard'):
        self.no = 29
        self.name = "Pca21"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                ]

class Sg30:
    def __init__(self,cell_choice='standard'):
        self.no = 30
        self.name = "Pnc2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                ]

class Sg31:
    def __init__(self,cell_choice='standard'):
        self.no = 31
        self.name = "Pmn21"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 2, 0, 0, 0, 0, 2, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                ]

class Sg32:
    def __init__(self,cell_choice='standard'):
        self.no = 32
        self.name = "Pba2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg33:
    def __init__(self,cell_choice='standard'):
        self.no = 33
        self.name = "Pna21"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 2, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                ]

class Sg34:
    def __init__(self,cell_choice='standard'):
        self.no = 34
        self.name = "Pnn2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg35:
    def __init__(self,cell_choice='standard'):
        self.no = 35
        self.name = "Cmm2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg36:
    def __init__(self,cell_choice='standard'):
        self.no = 36
        self.name = "Cmc21"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                ]

class Sg37:
    def __init__(self,cell_choice='standard'):
        self.no = 37
        self.name = "Ccc2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg38:
    def __init__(self,cell_choice='standard'):
        self.no = 38
        self.name = "Amm2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 2, 0, 0, 2, 0, 0, 0, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                ]

class Sg39:
    def __init__(self,cell_choice='standard'):
        self.no = 39
        self.name = "Abm2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 0, 2, 0, 0, 2, 0, 0, 0, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg40:
    def __init__(self,cell_choice='standard'):
        self.no = 40
        self.name = "Ama2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 2, 2, 2, 0, 2, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg41:
    def __init__(self,cell_choice='standard'):
        self.no = 41
        self.name = "Aba2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 0, 2, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                ]

class Sg42:
    def __init__(self,cell_choice='standard'):
        self.no = 42
        self.name = "Fmm2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg43:
    def __init__(self,cell_choice='standard'):
        self.no = 43
        self.name = "Fdd2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        4, 2, 2, 4, 2, 2, 2, 0, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                ]

class Sg44:
    def __init__(self,cell_choice='standard'):
        self.no = 44
        self.name = "Imm2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg45:
    def __init__(self,cell_choice='standard'):
        self.no = 45
        self.name = "Iba2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg46:
    def __init__(self,cell_choice='standard'):
        self.no = 46
        self.name = "Ima2"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
                        2, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                ]

class Sg47:
    def __init__(self,cell_choice='standard'):
        self.no = 47
        self.name = "Pmmm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg48:
    def __init__(self,cell_choice='standard'):
        self.no = 48
        self.name = "Pnnn"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg49:
    def __init__(self,cell_choice='standard'):
        self.no = 49
        self.name = "Pccm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg50:
    def __init__(self,cell_choice='standard'):
        self.no = 50
        self.name = "Pban"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg51:
    def __init__(self,cell_choice='standard'):
        self.no = 51
        self.name = "Pmma"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                ]

class Sg52:
    def __init__(self,cell_choice='standard'):
        self.no = 52
        self.name = "Pnna"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 2, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                ]

class Sg53:
    def __init__(self,cell_choice='standard'):
        self.no = 53
        self.name = "Pmna"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 2, 2, 0, 0, 0, 2, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                ]

class Sg54:
    def __init__(self,cell_choice='standard'):
        self.no = 54
        self.name = "Pcca"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 2, 0, 0, 0, 2, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                ]

class Sg55:
    def __init__(self,cell_choice='standard'):
        self.no = 55
        self.name = "Pbam"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg56:
    def __init__(self,cell_choice='standard'):
        self.no = 56
        self.name = "Pccn"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                ]

class Sg57:
    def __init__(self,cell_choice='standard'):
        self.no = 57
        self.name = "Pbcm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                ]

class Sg58:
    def __init__(self,cell_choice='standard'):
        self.no = 58
        self.name = "Pnnm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg59:
    def __init__(self,cell_choice='standard'):
        self.no = 59
        self.name = "Pmmn"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg60:
    def __init__(self,cell_choice='standard'):
        self.no = 60
        self.name = "Pbcn"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 0, 2, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                ]

class Sg61:
    def __init__(self,cell_choice='standard'):
        self.no = 61
        self.name = "Pbca"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 0, 2, 0, 2, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                ]

class Sg62:
    def __init__(self,cell_choice='standard'):
        self.no = 62
        self.name = "Pnma"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 0, 2, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                ]

class Sg63:
    def __init__(self,cell_choice='standard'):
        self.no = 63
        self.name = "Cmcm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                ]

class Sg64:
    def __init__(self,cell_choice='standard'):
        self.no = 64
        self.name = "Cmca"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                ]

class Sg65:
    def __init__(self,cell_choice='standard'):
        self.no = 65
        self.name = "Cmmm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg66:
    def __init__(self,cell_choice='standard'):
        self.no = 66
        self.name = "Cccm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg67:
    def __init__(self,cell_choice='standard'):
        self.no = 67
        self.name = "Cmma"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 2, 2, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg68:
    def __init__(self,cell_choice='standard'):
        self.no = 68
        self.name = "Ccca"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                ]

class Sg69:
    def __init__(self,cell_choice='standard'):
        self.no = 69
        self.name = "Fmmm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 32
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg70:
    def __init__(self,cell_choice='standard'):
        self.no = 70
        self.name = "Fddd"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 32
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2,
                        4, 2, 2, 4, 2, 2, 4, 0, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                ]

class Sg71:
    def __init__(self,cell_choice='standard'):
        self.no = 71
        self.name = "Immm"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg72:
    def __init__(self,cell_choice='standard'):
        self.no = 72
        self.name = "Ibam"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg73:
    def __init__(self,cell_choice='standard'):
        self.no = 73
        self.name = "Ibca"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                ]

class Sg74:
    def __init__(self,cell_choice='standard'):
        self.no = 74
        self.name = "Imma"
        self.crystal_system = "orthorhombic"
        self.Laue = "mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg75:
    def __init__(self,cell_choice='standard'):
        self.no = 75
        self.name = "P4"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg76:
    def __init__(self,cell_choice='standard'):
        self.no = 76
        self.name = "P41"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.250000],
                [0.000000,0.000000,0.750000],
                ]

class Sg77:
    def __init__(self,cell_choice='standard'):
        self.no = 77
        self.name = "P42"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg78:
    def __init__(self,cell_choice='standard'):
        self.no = 78
        self.name = "P43"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.750000],
                [0.000000,0.000000,0.250000],
                ]

class Sg79:
    def __init__(self,cell_choice='standard'):
        self.no = 79
        self.name = "I4"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg80:
    def __init__(self,cell_choice='standard'):
        self.no = 80
        self.name = "I41"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                ]

class Sg81:
    def __init__(self,cell_choice='standard'):
        self.no = 81
        self.name = "P-4"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 4
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg82:
    def __init__(self,cell_choice='standard'):
        self.no = 82
        self.name = "I-4"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 8
        self.nuniq = 4
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg83:
    def __init__(self,cell_choice='standard'):
        self.no = 83
        self.name = "P4/m"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg84:
    def __init__(self,cell_choice='standard'):
        self.no = 84
        self.name = "P42/m"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg85:
    def __init__(self,cell_choice='standard'):
        self.no = 85
        self.name = "P4/n"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg86:
    def __init__(self,cell_choice='standard'):
        self.no = 86
        self.name = "P42/n"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg87:
    def __init__(self,cell_choice='standard'):
        self.no = 87
        self.name = "I4/m"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg88:
    def __init__(self,cell_choice='standard'):
        self.no = 88
        self.name = "I41/a"
        self.crystal_system = "tetragonal"
        self.Laue = "4/m"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 2, 2, 2, 0, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                ]

class Sg89:
    def __init__(self,cell_choice='standard'):
        self.no = 89
        self.name = "P422"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg90:
    def __init__(self,cell_choice='standard'):
        self.no = 90
        self.name = "P4212"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg91:
    def __init__(self,cell_choice='standard'):
        self.no = 91
        self.name = "P4122"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.250000],
                [0.000000,0.000000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.750000],
                [0.000000,0.000000,0.250000],
                ]

class Sg92:
    def __init__(self,cell_choice='standard'):
        self.no = 92
        self.name = "P41212"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.250000],
                [0.500000,0.500000,0.750000],
                [0.500000,0.500000,0.250000],
                [0.500000,0.500000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                ]

class Sg93:
    def __init__(self,cell_choice='standard'):
        self.no = 93
        self.name = "P4222"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg94:
    def __init__(self,cell_choice='standard'):
        self.no = 94
        self.name = "P42212"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg95:
    def __init__(self,cell_choice='standard'):
        self.no = 95
        self.name = "P4322"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.750000],
                [0.000000,0.000000,0.250000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.250000],
                [0.000000,0.000000,0.750000],
                ]

class Sg96:
    def __init__(self,cell_choice='standard'):
        self.no = 96
        self.name = "P43212"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.750000],
                [0.500000,0.500000,0.250000],
                [0.500000,0.500000,0.750000],
                [0.500000,0.500000,0.250000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                ]

class Sg97:
    def __init__(self,cell_choice='standard'):
        self.no = 97
        self.name = "I422"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg98:
    def __init__(self,cell_choice='standard'):
        self.no = 98
        self.name = "I4122"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                ]

class Sg99:
    def __init__(self,cell_choice='standard'):
        self.no = 99
        self.name = "P4mm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg100:
    def __init__(self,cell_choice='standard'):
        self.no = 100
        self.name = "P4bm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg101:
    def __init__(self,cell_choice='standard'):
        self.no = 101
        self.name = "P42cm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg102:
    def __init__(self,cell_choice='standard'):
        self.no = 102
        self.name = "P42nm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg103:
    def __init__(self,cell_choice='standard'):
        self.no = 103
        self.name = "P4cc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg104:
    def __init__(self,cell_choice='standard'):
        self.no = 104
        self.name = "P4nc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg105:
    def __init__(self,cell_choice='standard'):
        self.no = 105
        self.name = "P42mc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg106:
    def __init__(self,cell_choice='standard'):
        self.no = 106
        self.name = "P42bc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg107:
    def __init__(self,cell_choice='standard'):
        self.no = 107
        self.name = "I4mm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg108:
    def __init__(self,cell_choice='standard'):
        self.no = 108
        self.name = "I4cm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 2, 2,
                        0, 2, 2, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg109:
    def __init__(self,cell_choice='standard'):
        self.no = 109
        self.name = "I41md"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 2, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                ]

class Sg110:
    def __init__(self,cell_choice='standard'):
        self.no = 110
        self.name = "I41cd"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 2, 2,
                        0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.750000],
                [0.500000,0.000000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.250000],
                [0.000000,0.500000,0.750000],
                ]

class Sg111:
    def __init__(self,cell_choice='standard'):
        self.no = 111
        self.name = "P-42m"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg112:
    def __init__(self,cell_choice='standard'):
        self.no = 112
        self.name = "P-42c"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg113:
    def __init__(self,cell_choice='standard'):
        self.no = 113
        self.name = "P-421m"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg114:
    def __init__(self,cell_choice='standard'):
        self.no = 114
        self.name = "P-421c"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg115:
    def __init__(self,cell_choice='standard'):
        self.no = 115
        self.name = "P-4m2"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg116:
    def __init__(self,cell_choice='standard'):
        self.no = 116
        self.name = "P-4c2"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg117:
    def __init__(self,cell_choice='standard'):
        self.no = 117
        self.name = "P-4b2"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg118:
    def __init__(self,cell_choice='standard'):
        self.no = 118
        self.name = "P-4n2"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 8
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg119:
    def __init__(self,cell_choice='standard'):
        self.no = 119
        self.name = "I-4m2"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg120:
    def __init__(self,cell_choice='standard'):
        self.no = 120
        self.name = "I-4c2"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 2, 2,
                        0, 2, 2, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg121:
    def __init__(self,cell_choice='standard'):
        self.no = 121
        self.name = "I-42m"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg122:
    def __init__(self,cell_choice='standard'):
        self.no = 122
        self.name = "I-42d"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 8
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.000000,0.500000,0.250000],
                [0.000000,0.500000,0.250000],
                [0.000000,0.500000,0.250000],
                ]

class Sg123:
    def __init__(self,cell_choice='standard'):
        self.no = 123
        self.name = "P4/mmm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg124:
    def __init__(self,cell_choice='standard'):
        self.no = 124
        self.name = "P4/mcc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg125:
    def __init__(self,cell_choice='standard'):
        self.no = 125
        self.name = "P4/nbm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg126:
    def __init__(self,cell_choice='standard'):
        self.no = 126
        self.name = "P4/nnc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg127:
    def __init__(self,cell_choice='standard'):
        self.no = 127
        self.name = "P4/mbm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg128:
    def __init__(self,cell_choice='standard'):
        self.no = 128
        self.name = "P4/mnc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg129:
    def __init__(self,cell_choice='standard'):
        self.no = 129
        self.name = "P4/nmm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg130:
    def __init__(self,cell_choice='standard'):
        self.no = 130
        self.name = "P4/ncc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg131:
    def __init__(self,cell_choice='standard'):
        self.no = 131
        self.name = "P42/mmc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg132:
    def __init__(self,cell_choice='standard'):
        self.no = 132
        self.name = "P42/mcm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg133:
    def __init__(self,cell_choice='standard'):
        self.no = 133
        self.name = "P42/nbc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg134:
    def __init__(self,cell_choice='standard'):
        self.no = 134
        self.name = "P42/nnm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg135:
    def __init__(self,cell_choice='standard'):
        self.no = 135
        self.name = "P42/mbc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0,
                        0, 2, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg136:
    def __init__(self,cell_choice='standard'):
        self.no = 136
        self.name = "P42/mnm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg137:
    def __init__(self,cell_choice='standard'):
        self.no = 137
        self.name = "P42/nmc"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg138:
    def __init__(self,cell_choice='standard'):
        self.no = 138
        self.name = "P42/ncm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 16
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg139:
    def __init__(self,cell_choice='standard'):
        self.no = 139
        self.name = "I4/mmm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 32
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg140:
    def __init__(self,cell_choice='standard'):
        self.no = 140
        self.name = "I4/mcm"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 32
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 2, 2,
                        0, 2, 2, 0, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg141:
    def __init__(self,cell_choice='standard'):
        self.no = 141
        self.name = "I41/amd"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 32
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 0, 0,
                        2, 0, 0, 2, 2, 2, 2, 2, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                ]

class Sg142:
    def __init__(self,cell_choice='standard'):
        self.no = 142
        self.name = "I41/acd"
        self.crystal_system = "tetragonal"
        self.Laue = "4/mmm"
        self.nsymop = 32
        self.nuniq = 16
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.500000,0.000000,0.250000],
                [0.000000,0.500000,0.750000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.250000],
                [0.000000,0.500000,0.750000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.000000,0.500000,0.750000],
                [0.500000,0.000000,0.250000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.750000],
                [0.000000,0.500000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.750000],
                [0.500000,0.000000,0.250000],
                ]

class Sg143:
    def __init__(self,cell_choice='standard'):
        self.no = 143
        self.name = "P3"
        self.crystal_system = "trigonal"
        self.Laue = "-3"
        self.nsymop = 3
        self.nuniq = 3
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg144:
    def __init__(self,cell_choice='standard'):
        self.no = 144
        self.name = "P31"
        self.crystal_system = "trigonal"
        self.Laue = "-3"
        self.nsymop = 3
        self.nuniq = 3
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                ]

class Sg145:
    def __init__(self,cell_choice='standard'):
        self.no = 145
        self.name = "P32"
        self.crystal_system = "trigonal"
        self.Laue = "-3"
        self.nsymop = 3
        self.nuniq = 3
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                ]

class Sg146:
    def __init__(self,cell_choice="standard"):
        self.no = 146
        self.name = "R3"
        self.crystal_system = "trigonal"
        self.cell_choice = cell_choice
        if self.cell_choice=="rhombohedral" :
            self.name = "R3r"
            self.Laue = "-3"
            self.nsymop = 3
            self.nuniq = 3
            self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]
        else: #standard hexagonal setting
            self.Laue = "-3"
            self.cell_choice = "hexagonal"
            self.nsymop = 9
            self.nuniq = 3
            self.syscond = [0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 3]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                ]

class Sg147:
    def __init__(self,cell_choice='standard'):
        self.no = 147
        self.name = "P-3"
        self.crystal_system = "trigonal"
        self.Laue = "-3"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg148:
    def __init__(self,cell_choice="standard"):
        self.no = 148
        self.name = "R-3"
        self.crystal_system = "trigonal"
        self.cell_choice = cell_choice
        if self.cell_choice=="rhombohedral" :
            self.name = "R-3r"
            self.Laue = "-3"
            self.nsymop = 6
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]
        else: #standard hexagonal setting
            self.Laue = "-3"
            self.cell_choice = "hexagonal"
            self.nsymop = 18
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 3]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                ]

class Sg149:
    def __init__(self,cell_choice='standard'):
        self.no = 149
        self.name = "P312"
        self.crystal_system = "trigonal"
        self.Laue = "-31m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg150:
    def __init__(self,cell_choice='standard'):
        self.no = 150
        self.name = "P321"
        self.crystal_system = "trigonal"
        self.Laue = "-3m1"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg151:
    def __init__(self,cell_choice='standard'):
        self.no = 151
        self.name = "P3112"
        self.crystal_system = "trigonal"
        self.Laue = "-31m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.000000],
                ]

class Sg152:
    def __init__(self,cell_choice='standard'):
        self.no = 152
        self.name = "P3121"
        self.crystal_system = "trigonal"
        self.Laue = "-3m1"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                ]

class Sg153:
    def __init__(self,cell_choice='standard'):
        self.no = 153
        self.name = "P3212"
        self.crystal_system = "trigonal"
        self.Laue = "-31m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.000000],
                ]

class Sg154:
    def __init__(self,cell_choice='standard'):
        self.no = 154
        self.name = "P3221"
        self.Laue = "-3m1"
        self.crystal_system = "trigonal"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                ]

class Sg155:
    def __init__(self,cell_choice="standard"):
        self.no = 155
        self.name = "R32"
        self.crystal_system = "trigonal"
        self.cell_choice = cell_choice
        if self.cell_choice=="rhombohedral" :
            self.name = "R32r"
            self.Laue = "-3m"
            self.nsymop = 6
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]
        else: #standard hexagonal setting
            self.Laue = "-3m1"
            self.cell_choice = "hexagonal"
            self.nsymop = 18
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 3]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                ]

class Sg156:
    def __init__(self,cell_choice='standard'):
        self.no = 156
        self.name = "P3m1"
        self.crystal_system = "trigonal"
        self.Laue = "-3m1"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg157:
    def __init__(self,cell_choice='standard'):
        self.no = 157
        self.name = "P31m"
        self.crystal_system = "trigonal"
        self.Laue = "-31m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg158:
    def __init__(self,cell_choice='standard'):
        self.no = 158
        self.name = "P3c1"
        self.crystal_system = "trigonal"
        self.Laue = "-3m1"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 2, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg159:
    def __init__(self,cell_choice='standard'):
        self.no = 159
        self.name = "P31c"
        self.crystal_system = "trigonal"
        self.Laue = "-31m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg160:
    def __init__(self,cell_choice="standard"):
        self.no = 160
        self.name = "R3m"
        self.crystal_system = "trigonal"
        self.cell_choice = cell_choice
        if self.cell_choice=="rhombohedral" :
            self.name = "R3mr"
            self.Laue = "-3m"
            self.nsymop = 6
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]
        else: #standard hexagonal setting
            self.Laue = "-3m1"
            self.cell_choice = "hexagonal"
            self.nsymop = 18
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 3]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                ]

class Sg161:
    def __init__(self,cell_choice="standard"):
        self.no = 161
        self.name = "R3c"
        self.crystal_system = "trigonal"
        self.cell_choice = cell_choice
        if self.cell_choice=="rhombohedral" :
            self.name = "R3cr"
            self.Laue = "-3m"
            self.nsymop = 6
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]
        else: #standard hexagonal setting
            self.Laue = "-3m1"
            self.cell_choice = "hexagonal"
            self.nsymop = 18
            self.nuniq = 6
            self.syscond = [0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6,
                        0, 2, 3]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.833333],
                [0.666667,0.333333,0.833333],
                [0.666667,0.333333,0.833333],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.166667],
                [0.333333,0.666667,0.166667],
                [0.333333,0.666667,0.166667],
                ]

class Sg162:
    def __init__(self,cell_choice='standard'):
        self.no = 162
        self.name = "P-31m"
        self.crystal_system = "trigonal"
        self.Laue = "-31m"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg163:
    def __init__(self,cell_choice='standard'):
        self.no = 163
        self.name = "P-31c"
        self.Laue = "-31m"
        self.crystal_system = "trigonal"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg164:
    def __init__(self,cell_choice='standard'):
        self.no = 164
        self.name = "P-3m1"
        self.crystal_system = "trigonal"
        self.Laue = "-3m1"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg165:
    def __init__(self,cell_choice='standard'):
        self.no = 165
        self.name = "P-3c1"
        self.crystal_system = "trigonal"
        self.Laue = "-3m1"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 2, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg166:
    def __init__(self,cell_choice="standard"):
        self.no = 166
        self.name = "R-3m"
        self.crystal_system = "trigonal"
        self.cell_choice = cell_choice
        if self.cell_choice=="rhombohedral" :
            self.name = "R-3mr"
            self.Laue = "-3m"
            self.nsymop = 12
            self.nuniq = 12
            self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]
        else: #standard hexagonal setting
            self.Laue = "-3m1"
            self.cell_choice = "hexagonal"
            self.nsymop = 36
            self.nuniq = 12
            self.syscond = [0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 3]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                ]

class Sg167:
    def __init__(self,cell_choice="standard"):
        self.no = 167
        self.name = "R-3c"
        self.crystal_system = "trigonal"
        self.cell_choice = cell_choice
        if self.cell_choice=="rhombohedral" :
            self.name = "R-3cr"
            self.Laue = "-3m"
            self.nsymop = 12
            self.nuniq = 12
            self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]
        else: #standard hexagonal setting
            self.Laue = "-3m1"
            self.cell_choice = "hexagonal"
            self.nsymop = 36
            self.nuniq = 12
            self.syscond = [0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6,
                        0, 2, 3]
            self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                ]
            self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.833333],
                [0.666667,0.333333,0.833333],
                [0.666667,0.333333,0.833333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.333333],
                [0.666667,0.333333,0.833333],
                [0.666667,0.333333,0.833333],
                [0.666667,0.333333,0.833333],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.166667],
                [0.333333,0.666667,0.166667],
                [0.333333,0.666667,0.166667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.666667],
                [0.333333,0.666667,0.166667],
                [0.333333,0.666667,0.166667],
                [0.333333,0.666667,0.166667],
                ]

class Sg168:
    def __init__(self,cell_choice='standard'):
        self.no = 168
        self.name = "P6"
        self.crystal_system =  "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg169:
    def __init__(self,cell_choice='standard'):
        self.no = 169
        self.name = "P61"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.833333],
                [0.000000,0.000000,0.166667],
                ]

class Sg170:
    def __init__(self,cell_choice='standard'):
        self.no = 170
        self.name = "P65"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.166667],
                [0.000000,0.000000,0.833333],
                ]

class Sg171:
    def __init__(self,cell_choice='standard'):
        self.no = 171
        self.name = "P62"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                ]

class Sg172:
    def __init__(self,cell_choice='standard'):
        self.no = 172
        self.name = "P64"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                ]

class Sg173:
    def __init__(self,cell_choice='standard'):
        self.no = 173
        self.name = "P63"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg174:
    def __init__(self,cell_choice='standard'):
        self.no = 174
        self.name = "P-6"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 6
        self.nuniq = 6
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg175:
    def __init__(self,cell_choice='standard'):
        self.no = 175
        self.name = "P6/m"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg176:
    def __init__(self,cell_choice='standard'):
        self.no = 176
        self.name = "P63/m"
        self.crystal_system = "hexagonal"
        self.Laue = "6/m"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg177:
    def __init__(self,cell_choice='standard'):
        self.no = 177
        self.name = "P622"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg178:
    def __init__(self,cell_choice='standard'):
        self.no = 178
        self.name = "P6122"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.833333],
                [0.000000,0.000000,0.166667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.833333],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.166667],
                ]

class Sg179:
    def __init__(self,cell_choice='standard'):
        self.no = 179
        self.name = "P6522"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.166667],
                [0.000000,0.000000,0.833333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.166667],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.833333],
                ]

class Sg180:
    def __init__(self,cell_choice='standard'):
        self.no = 180
        self.name = "P6222"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                ]

class Sg181:
    def __init__(self,cell_choice='standard'):
        self.no = 181
        self.name = "P6422"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                [0.000000,0.000000,0.333333],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.666667],
                ]

class Sg182:
    def __init__(self,cell_choice='standard'):
        self.no = 182
        self.name = "P6322"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg183:
    def __init__(self,cell_choice='standard'):
        self.no = 183
        self.name = "P6mm"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg184:
    def __init__(self,cell_choice='standard'):
        self.no = 184
        self.name = "P6cc"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg185:
    def __init__(self,cell_choice='standard'):
        self.no = 185
        self.name = "P63cm"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg186:
    def __init__(self,cell_choice='standard'):
        self.no = 186
        self.name = "P63mc"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg187:
    def __init__(self,cell_choice='standard'):
        self.no = 187
        self.name = "P-6m2"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg188:
    def __init__(self,cell_choice='standard'):
        self.no = 188
        self.name = "P-6c2"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg189:
    def __init__(self,cell_choice='standard'):
        self.no = 189
        self.name = "P-62m"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg190:
    def __init__(self,cell_choice='standard'):
        self.no = 190
        self.name = "P-62c"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg191:
    def __init__(self,cell_choice='standard'):
        self.no = 191
        self.name = "P6/mmm"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg192:
    def __init__(self,cell_choice='standard'):
        self.no = 192
        self.name = "P6/mcc"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2,
                        0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg193:
    def __init__(self,cell_choice='standard'):
        self.no = 193
        self.name = "P63/mcm"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg194:
    def __init__(self,cell_choice='standard'):
        self.no = 194
        self.name = "P63/mmc"
        self.crystal_system = "hexagonal"
        self.Laue = "6/mmm"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[0,-1,0],[1,-1,0],[0,0,1]],
                [[-1,1,0],[-1,0,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[0,1,0],[-1,1,0],[0,0,1]],
                [[1,-1,0],[1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[1,-1,0],[0,-1,0],[0,0,-1]],
                [[-1,0,0],[-1,1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[-1,1,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[1,-1,0],[0,0,-1]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[0,1,0],[-1,1,0],[0,0,-1]],
                [[1,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[-1,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,-1,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[-1,1,0],[0,1,0],[0,0,1]],
                [[1,0,0],[1,-1,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[1,-1,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[-1,1,0],[0,0,1]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg195:
    def __init__(self,cell_choice='standard'):
        self.no = 195
        self.name = "P23"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg196:
    def __init__(self,cell_choice='standard'):
        self.no = 196
        self.name = "F23"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 48
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg197:
    def __init__(self,cell_choice='standard'):
        self.no = 197
        self.name = "I23"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 24
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg198:
    def __init__(self,cell_choice='standard'):
        self.no = 198
        self.name = "P213"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 12
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                ]

class Sg199:
    def __init__(self,cell_choice='standard'):
        self.no = 199
        self.name = "I213"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 24
        self.nuniq = 12
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                ]

class Sg200:
    def __init__(self,cell_choice='standard'):
        self.no = 200
        self.name = "Pm-3"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg201:
    def __init__(self,cell_choice='standard'):
        self.no = 201
        self.name = "Pn-3"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg202:
    def __init__(self,cell_choice='standard'):
        self.no = 202
        self.name = "Fm-3"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 96
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg203:
    def __init__(self,cell_choice='standard'):
        self.no = 203
        self.name = "Fd-3"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 96
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        4, 2, 2, 4, 2, 2, 4, 2, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                ]

class Sg204:
    def __init__(self,cell_choice='standard'):
        self.no = 204
        self.name = "Im-3"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 48
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg205:
    def __init__(self,cell_choice='standard'):
        self.no = 205
        self.name = "Pa-3"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
                        0, 0, 2, 0, 2, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                ]

class Sg206:
    def __init__(self,cell_choice='standard'):
        self.no = 206
        self.name = "Ia-3"
        self.crystal_system = "cubic"
        self.Laue = "m-3"
        self.nsymop = 48
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                ]

class Sg207:
    def __init__(self,cell_choice='standard'):
        self.no = 207
        self.name = "P432"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg208:
    def __init__(self,cell_choice='standard'):
        self.no = 208
        self.name = "P4232"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg209:
    def __init__(self,cell_choice='standard'):
        self.no = 209
        self.name = "F432"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 96
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg210:
    def __init__(self,cell_choice='standard'):
        self.no = 210
        self.name = "F4132"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 96
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                ]

class Sg211:
    def __init__(self,cell_choice='standard'):
        self.no = 211
        self.name = "I432"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg212:
    def __init__(self,cell_choice='standard'):
        self.no = 212
        self.name = "P4332"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                ]

class Sg213:
    def __init__(self,cell_choice='standard'):
        self.no = 213
        self.name = "P4132"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.750000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                ]

class Sg214:
    def __init__(self,cell_choice='standard'):
        self.no = 214
        self.name = "I4132"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.750000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                ]

class Sg215:
    def __init__(self,cell_choice='standard'):
        self.no = 215
        self.name = "P-43m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg216:
    def __init__(self,cell_choice='standard'):
        self.no = 216
        self.name = "F-43m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 96
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg217:
    def __init__(self,cell_choice='standard'):
        self.no = 217
        self.name = "I-43m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg218:
    def __init__(self,cell_choice='standard'):
        self.no = 218
        self.name = "P-43n"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 24
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg219:
    def __init__(self,cell_choice='standard'):
        self.no = 219
        self.name = "F-43c"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 96
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 2, 2, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg220:
    def __init__(self,cell_choice='standard'):
        self.no = 220
        self.name = "I-43d"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 24
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 4, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.750000,0.750000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                ]

class Sg221:
    def __init__(self,cell_choice='standard'):
        self.no = 221
        self.name = "Pm-3m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg222:
    def __init__(self,cell_choice='standard'):
        self.no = 222
        self.name = "Pn-3n"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg223:
    def __init__(self,cell_choice='standard'):
        self.no = 223
        self.name = "Pm-3n"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg224:
    def __init__(self,cell_choice='standard'):
        self.no = 224
        self.name = "Pn-3m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 48
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                ]

class Sg225:
    def __init__(self,cell_choice='standard'):
        self.no = 225
        self.name = "Fm-3m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 192
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg226:
    def __init__(self,cell_choice='standard'):
        self.no = 226
        self.name = "Fm-3c"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 192
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 2, 2, 2, 0, 2, 2,
                        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg227:
    def __init__(self,cell_choice='standard'):
        self.no = 227
        self.name = "Fd-3m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 192
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 0, 0, 2, 0, 2, 2,
                        4, 2, 2, 4, 2, 2, 4, 2, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                ]

class Sg228:
    def __init__(self,cell_choice='standard'):
        self.no = 228
        self.name = "Fd-3c"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 192
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [2, 2, 2, 2, 0, 0, 2, 2, 2, 0, 2, 2,
                        4, 2, 2, 4, 2, 2, 2, 4, 4, 4, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.750000,0.750000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.000000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.750000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                ]

class Sg229:
    def __init__(self,cell_choice='standard'):
        self.no = 229
        self.name = "Im-3m"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 96
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0,
                        2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 2,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.500000,0.500000],
                ]

class Sg230:
    def __init__(self,cell_choice='standard'):
        self.no = 230
        self.name = "Ia-3d"
        self.crystal_system = "cubic"
        self.Laue = "m-3m"
        self.nsymop = 96
        self.nuniq = 48
        self.cell_choice = "standard"
        self.syscond = [0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 2, 2,
                        0, 2, 2, 0, 2, 2, 0, 4, 4, 4, 4,
                        0, 0, 0]
        self.rot = [
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                [[1,0,0],[0,1,0],[0,0,1]],
                [[-1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,-1]],
                [[0,0,1],[1,0,0],[0,1,0]],
                [[0,0,1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[-1,0,0],[0,1,0]],
                [[0,0,-1],[1,0,0],[0,-1,0]],
                [[0,1,0],[0,0,1],[1,0,0]],
                [[0,-1,0],[0,0,1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[-1,0,0]],
                [[0,-1,0],[0,0,-1],[1,0,0]],
                [[0,1,0],[1,0,0],[0,0,-1]],
                [[0,-1,0],[-1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,1]],
                [[1,0,0],[0,0,1],[0,-1,0]],
                [[-1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,-1],[0,1,0]],
                [[0,0,1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[1,0,0]],
                [[0,0,-1],[0,-1,0],[-1,0,0]],
                [[-1,0,0],[0,-1,0],[0,0,-1]],
                [[1,0,0],[0,1,0],[0,0,-1]],
                [[1,0,0],[0,-1,0],[0,0,1]],
                [[-1,0,0],[0,1,0],[0,0,1]],
                [[0,0,-1],[-1,0,0],[0,-1,0]],
                [[0,0,-1],[1,0,0],[0,1,0]],
                [[0,0,1],[1,0,0],[0,-1,0]],
                [[0,0,1],[-1,0,0],[0,1,0]],
                [[0,-1,0],[0,0,-1],[-1,0,0]],
                [[0,1,0],[0,0,-1],[1,0,0]],
                [[0,-1,0],[0,0,1],[1,0,0]],
                [[0,1,0],[0,0,1],[-1,0,0]],
                [[0,-1,0],[-1,0,0],[0,0,1]],
                [[0,1,0],[1,0,0],[0,0,1]],
                [[0,-1,0],[1,0,0],[0,0,-1]],
                [[0,1,0],[-1,0,0],[0,0,-1]],
                [[-1,0,0],[0,0,-1],[0,1,0]],
                [[1,0,0],[0,0,-1],[0,-1,0]],
                [[1,0,0],[0,0,1],[0,1,0]],
                [[-1,0,0],[0,0,1],[0,-1,0]],
                [[0,0,-1],[0,-1,0],[1,0,0]],
                [[0,0,-1],[0,1,0],[-1,0,0]],
                [[0,0,1],[0,-1,0],[-1,0,0]],
                [[0,0,1],[0,1,0],[1,0,0]],
                ]
        self.trans = [
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.750000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.000000,0.000000,0.000000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.000000,0.500000,0.500000],
                [0.000000,0.000000,0.000000],
                [0.000000,0.500000,0.500000],
                [0.500000,0.500000,0.000000],
                [0.500000,0.000000,0.500000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.250000,0.750000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.750000,0.750000,0.250000],
                [0.250000,0.750000,0.750000],
                [0.750000,0.750000,0.250000],
                [0.750000,0.250000,0.750000],
                [0.250000,0.250000,0.250000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.500000,0.500000,0.500000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.500000,0.000000,0.000000],
                [0.500000,0.500000,0.500000],
                [0.500000,0.000000,0.000000],
                [0.000000,0.000000,0.500000],
                [0.000000,0.500000,0.000000],
                [0.750000,0.250000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                [0.250000,0.250000,0.750000],
                [0.750000,0.250000,0.250000],
                [0.250000,0.250000,0.750000],
                [0.250000,0.750000,0.250000],
                [0.750000,0.750000,0.750000],
                ]

