import logging
import time
from timeit import default_timer as timer
import cv2

import sys


class GSHLSPlayer:

    @classmethod
    async def create(cls, gsdbs, url, onframe):
        self = GSHLSPlayer()
        self.gsdbs = gsdbs
        self.url = url
        self.onframe = onframe
        self._logger = logging.getLogger(__name__)
        self.url += f"&vision=true&session={self.gsdbs.cookiejar.get('session')}&signature={self.gsdbs.cookiejar.get('signature')}"
        cap = cv2.VideoCapture(self.url)

        if cap.isOpened() == False:
            self._logger.error("unable to open playlist")
            return
        fps = cap.get(cv2.CAP_PROP_FPS)
        wait_ms = int(1000 / fps)
        self._logger.info(f"playing back HLS-Playlist with {fps} fps")
        while True:
            ret, frame = cap.read()
            if not ret:
                break

            start_time = time.time()
            onframe(self.gsdbs, "hls_playlist", frame)
            end_time = time.time()

            execution_time_ms = (end_time - start_time) * 1000

            calculatedwait = wait_ms - execution_time_ms

            if calculatedwait < 0:
                if cv2.waitKey(1) & 0xFF == ord('q'):
                    break
            else:
                if cv2.waitKey(calculatedwait) & 0xFF == ord('q'):
                    break

        cap.release()
        cv2.destroyAllWindows()
