# AUTOGENERATED! DO NOT EDIT! File to edit: README.ipynb (unless otherwise specified).

__all__ = ['save_16bit', 'distort_coords', 'undistort_array', 'get_essential', 'get_fundamental', 'rigid_rect_fusi',
           'cam_rect_fusi', 'rect_homography', 'rect_array', 'rigid_rect_boug', 'cam_rect_boug', 'rectify', 'rect_img']

# Cell
import PIL
import torch
from camera_calib.utils import *

# Cell
def save_16bit(arr, file_img):
    pim = PIL.Image.fromarray((torch2np(arr)*(2**16-1)).astype(np.uint16), mode='I;16')
    pim.save(file_img)

# Cell
def distort_coords(ps_p, cam, distort):
    p2pd = torch.nn.Sequential(Inverse(cam), distort, cam)
    return p2pd(ps_p)

# Cell
def undistort_array(arr, cam, distort, **kwargs):
    return interp_array(arr, distort_coords(array_ps(arr), cam, distort), **kwargs).reshape(arr.shape)

# Cell
def get_essential(R12, t12): return cross_mat(t12)@R12

# Cell
@numpyify
def get_fundamental(R12, t12, A1, A2):
    E = get_essential(R12, t12)
    return torch.inverse(A2.T)@E@torch.inverse(A1)

# Cell
@numpyify
def rigid_rect_fusi(M1, M2):
    R1, t1 = M2Rt(M1)
    _,  t2 = M2Rt(M2)

    # Get rotation matrix
    r1 = t2-t1                     # new x-axis should be parallel to t1->t2 after rotation
    r2 = torch.cross(R1[:, 2], r1) # new y-axis is orthogonal to camera 1's old z axis and new x-axis
    r3 = torch.cross(r1, r2)       # new z-axis is orthogonal to new x and y axes
    r1, r2, r3 = unitize(stackify((r1, r2, r3)))
    R_r = stackify((r1, r2, r3), dim=1)

    return Rt2M(R_r, t1), Rt2M(R_r, t2)

# Cell
def cam_rect_fusi(A1, A2):
    A_r = (A1 + A2)/2
    return A_r, A_r

# Cell
@numpyify
def rect_homography(A, M, A_r, M_r):
    (R, t), (R_r, t_r) = map(M2Rt, [M, M_r])
    assert_allclose(t, t_r) # There can be no change in translation for rectification; only rotation
    return A@R.T@R_r@torch.inverse(A_r)

# Cell
def rect_array(arr_d, H, cam, distort):
    ps_pr = array_ps(arr_d)                                 # Get rectified pixel coordinates
    ps_p  = pmm(ps_pr, H, aug=True)                         # Get pixel coordinates
    ps_pd = distort_coords(ps_p, cam, distort)              # Get distorted coordinates
    arr_r = interp_array(arr_d, ps_pd).reshape(arr_d.shape) # Rectify and undistort image
    return arr_r

# Cell
@numpyify
def rigid_rect_boug(M1, M2):
    R1, t1 = M2Rt(M1)
    _,  t2 = M2Rt(M2)

    # First, get mid-point rotation so both cameras are aligned
    R12, t12 = M2Rt(invert_rigid(M2)@M1)
    r12 = R2rodrigues(R12)
    R12_half = rodrigues2R(r12/2)

    # Next, get rotation so both cameras are aligned to p1->p2
    Rx = v_v_R(R12_half.T@t12, M1.new_tensor([-1, 0, 0]))

    # Compose to get rectified rotations
    # Note that:
    #     R_r = R2@R12_half@Rx.T
    # As well
    R_r = R1@R12_half.T@Rx.T

    return Rt2M(R_r, t1), Rt2M(R_r, t2)

# Cell
@numpyify
def cam_rect_boug(A1, A2, M1, M2, M1_r, M2_r, sz):
    zero = A1.new_tensor(0)

    (R1, _), (R1_r, _) = M2Rt(M1), M2Rt(M1_r)
    (R2, _), (R2_r, _) = M2Rt(M2), M2Rt(M2_r)

    # Get focal length
    alpha = stackify((A1[[0,1],[0,1]], A2[[0,1],[0,1]])).mean()
    A_alpha = stackify(((alpha, zero),
                        (zero,  alpha)))

    # Get new principle points such that center of image gets mapped close to rectified center
    def _get_po_pr(A, R, R_r):
        po_nr = pmm(po_p, R_r.T@R@torch.inverse(A), aug=True)
        po_pr = po_p - pmm(A_alpha, po_nr)
        return po_pr
    po_p = (sz[[1,0]]-1)/2
    po_pr1, po_pr2 = _get_po_pr(A1, R1, R1_r), _get_po_pr(A2, R2, R2_r)
    xo_r1, xo_r2 = po_pr1[0], po_pr2[0]
    yo_r = (po_pr1[1]+po_pr2[1])/2

    # Create camera matrices
    def _get_A(xo_r):
        return torch.cat([torch.cat([A_alpha, stackify((((xo_r,), (yo_r,))))], dim=1),
                          A1.new_tensor([[0, 0, 1]])])
    return _get_A(xo_r1), _get_A(xo_r2)

# Cell
def rectify(calib):
    assert_allclose(len(calib['cams']), 2)

    As = [cam.get_param() for cam in calib['cams']]
    Ms = [rig.get_param() for rig in calib['rigids_cam']]
    sz = As[0].new_tensor(calib['imgs'][0].size)

    # TODO: Add option to choose different types of rectification
    Ms_r = rigid_rect_boug(*Ms)
    As_r = cam_rect_boug(*As, *Ms, *Ms_r, sz)
    Hs = [rect_homography(A, M, A_r, M_r) for A, M, A_r, M_r in zip(As, Ms, As_r, Ms_r)]

    return {'Hs': Hs,
            'As_r': As_r,
            'Ms_r': Ms_r,
            'cams': calib['cams'],
            'distorts': calib['distorts'],
            'dtype': calib['dtype'],
            'device': calib['device']}

# Cell
def rect_img(img, rect):
    assert_allclose(hasattr(img, 'idx_cam'), True)
    idx = img.idx_cam

    return rect_array(img.array_gs(rect['dtype'], rect['device']),
                      rect['Hs'][idx],
                      rect['cams'][idx],
                      rect['distorts'][idx])