"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MountPermissionsHelper = void 0;
const mountable_filesystem_1 = require("./mountable-filesystem");
/**
 * This is an internal-only class that can be used to convert enum values from
 * {@link MountPermissions} into strings, or whatever, that are needed by OS-specific
 * mount utilities.
 */
class MountPermissionsHelper {
    /**
     * Convert the given permission into the appropriate mount option for Linux's mount command.
     *
     * @param permission The permission to convert. Defaults to {@link MountPermissions.READWRITE} if not defined.
     */
    static toLinuxMountOption(permission) {
        permission = permission !== null && permission !== void 0 ? permission : mountable_filesystem_1.MountPermissions.READWRITE;
        switch (permission) {
            case mountable_filesystem_1.MountPermissions.READONLY:
                return 'ro';
            case mountable_filesystem_1.MountPermissions.READWRITE:
                return 'rw';
        }
        throw new Error(`Unhandled MountPermission: ${permission}`);
    }
}
exports.MountPermissionsHelper = MountPermissionsHelper;
//# sourceMappingURL=data:application/json;base64,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