"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.implementsIAcmImportCertProps = exports.implementsIX509CertificateEncodePkcs12 = exports.implementsIX509CertificateGenerate = exports.implementsIX509ResourceProperties = exports.implementsINewSecretProps = exports.implementsISecretCertificate = exports.implementsTag = void 0;
const kms_1 = require("../lib/kms");
const secrets_manager_1 = require("../lib/secrets-manager");
const x509_certs_1 = require("../lib/x509-certs");
function implementsTag(value) {
    if (!value || !Array.isArray(value)) {
        return false;
    }
    for (const tag of value) {
        if (typeof (tag) !== 'object') {
            return false;
        }
        if (!tag.Key || typeof (tag.Key) !== 'string') {
            return false;
        }
        if (!tag.Value || typeof (tag.Value) !== 'string') {
            return false;
        }
    }
    return true;
}
exports.implementsTag = implementsTag;
function implementsISecretCertificate(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    for (const key of ['Cert', 'Key', 'Passphrase']) {
        if (!value[key] || typeof (value[key]) !== 'string') {
            return false;
        }
        if (!secrets_manager_1.isArn(value[key])) {
            return false;
        }
    }
    if (value.CertChain) {
        if (typeof (value.CertChain) !== 'string') {
            return false;
        }
        if (value.CertChain !== '' && !secrets_manager_1.isArn(value.CertChain)) {
            return false;
        }
    }
    return true;
}
exports.implementsISecretCertificate = implementsISecretCertificate;
function implementsINewSecretProps(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!value.NamePrefix || typeof (value.NamePrefix) !== 'string') {
        return false;
    }
    if (value.EncryptionKey) {
        if (typeof (value.EncryptionKey) !== 'string') {
            return false;
        }
        if (!kms_1.isArn(value.EncryptionKey)) {
            return false;
        }
    }
    if (!value.Description || typeof (value.Description) !== 'string') {
        return false;
    }
    if (!implementsTag(value.Tags)) {
        return false;
    }
    return true;
}
exports.implementsINewSecretProps = implementsINewSecretProps;
function implementsIX509ResourceProperties(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!value.Passphrase || typeof (value.Passphrase) !== 'string') {
        return false;
    }
    if (!secrets_manager_1.isArn(value.Passphrase)) {
        return false;
    }
    if (!implementsINewSecretProps(value.Secret)) {
        return false;
    }
    return true;
}
exports.implementsIX509ResourceProperties = implementsIX509ResourceProperties;
function implementsIX509CertificateGenerate(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!implementsIX509ResourceProperties(value)) {
        return false;
    }
    if (!x509_certs_1.implementsDistinguishedNameProps(value.DistinguishedName)) {
        return false;
    }
    if (value.SigningCertificate && !implementsISecretCertificate(value.SigningCertificate)) {
        return false;
    }
    return true;
}
exports.implementsIX509CertificateGenerate = implementsIX509CertificateGenerate;
function implementsIX509CertificateEncodePkcs12(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!implementsIX509ResourceProperties(value)) {
        return false;
    }
    if (!implementsISecretCertificate(value.Certificate)) {
        return false;
    }
    return true;
}
exports.implementsIX509CertificateEncodePkcs12 = implementsIX509CertificateEncodePkcs12;
function implementsIAcmImportCertProps(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!implementsISecretCertificate(value.X509CertificatePem)) {
        return false;
    }
    if (!implementsTag(value.Tags)) {
        return false;
    }
    return true;
}
exports.implementsIAcmImportCertProps = implementsIAcmImportCertProps;
//# sourceMappingURL=data:application/json;base64,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