/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { ACM, DynamoDB, SecretsManager } from 'aws-sdk';
import { LambdaContext } from '../lib/aws-lambda';
import { CfnRequestEvent, DynamoBackedCustomResource } from '../lib/custom-resource';
import { CompositeStringIndexTable } from '../lib/dynamodb';
import { IAcmImportCertProps } from './types';
export declare class AcmCertificateImporter extends DynamoBackedCustomResource {
    protected readonly acmClient: ACM;
    protected readonly secretsManagerClient: SecretsManager;
    constructor(acmClient: ACM, dynamoDbClient: DynamoDB, secretsManagerClient: SecretsManager);
    validateInput(data: object): boolean;
    doCreate(physicalId: string, resourceProperties: IAcmImportCertProps): Promise<object>;
    doDelete(physicalId: string): Promise<void>;
    protected importAndStoreCertificate(args: {
        readonly cert: string;
        readonly certChain?: string;
        readonly resourceTable: CompositeStringIndexTable;
        readonly key: string;
        readonly physicalId: string;
        readonly tags: Array<{
            Key: string;
            Value: string;
        }>;
    }): Promise<string>;
    private getSecretString;
}
/**
 * The handler used to import an X.509 certificate to ACM from a Secret
 */
export declare function importCert(event: CfnRequestEvent, context: LambdaContext): Promise<string>;
