/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { LambdaContext } from '../lib/aws-lambda';
import { CfnRequestEvent, SimpleCustomResource } from '../lib/custom-resource';
import { VersionProvider, IVersionProviderProperties, IVersionedUris, Platform } from '../lib/version-provider';
export declare class VersionProviderResource extends SimpleCustomResource {
    readonly versionProvider: VersionProvider;
    constructor(indexFilePath?: string);
    /**
     * @inheritdoc
     */
    validateInput(data: object): boolean;
    /**
     * @inheritdoc
     */
    doCreate(physicalId: string, resourceProperties: IVersionProviderProperties): Promise<Map<Platform, IVersionedUris>>;
    /**
     * @inheritdoc
     */
    doDelete(physicalId: string, resourceProperties: IVersionProviderProperties): Promise<void>;
}
/**
 * The handler used to provide the installer links for the requested version
 */
export declare function handler(event: CfnRequestEvent, context: LambdaContext): Promise<string>;
