# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_container.api_client import ApiClient
from pulpcore.client.pulp_container.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RepositoriesContainerPushApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list(self, **kwargs):  # noqa: E501
        """List container push repositorys  # noqa: E501

        ViewSet for a container push repository.  POST and DELETE are disallowed because a push repository is tightly coupled with a ContainerDistribution which handles it automatically. Created - during push operation, removed - with ContainerDistribution removal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name:
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str pulp_label_select: Filter labels by search string
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedcontainerContainerPushRepositoryResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info(**kwargs)  # noqa: E501

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List container push repositorys  # noqa: E501

        ViewSet for a container push repository.  POST and DELETE are disallowed because a push repository is tightly coupled with a ContainerDistribution which handles it automatically. Created - during push operation, removed - with ContainerDistribution removal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name:
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str pulp_label_select: Filter labels by search string
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedcontainerContainerPushRepositoryResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'name',
            'name__contains',
            'name__icontains',
            'name__in',
            'name__startswith',
            'offset',
            'ordering',
            'pulp_label_select',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
            collection_formats['name__in'] = 'csv'  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
        if 'pulp_label_select' in local_var_params and local_var_params['pulp_label_select'] is not None:  # noqa: E501
            query_params.append(('pulp_label_select', local_var_params['pulp_label_select']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/repositories/container/container-push/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedcontainerContainerPushRepositoryResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, container_container_push_repository_href, **kwargs):  # noqa: E501
        """Inspect a container push repository  # noqa: E501

        ViewSet for a container push repository.  POST and DELETE are disallowed because a push repository is tightly coupled with a ContainerDistribution which handles it automatically. Created - during push operation, removed - with ContainerDistribution removal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(container_container_push_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerContainerPushRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(container_container_push_repository_href, **kwargs)  # noqa: E501

    def read_with_http_info(self, container_container_push_repository_href, **kwargs):  # noqa: E501
        """Inspect a container push repository  # noqa: E501

        ViewSet for a container push repository.  POST and DELETE are disallowed because a push repository is tightly coupled with a ContainerDistribution which handles it automatically. Created - during push operation, removed - with ContainerDistribution removal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(container_container_push_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerContainerPushRepositoryResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_push_repository_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_push_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_push_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_push_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_push_repository_href` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_push_repository_href' in local_var_params:
            path_params['container_container_push_repository_href'] = local_var_params['container_container_push_repository_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_push_repository_href}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerContainerPushRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_image(self, container_container_push_repository_href, remove_image, **kwargs):  # noqa: E501
        """Delete an image from a repository  # noqa: E501

        Trigger an asynchronous task to remove a manifest and all its associated data by a digest  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_image(container_container_push_repository_href, remove_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param RemoveImage remove_image: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_image_with_http_info(container_container_push_repository_href, remove_image, **kwargs)  # noqa: E501

    def remove_image_with_http_info(self, container_container_push_repository_href, remove_image, **kwargs):  # noqa: E501
        """Delete an image from a repository  # noqa: E501

        Trigger an asynchronous task to remove a manifest and all its associated data by a digest  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_image_with_http_info(container_container_push_repository_href, remove_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param RemoveImage remove_image: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_push_repository_href',
            'remove_image'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_image" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_push_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_push_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_push_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_push_repository_href` when calling `remove_image`")  # noqa: E501
        # verify the required parameter 'remove_image' is set
        if self.api_client.client_side_validation and ('remove_image' not in local_var_params or  # noqa: E501
                                                        local_var_params['remove_image'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `remove_image` when calling `remove_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_push_repository_href' in local_var_params:
            path_params['container_container_push_repository_href'] = local_var_params['container_container_push_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'remove_image' in local_var_params:
            body_params = local_var_params['remove_image']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_push_repository_href}remove_image/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tag(self, container_container_push_repository_href, tag_image, **kwargs):  # noqa: E501
        """Create a Tag  # noqa: E501

        Trigger an asynchronous task to tag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tag(container_container_push_repository_href, tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param TagImage tag_image: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.tag_with_http_info(container_container_push_repository_href, tag_image, **kwargs)  # noqa: E501

    def tag_with_http_info(self, container_container_push_repository_href, tag_image, **kwargs):  # noqa: E501
        """Create a Tag  # noqa: E501

        Trigger an asynchronous task to tag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tag_with_http_info(container_container_push_repository_href, tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param TagImage tag_image: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_push_repository_href',
            'tag_image'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_push_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_push_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_push_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_push_repository_href` when calling `tag`")  # noqa: E501
        # verify the required parameter 'tag_image' is set
        if self.api_client.client_side_validation and ('tag_image' not in local_var_params or  # noqa: E501
                                                        local_var_params['tag_image'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tag_image` when calling `tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_push_repository_href' in local_var_params:
            path_params['container_container_push_repository_href'] = local_var_params['container_container_push_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tag_image' in local_var_params:
            body_params = local_var_params['tag_image']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_push_repository_href}tag/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def untag(self, container_container_push_repository_href, un_tag_image, **kwargs):  # noqa: E501
        """Delete a tag  # noqa: E501

        Trigger an asynchronous task to untag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.untag(container_container_push_repository_href, un_tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param UnTagImage un_tag_image: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.untag_with_http_info(container_container_push_repository_href, un_tag_image, **kwargs)  # noqa: E501

    def untag_with_http_info(self, container_container_push_repository_href, un_tag_image, **kwargs):  # noqa: E501
        """Delete a tag  # noqa: E501

        Trigger an asynchronous task to untag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.untag_with_http_info(container_container_push_repository_href, un_tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_push_repository_href: (required)
        :param UnTagImage un_tag_image: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_push_repository_href',
            'un_tag_image'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method untag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_push_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_push_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_push_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_push_repository_href` when calling `untag`")  # noqa: E501
        # verify the required parameter 'un_tag_image' is set
        if self.api_client.client_side_validation and ('un_tag_image' not in local_var_params or  # noqa: E501
                                                        local_var_params['un_tag_image'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `un_tag_image` when calling `untag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_push_repository_href' in local_var_params:
            path_params['container_container_push_repository_href'] = local_var_params['container_container_push_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'un_tag_image' in local_var_params:
            body_params = local_var_params['un_tag_image']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_push_repository_href}untag/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
