from typing import Any, Optional

from django.contrib.gis.gdal.base import GDALBase as GDALBase

class OGRGeometry(GDALBase):
    destructor: Any = ...
    ptr: Any = ...
    srs: Any = ...
    __class__: Any = ...
    def __init__(self, geom_input: Any, srs: Optional[Any] = ...) -> None: ...
    @classmethod
    def from_bbox(cls, bbox: Any): ...
    @staticmethod
    def from_json(geom_input: Any): ...
    @classmethod
    def from_gml(cls, gml_string: Any): ...
    def __or__(self, other: Any): ...
    def __and__(self, other: Any): ...
    def __sub__(self, other: Any): ...
    def __xor__(self, other: Any): ...
    def __eq__(self, other: Any) -> Any: ...
    @property
    def dimension(self): ...
    coord_dim: Any = ...
    @property
    def geom_count(self): ...
    @property
    def point_count(self): ...
    @property
    def num_points(self): ...
    @property
    def num_coords(self): ...
    @property
    def geom_type(self): ...
    @property
    def geom_name(self): ...
    @property
    def area(self): ...
    @property
    def envelope(self): ...
    @property
    def empty(self): ...
    @property
    def extent(self): ...
    srid: Any = ...
    @property
    def geos(self): ...
    @property
    def gml(self): ...
    @property
    def hex(self): ...
    @property
    def json(self): ...
    geojson: Any = ...
    @property
    def kml(self): ...
    @property
    def wkb_size(self): ...
    @property
    def wkb(self): ...
    @property
    def wkt(self): ...
    @property
    def ewkt(self): ...
    def clone(self): ...
    def close_rings(self) -> None: ...
    def transform(self, coord_trans: Any, clone: bool = ...): ...
    def intersects(self, other: Any): ...
    def equals(self, other: Any): ...
    def disjoint(self, other: Any): ...
    def touches(self, other: Any): ...
    def crosses(self, other: Any): ...
    def within(self, other: Any): ...
    def contains(self, other: Any): ...
    def overlaps(self, other: Any): ...
    @property
    def boundary(self): ...
    @property
    def convex_hull(self): ...
    def difference(self, other: Any): ...
    def intersection(self, other: Any): ...
    def sym_difference(self, other: Any): ...
    def union(self, other: Any): ...

class Point(OGRGeometry):
    @property
    def x(self): ...
    @property
    def y(self): ...
    @property
    def z(self): ...
    @property
    def tuple(self): ...
    coords: Any = ...

class LineString(OGRGeometry):
    def __getitem__(self, index: Any): ...
    def __len__(self): ...
    @property
    def tuple(self): ...
    coords: Any = ...
    @property
    def x(self): ...
    @property
    def y(self): ...
    @property
    def z(self): ...

class LinearRing(LineString): ...

class Polygon(OGRGeometry):
    def __len__(self): ...
    def __getitem__(self, index: Any): ...
    @property
    def shell(self): ...
    exterior_ring: Any = ...
    @property
    def tuple(self): ...
    coords: Any = ...
    @property
    def point_count(self): ...
    @property
    def centroid(self): ...

class GeometryCollection(OGRGeometry):
    def __getitem__(self, index: Any): ...
    def __len__(self): ...
    def add(self, geom: Any) -> None: ...
    @property
    def point_count(self): ...
    @property
    def tuple(self): ...
    coords: Any = ...

class MultiPoint(GeometryCollection): ...
class MultiLineString(GeometryCollection): ...
class MultiPolygon(GeometryCollection): ...

GEO_CLASSES: Any
