"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
const core_1 = require("@aws-cdk/core");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCase);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this);
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.artifactId,
            stacks: props.stacks.map(s => s.artifactId),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests.IntegTestCase", version: "1.175.0" };
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCaseStack);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests.IntegTestCaseStack", version: "1.175.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTest);
            }
            throw error;
        }
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
    }
    onPrepare() {
        core_1.attachCustomSynthesis(this, {
            onSynthesize: (session) => {
                const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases);
                synthesizer.synthesize(session);
            },
        });
    }
}
exports.IntegTest = IntegTest;
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests.IntegTest", version: "1.175.0" };
//# sourceMappingURL=data:application/json;base64,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