"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureVpcBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_bucket_1 = require("@gammarer/aws-secure-bucket");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
class SecureVpcBucket extends aws_secure_bucket_1.SecureBucket {
    constructor(scope, id, props) {
        super(scope, id, {
            bucketName: props.bucketName,
            encryption: aws_secure_bucket_1.SecureBucketEncryption.KMS_MANAGED,
            versioned: false,
        });
        // 👇Get current account
        const account = cdk.Stack.of(this).account;
        // 👇Access to specific VPCE only
        this.addToResourcePolicy(new iam.PolicyStatement({
            effect: iam.Effect.DENY,
            actions: ['s3:*'],
            // principals: [
            //   new iam.AnyPrincipal(),
            // ],
            notPrincipals: [
                new iam.ArnPrincipal(`arn:aws:iam::${account}:root`),
                new iam.ArnPrincipal(`arn:aws:sts::${account}:assumed-role/*/*`),
                new iam.ArnPrincipal(`arn:aws:iam::${account}:role/*`),
            ],
            resources: [
                `${this.bucketArn}`,
                `${this.bucketArn}/*`,
            ],
            conditions: {
                StringNotEquals: {
                    'aws:SourceVpc': props.vpcEndpointId,
                },
            },
        }));
    }
}
exports.SecureVpcBucket = SecureVpcBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureVpcBucket[_a] = { fqn: "@gammarer/aws-secure-vpc-bucket.SecureVpcBucket", version: "0.5.3" };
//# sourceMappingURL=data:application/json;base64,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