# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: terra/wasm/v1beta1/genesis.proto, terra/wasm/v1beta1/query.proto, terra/wasm/v1beta1/tx.proto, terra/wasm/v1beta1/wasm.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class MsgStoreCode(betterproto.Message):
    """MsgStoreCode represents a message to submit Wasm code to the system"""

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # WASMByteCode can be raw or gzip compressed
    wasm_byte_code: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class MsgStoreCodeResponse(betterproto.Message):
    """MsgStoreCodeResponse defines the Msg/StoreCode response type."""

    # CodeID is the reference to the stored WASM code
    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class MsgMigrateCode(betterproto.Message):
    """
    MsgMigrateCode represents a message to submit Wasm code to the system
    """

    # CodeID is the migration target code id
    code_id: int = betterproto.uint64_field(1)
    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(2)
    # WASMByteCode can be raw or gzip compressed
    wasm_byte_code: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class MsgMigrateCodeResponse(betterproto.Message):
    """MsgMigrateCodeResponse defines the Msg/MigrateCode response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgInstantiateContract(betterproto.Message):
    """
    MsgInstantiateContract represents a message to create a new smart contract
    instance for the given code id.
    """

    # Sender is an sender address
    sender: str = betterproto.string_field(1)
    # Admin is an optional admin address who can migrate the contract
    admin: str = betterproto.string_field(2)
    # CodeID is the reference to the stored WASM code
    code_id: int = betterproto.uint64_field(3)
    # InitMsg json encoded message to be passed to the contract on instantiation
    init_msg: bytes = betterproto.bytes_field(4)
    # InitCoins that are transferred to the contract on execution
    init_coins: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class MsgInstantiateContractResponse(betterproto.Message):
    """
    MsgInstantiateContractResponse defines the Msg/InstantiateContract response
    type.
    """

    # ContractAddress is the bech32 address of the new contract instance.
    contract_address: str = betterproto.string_field(1)
    # Data contains base64-encoded bytes to returned from the contract
    data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class MsgExecuteContract(betterproto.Message):
    """
    MsgExecuteContract represents a message to submits the given message data
    to a smart contract.
    """

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(2)
    # ExecuteMsg json encoded message to be passed to the contract
    execute_msg: bytes = betterproto.bytes_field(3)
    # Coins that are transferred to the contract on execution
    coins: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class MsgExecuteContractResponse(betterproto.Message):
    """
    MsgExecuteContractResponse defines the Msg/ExecuteContract response type.
    """

    # Data contains base64-encoded bytes to returned from the contract
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class MsgMigrateContract(betterproto.Message):
    """
    MsgMigrateContract represents a message to runs a code upgrade/ downgrade
    for a smart contract
    """

    # Admin is the current contract admin
    admin: str = betterproto.string_field(1)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(2)
    # NewCodeID references the new WASM code
    new_code_id: int = betterproto.uint64_field(3)
    # MigrateMsg is json encoded message to be passed to the contract on
    # migration
    migrate_msg: bytes = betterproto.bytes_field(4)


@dataclass(eq=False, repr=False)
class MsgMigrateContractResponse(betterproto.Message):
    """
    MsgMigrateContractResponse defines the Msg/MigrateContract response type.
    """

    # Data contains base64-encoded bytes to returned from the contract
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class MsgUpdateContractAdmin(betterproto.Message):
    """
    MsgUpdateContractAdmin represents a message to sets a new admin for a smart
    contract
    """

    # Admin is the current contract admin
    admin: str = betterproto.string_field(1)
    # NewAdmin is the new contract admin
    new_admin: str = betterproto.string_field(2)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgUpdateContractAdminResponse(betterproto.Message):
    """
    MsgUpdateContractAdminResponse defines the Msg/UpdateContractAdmin response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgClearContractAdmin(betterproto.Message):
    """
    MsgClearContractAdmin represents a message to clear admin address from a
    smart contract
    """

    # Admin is the current contract admin
    admin: str = betterproto.string_field(1)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgClearContractAdminResponse(betterproto.Message):
    """
    MsgClearContractAdminResponse defines the Msg/ClearContractAdmin response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the parameters for the wasm module."""

    max_contract_size: int = betterproto.uint64_field(1)
    max_contract_gas: int = betterproto.uint64_field(2)
    max_contract_msg_size: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class CodeInfo(betterproto.Message):
    """CodeInfo is data for the uploaded contract WASM code"""

    # CodeID is the sequentially increasing unique identifier
    code_id: int = betterproto.uint64_field(1)
    # CodeHash is the unique identifier created by wasmvm
    code_hash: bytes = betterproto.bytes_field(2)
    # Creator address who initially stored the code
    creator: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ContractInfo(betterproto.Message):
    """ContractInfo stores a WASM contract instance"""

    # Address is the address of the contract
    address: str = betterproto.string_field(1)
    # Creator is the contract creator address
    creator: str = betterproto.string_field(2)
    # Admin is who can execute the contract migration
    admin: str = betterproto.string_field(3)
    # CodeID is the reference to the stored Wasm code
    code_id: int = betterproto.uint64_field(4)
    # InitMsg is the raw message used when instantiating a contract
    init_msg: bytes = betterproto.bytes_field(5)


@dataclass(eq=False, repr=False)
class QueryCodeInfoRequest(betterproto.Message):
    """
    QueryCodeInfoRequest is the request type for the QueryyCodeInfo RPC method.
    """

    # grpc-gateway_out does not support Go style CodID
    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class QueryCodeInfoResponse(betterproto.Message):
    """
    QueryCodeInfoResponse is response type for the QueryyCodeInfo RPC method.
    """

    code_info: "CodeInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryByteCodeRequest(betterproto.Message):
    """
    QueryByteCodeRequest is the request type for the QueryyByteCode RPC method.
    """

    # grpc-gateway_out does not support Go style CodID
    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class QueryByteCodeResponse(betterproto.Message):
    """
    QueryByteCodeResponse is response type for the QueryyByteCode RPC method.
    """

    byte_code: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryContractInfoRequest(betterproto.Message):
    """
    QueryContractInfoRequest is the request type for the Query/ContractInfo RPC
    method.
    """

    contract_address: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryContractInfoResponse(betterproto.Message):
    """
    QueryContractInfoResponse is response type for the Query/ContractInfo RPC
    method.
    """

    contract_info: "ContractInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryContractStoreRequest(betterproto.Message):
    """
    QueryContractStoreRequest is the request type for the Query/ContractStore
    RPC method.
    """

    contract_address: str = betterproto.string_field(1)
    query_msg: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryContractStoreResponse(betterproto.Message):
    """
    QueryContractStoreResponse is response type for the Query/ContractStore RPC
    method.
    """

    query_result: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryRawStoreRequest(betterproto.Message):
    """
    QueryRawStoreRequest is the request type for the Query/RawStore RPC method.
    """

    contract_address: str = betterproto.string_field(1)
    key: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryRawStoreResponse(betterproto.Message):
    """
    QueryRawStoreResponse is response type for the Query/RawStore RPC method.
    """

    # Data contains the raw store data
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest is the request type for the Query/Params RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is the response type for the Query/Params RPC method.
    """

    # params defines the parameters of the module.
    params: "Params" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the oracle module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    last_code_id: int = betterproto.uint64_field(2)
    last_instance_id: int = betterproto.uint64_field(3)
    codes: List["Code"] = betterproto.message_field(4)
    contracts: List["Contract"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class Model(betterproto.Message):
    """Model is a struct that holds a KV pair"""

    key: bytes = betterproto.bytes_field(1)
    value: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class Code(betterproto.Message):
    """Code struct encompasses CodeInfo and CodeBytes"""

    code_info: "CodeInfo" = betterproto.message_field(1)
    code_bytes: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class Contract(betterproto.Message):
    """
    Contract struct encompasses ContractAddress, ContractInfo, and
    ContractState
    """

    contract_info: "ContractInfo" = betterproto.message_field(1)
    contract_store: List["Model"] = betterproto.message_field(2)


class MsgStub(betterproto.ServiceStub):
    async def store_code(
        self, *, sender: str = "", wasm_byte_code: bytes = b""
    ) -> "MsgStoreCodeResponse":

        request = MsgStoreCode()
        request.sender = sender
        request.wasm_byte_code = wasm_byte_code

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Msg/StoreCode", request, MsgStoreCodeResponse
        )

    async def migrate_code(
        self, *, code_id: int = 0, sender: str = "", wasm_byte_code: bytes = b""
    ) -> "MsgMigrateCodeResponse":

        request = MsgMigrateCode()
        request.code_id = code_id
        request.sender = sender
        request.wasm_byte_code = wasm_byte_code

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Msg/MigrateCode", request, MsgMigrateCodeResponse
        )

    async def instantiate_contract(
        self,
        *,
        sender: str = "",
        admin: str = "",
        code_id: int = 0,
        init_msg: bytes = b"",
        init_coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]] = None
    ) -> "MsgInstantiateContractResponse":
        init_coins = init_coins or []

        request = MsgInstantiateContract()
        request.sender = sender
        request.admin = admin
        request.code_id = code_id
        request.init_msg = init_msg
        if init_coins is not None:
            request.init_coins = init_coins

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Msg/InstantiateContract",
            request,
            MsgInstantiateContractResponse,
        )

    async def execute_contract(
        self,
        *,
        sender: str = "",
        contract: str = "",
        execute_msg: bytes = b"",
        coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]] = None
    ) -> "MsgExecuteContractResponse":
        coins = coins or []

        request = MsgExecuteContract()
        request.sender = sender
        request.contract = contract
        request.execute_msg = execute_msg
        if coins is not None:
            request.coins = coins

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Msg/ExecuteContract",
            request,
            MsgExecuteContractResponse,
        )

    async def migrate_contract(
        self,
        *,
        admin: str = "",
        contract: str = "",
        new_code_id: int = 0,
        migrate_msg: bytes = b""
    ) -> "MsgMigrateContractResponse":

        request = MsgMigrateContract()
        request.admin = admin
        request.contract = contract
        request.new_code_id = new_code_id
        request.migrate_msg = migrate_msg

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Msg/MigrateContract",
            request,
            MsgMigrateContractResponse,
        )

    async def update_contract_admin(
        self, *, admin: str = "", new_admin: str = "", contract: str = ""
    ) -> "MsgUpdateContractAdminResponse":

        request = MsgUpdateContractAdmin()
        request.admin = admin
        request.new_admin = new_admin
        request.contract = contract

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Msg/UpdateContractAdmin",
            request,
            MsgUpdateContractAdminResponse,
        )

    async def clear_contract_admin(
        self, *, admin: str = "", contract: str = ""
    ) -> "MsgClearContractAdminResponse":

        request = MsgClearContractAdmin()
        request.admin = admin
        request.contract = contract

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Msg/ClearContractAdmin",
            request,
            MsgClearContractAdminResponse,
        )


class QueryStub(betterproto.ServiceStub):
    async def code_info(self, *, code_id: int = 0) -> "QueryCodeInfoResponse":

        request = QueryCodeInfoRequest()
        request.code_id = code_id

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Query/CodeInfo", request, QueryCodeInfoResponse
        )

    async def byte_code(self, *, code_id: int = 0) -> "QueryByteCodeResponse":

        request = QueryByteCodeRequest()
        request.code_id = code_id

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Query/ByteCode", request, QueryByteCodeResponse
        )

    async def contract_info(
        self, *, contract_address: str = ""
    ) -> "QueryContractInfoResponse":

        request = QueryContractInfoRequest()
        request.contract_address = contract_address

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Query/ContractInfo", request, QueryContractInfoResponse
        )

    async def contract_store(
        self, *, contract_address: str = "", query_msg: bytes = b""
    ) -> "QueryContractStoreResponse":

        request = QueryContractStoreRequest()
        request.contract_address = contract_address
        request.query_msg = query_msg

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Query/ContractStore",
            request,
            QueryContractStoreResponse,
        )

    async def raw_store(
        self, *, contract_address: str = "", key: bytes = b""
    ) -> "QueryRawStoreResponse":

        request = QueryRawStoreRequest()
        request.contract_address = contract_address
        request.key = key

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Query/RawStore", request, QueryRawStoreResponse
        )

    async def params(self) -> "QueryParamsResponse":

        request = QueryParamsRequest()

        return await self._unary_unary(
            "/terra.wasm.v1beta1.Query/Params", request, QueryParamsResponse
        )


class MsgBase(ServiceBase):
    async def store_code(
        self, sender: str, wasm_byte_code: bytes
    ) -> "MsgStoreCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def migrate_code(
        self, code_id: int, sender: str, wasm_byte_code: bytes
    ) -> "MsgMigrateCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def instantiate_contract(
        self,
        sender: str,
        admin: str,
        code_id: int,
        init_msg: bytes,
        init_coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]],
    ) -> "MsgInstantiateContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def execute_contract(
        self,
        sender: str,
        contract: str,
        execute_msg: bytes,
        coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]],
    ) -> "MsgExecuteContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def migrate_contract(
        self, admin: str, contract: str, new_code_id: int, migrate_msg: bytes
    ) -> "MsgMigrateContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_contract_admin(
        self, admin: str, new_admin: str, contract: str
    ) -> "MsgUpdateContractAdminResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def clear_contract_admin(
        self, admin: str, contract: str
    ) -> "MsgClearContractAdminResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_store_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "wasm_byte_code": request.wasm_byte_code,
        }

        response = await self.store_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_migrate_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "code_id": request.code_id,
            "sender": request.sender,
            "wasm_byte_code": request.wasm_byte_code,
        }

        response = await self.migrate_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_instantiate_contract(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "admin": request.admin,
            "code_id": request.code_id,
            "init_msg": request.init_msg,
            "init_coins": request.init_coins,
        }

        response = await self.instantiate_contract(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_execute_contract(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "contract": request.contract,
            "execute_msg": request.execute_msg,
            "coins": request.coins,
        }

        response = await self.execute_contract(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_migrate_contract(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "admin": request.admin,
            "contract": request.contract,
            "new_code_id": request.new_code_id,
            "migrate_msg": request.migrate_msg,
        }

        response = await self.migrate_contract(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_update_contract_admin(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "admin": request.admin,
            "new_admin": request.new_admin,
            "contract": request.contract,
        }

        response = await self.update_contract_admin(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_clear_contract_admin(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "admin": request.admin,
            "contract": request.contract,
        }

        response = await self.clear_contract_admin(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/terra.wasm.v1beta1.Msg/StoreCode": grpclib.const.Handler(
                self.__rpc_store_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgStoreCode,
                MsgStoreCodeResponse,
            ),
            "/terra.wasm.v1beta1.Msg/MigrateCode": grpclib.const.Handler(
                self.__rpc_migrate_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgMigrateCode,
                MsgMigrateCodeResponse,
            ),
            "/terra.wasm.v1beta1.Msg/InstantiateContract": grpclib.const.Handler(
                self.__rpc_instantiate_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgInstantiateContract,
                MsgInstantiateContractResponse,
            ),
            "/terra.wasm.v1beta1.Msg/ExecuteContract": grpclib.const.Handler(
                self.__rpc_execute_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgExecuteContract,
                MsgExecuteContractResponse,
            ),
            "/terra.wasm.v1beta1.Msg/MigrateContract": grpclib.const.Handler(
                self.__rpc_migrate_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgMigrateContract,
                MsgMigrateContractResponse,
            ),
            "/terra.wasm.v1beta1.Msg/UpdateContractAdmin": grpclib.const.Handler(
                self.__rpc_update_contract_admin,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUpdateContractAdmin,
                MsgUpdateContractAdminResponse,
            ),
            "/terra.wasm.v1beta1.Msg/ClearContractAdmin": grpclib.const.Handler(
                self.__rpc_clear_contract_admin,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgClearContractAdmin,
                MsgClearContractAdminResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def code_info(self, code_id: int) -> "QueryCodeInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def byte_code(self, code_id: int) -> "QueryByteCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contract_info(self, contract_address: str) -> "QueryContractInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contract_store(
        self, contract_address: str, query_msg: bytes
    ) -> "QueryContractStoreResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def raw_store(
        self, contract_address: str, key: bytes
    ) -> "QueryRawStoreResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(self) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_code_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "code_id": request.code_id,
        }

        response = await self.code_info(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_byte_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "code_id": request.code_id,
        }

        response = await self.byte_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contract_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contract_address": request.contract_address,
        }

        response = await self.contract_info(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contract_store(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contract_address": request.contract_address,
            "query_msg": request.query_msg,
        }

        response = await self.contract_store(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_raw_store(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contract_address": request.contract_address,
            "key": request.key,
        }

        response = await self.raw_store(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_params(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.params(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/terra.wasm.v1beta1.Query/CodeInfo": grpclib.const.Handler(
                self.__rpc_code_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCodeInfoRequest,
                QueryCodeInfoResponse,
            ),
            "/terra.wasm.v1beta1.Query/ByteCode": grpclib.const.Handler(
                self.__rpc_byte_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryByteCodeRequest,
                QueryByteCodeResponse,
            ),
            "/terra.wasm.v1beta1.Query/ContractInfo": grpclib.const.Handler(
                self.__rpc_contract_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractInfoRequest,
                QueryContractInfoResponse,
            ),
            "/terra.wasm.v1beta1.Query/ContractStore": grpclib.const.Handler(
                self.__rpc_contract_store,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractStoreRequest,
                QueryContractStoreResponse,
            ),
            "/terra.wasm.v1beta1.Query/RawStore": grpclib.const.Handler(
                self.__rpc_raw_store,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRawStoreRequest,
                QueryRawStoreResponse,
            ),
            "/terra.wasm.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
        }


from ....cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__
