# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: terra/treasury/v1beta1/genesis.proto, terra/treasury/v1beta1/query.proto, terra/treasury/v1beta1/treasury.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the parameters for the oracle module."""

    tax_policy: "PolicyConstraints" = betterproto.message_field(1)
    reward_policy: "PolicyConstraints" = betterproto.message_field(2)
    seigniorage_burden_target: str = betterproto.string_field(3)
    mining_increment: str = betterproto.string_field(4)
    window_short: int = betterproto.uint64_field(5)
    window_long: int = betterproto.uint64_field(6)
    window_probation: int = betterproto.uint64_field(7)


@dataclass(eq=False, repr=False)
class PolicyConstraints(betterproto.Message):
    """
    PolicyConstraints - defines policy constraints can be applied in tax &
    reward policies
    """

    rate_min: str = betterproto.string_field(1)
    rate_max: str = betterproto.string_field(2)
    cap: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(3)
    change_rate_max: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class EpochTaxProceeds(betterproto.Message):
    """
    EpochTaxProceeds represents the tax amount collected at the current epoch
    """

    tax_proceeds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EpochInitialIssuance(betterproto.Message):
    """
    EpochInitialIssuance represents initial issuance of the currrent epoch
    """

    issuance: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTaxRateRequest(betterproto.Message):
    """
    QueryTaxRateRequest is the request type for the Query/TaxRate RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryTaxRateResponse(betterproto.Message):
    """
    QueryTaxRateResponse is response type for the Query/TaxRate RPC method.
    """

    tax_rate: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryTaxCapRequest(betterproto.Message):
    """
    QueryTaxCapRequest is the request type for the Query/TaxCap RPC method.
    """

    # denom defines the denomination to query for.
    denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryTaxCapResponse(betterproto.Message):
    """
    QueryTaxCapResponse is response type for the Query/TaxCap RPC method.
    """

    tax_cap: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryTaxCapsRequest(betterproto.Message):
    """
    QueryTaxCapsRequest is the request type for the Query/TaxCaps RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryTaxCapsResponseItem(betterproto.Message):
    """
    QueryTaxCapsResponseItem is response item type for the Query/TaxCaps RPC
    method.
    """

    denom: str = betterproto.string_field(1)
    tax_cap: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryTaxCapsResponse(betterproto.Message):
    """
    QueryTaxCapsResponse is response type for the Query/TaxCaps RPC method.
    """

    tax_caps: List["QueryTaxCapsResponseItem"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryRewardWeightRequest(betterproto.Message):
    """
    QueryRewardWeightRequest is the request type for the Query/RewardWeight RPC
    method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryRewardWeightResponse(betterproto.Message):
    """
    QueryRewardWeightResponse is response type for the Query/RewardWeight RPC
    method.
    """

    reward_weight: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryTaxProceedsRequest(betterproto.Message):
    """
    QueryTaxProceedsRequest is the request type for the Query/TaxProceeds RPC
    method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryTaxProceedsResponse(betterproto.Message):
    """
    QueryTaxProceedsResponse is response type for the Query/TaxProceeds RPC
    method.
    """

    tax_proceeds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QuerySeigniorageProceedsRequest(betterproto.Message):
    """
    QuerySeigniorageProceedsRequest is the request type for the
    Query/SeigniorageProceeds RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QuerySeigniorageProceedsResponse(betterproto.Message):
    """
    QuerySeigniorageProceedsResponse is response type for the
    Query/SeigniorageProceeds RPC method.
    """

    seigniorage_proceeds: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryIndicatorsRequest(betterproto.Message):
    """
    QueryIndicatorsRequest is the request type for the Query/Indicators RPC
    method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryIndicatorsResponse(betterproto.Message):
    """
    QueryIndicatorsResponse is response type for the Query/Indicators RPC
    method.
    """

    trl_year: str = betterproto.string_field(1)
    trl_month: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest is the request type for the Query/Params RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is the response type for the Query/Params RPC method.
    """

    # params defines the parameters of the module.
    params: "Params" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the oracle module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    tax_rate: str = betterproto.string_field(2)
    reward_weight: str = betterproto.string_field(3)
    tax_caps: List["TaxCap"] = betterproto.message_field(4)
    tax_proceeds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)
    epoch_initial_issuance: List[
        "___cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(6)
    epoch_states: List["EpochState"] = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class TaxCap(betterproto.Message):
    """TaxCap is the max tax amount can be charged for the given denom"""

    denom: str = betterproto.string_field(1)
    tax_cap: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class EpochState(betterproto.Message):
    """EpochState is the record for each epoch state"""

    epoch: int = betterproto.uint64_field(1)
    tax_reward: str = betterproto.string_field(2)
    seigniorage_reward: str = betterproto.string_field(3)
    total_staked_luna: str = betterproto.string_field(4)


class QueryStub(betterproto.ServiceStub):
    async def tax_rate(self) -> "QueryTaxRateResponse":

        request = QueryTaxRateRequest()

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/TaxRate", request, QueryTaxRateResponse
        )

    async def tax_cap(self, *, denom: str = "") -> "QueryTaxCapResponse":

        request = QueryTaxCapRequest()
        request.denom = denom

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/TaxCap", request, QueryTaxCapResponse
        )

    async def tax_caps(self) -> "QueryTaxCapsResponse":

        request = QueryTaxCapsRequest()

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/TaxCaps", request, QueryTaxCapsResponse
        )

    async def reward_weight(self) -> "QueryRewardWeightResponse":

        request = QueryRewardWeightRequest()

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/RewardWeight",
            request,
            QueryRewardWeightResponse,
        )

    async def seigniorage_proceeds(self) -> "QuerySeigniorageProceedsResponse":

        request = QuerySeigniorageProceedsRequest()

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/SeigniorageProceeds",
            request,
            QuerySeigniorageProceedsResponse,
        )

    async def tax_proceeds(self) -> "QueryTaxProceedsResponse":

        request = QueryTaxProceedsRequest()

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/TaxProceeds",
            request,
            QueryTaxProceedsResponse,
        )

    async def indicators(self) -> "QueryIndicatorsResponse":

        request = QueryIndicatorsRequest()

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/Indicators", request, QueryIndicatorsResponse
        )

    async def params(self) -> "QueryParamsResponse":

        request = QueryParamsRequest()

        return await self._unary_unary(
            "/terra.treasury.v1beta1.Query/Params", request, QueryParamsResponse
        )


class QueryBase(ServiceBase):
    async def tax_rate(self) -> "QueryTaxRateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def tax_cap(self, denom: str) -> "QueryTaxCapResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def tax_caps(self) -> "QueryTaxCapsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reward_weight(self) -> "QueryRewardWeightResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def seigniorage_proceeds(self) -> "QuerySeigniorageProceedsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def tax_proceeds(self) -> "QueryTaxProceedsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def indicators(self) -> "QueryIndicatorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(self) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_tax_rate(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.tax_rate(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_tax_cap(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "denom": request.denom,
        }

        response = await self.tax_cap(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_tax_caps(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.tax_caps(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_reward_weight(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.reward_weight(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_seigniorage_proceeds(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.seigniorage_proceeds(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_tax_proceeds(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.tax_proceeds(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_indicators(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.indicators(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_params(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.params(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/terra.treasury.v1beta1.Query/TaxRate": grpclib.const.Handler(
                self.__rpc_tax_rate,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTaxRateRequest,
                QueryTaxRateResponse,
            ),
            "/terra.treasury.v1beta1.Query/TaxCap": grpclib.const.Handler(
                self.__rpc_tax_cap,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTaxCapRequest,
                QueryTaxCapResponse,
            ),
            "/terra.treasury.v1beta1.Query/TaxCaps": grpclib.const.Handler(
                self.__rpc_tax_caps,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTaxCapsRequest,
                QueryTaxCapsResponse,
            ),
            "/terra.treasury.v1beta1.Query/RewardWeight": grpclib.const.Handler(
                self.__rpc_reward_weight,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRewardWeightRequest,
                QueryRewardWeightResponse,
            ),
            "/terra.treasury.v1beta1.Query/SeigniorageProceeds": grpclib.const.Handler(
                self.__rpc_seigniorage_proceeds,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySeigniorageProceedsRequest,
                QuerySeigniorageProceedsResponse,
            ),
            "/terra.treasury.v1beta1.Query/TaxProceeds": grpclib.const.Handler(
                self.__rpc_tax_proceeds,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTaxProceedsRequest,
                QueryTaxProceedsResponse,
            ),
            "/terra.treasury.v1beta1.Query/Indicators": grpclib.const.Handler(
                self.__rpc_indicators,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryIndicatorsRequest,
                QueryIndicatorsResponse,
            ),
            "/terra.treasury.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
        }


from ....cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__
