# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: tendermint/liquidity/v1beta1/genesis.proto, tendermint/liquidity/v1beta1/liquidity.proto, tendermint/liquidity/v1beta1/query.proto, tendermint/liquidity/v1beta1/tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class MsgCreatePool(betterproto.Message):
    """
    MsgCreatePool defines an sdk.Msg type that supports submitting a create
    liquidity pool tx. See: https://github.com/tendermint/liquidity/blob/develo
    p/x/liquidity/spec/04_messages.md
    """

    pool_creator_address: str = betterproto.string_field(1)
    # id of the target pool type, must match the value in the pool. Only pool-
    # type-id 1 is supported.
    pool_type_id: int = betterproto.uint32_field(2)
    # reserve coin pair of the pool to deposit.
    deposit_coins: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class MsgCreatePoolResponse(betterproto.Message):
    """MsgCreatePoolResponse defines the Msg/CreatePool response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgDepositWithinBatch(betterproto.Message):
    """
    `MsgDepositWithinBatch defines` an `sdk.Msg` type that supports submitting
    a deposit request to the batch of the liquidity pool. Deposit is submitted
    to the batch of the Liquidity pool with the specified  `pool_id`,
    `deposit_coins` for reserve. This request is stacked in the batch of the
    liquidity pool, is not processed  immediately, and is processed in the
    `endblock` at the same time as other requests. See: https://github.com/tend
    ermint/liquidity/blob/develop/x/liquidity/spec/04_messages.md
    """

    depositor_address: str = betterproto.string_field(1)
    # id of the target pool
    pool_id: int = betterproto.uint64_field(2)
    # reserve coin pair of the pool to deposit
    deposit_coins: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgDepositWithinBatchResponse(betterproto.Message):
    """
    MsgDepositWithinBatchResponse defines the Msg/DepositWithinBatch response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgWithdrawWithinBatch(betterproto.Message):
    """
    `MsgWithdrawWithinBatch` defines an `sdk.Msg` type that supports submitting
    a withdraw request to the batch of the liquidity pool. Withdraw is
    submitted to the batch from the Liquidity pool with the  specified
    `pool_id`, `pool_coin` of the pool. This request is stacked in the batch of
    the liquidity pool, is not processed  immediately, and is processed in the
    `endblock` at the same time as other requests. See: https://github.com/tend
    ermint/liquidity/blob/develop/x/liquidity/spec/04_messages.md
    """

    withdrawer_address: str = betterproto.string_field(1)
    # id of the target pool
    pool_id: int = betterproto.uint64_field(2)
    pool_coin: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgWithdrawWithinBatchResponse(betterproto.Message):
    """
    MsgWithdrawWithinBatchResponse defines the Msg/WithdrawWithinBatch response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgSwapWithinBatch(betterproto.Message):
    """
    `MsgSwapWithinBatch` defines an sdk.Msg type that supports submitting a
    swap offer request to the batch of the liquidity pool. Submit swap offer to
    the liquidity pool batch with the specified the `pool_id`, `swap_type_id`,
    `demand_coin_denom` with the coin and the price you're offering and
    `offer_coin_fee` must be half of offer coin amount * current
    `params.swap_fee_rate` and ceil for reservation to pay fees. This request
    is stacked in the batch of the liquidity pool, is not processed
    immediately, and is processed in the `endblock` at the same time as other
    requests. You must request the same fields as the pool. Only the default
    `swap_type_id` 1 is supported. See:
    https://github.com/tendermint/liquidity/tree/develop/doc https://github.com
    /tendermint/liquidity/blob/develop/x/liquidity/spec/04_messages.md
    """

    # address of swap requester
    swap_requester_address: str = betterproto.string_field(1)
    # id of swap type, must match the value in the pool. Only `swap_type_id` 1 is
    # supported.
    pool_id: int = betterproto.uint64_field(2)
    # id of swap type. Must match the value in the pool.
    swap_type_id: int = betterproto.uint32_field(3)
    # offer sdk.coin for the swap request, must match the denom in the pool.
    offer_coin: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(4)
    # denom of demand coin to be exchanged on the swap request, must match the
    # denom in the pool.
    demand_coin_denom: str = betterproto.string_field(5)
    # half of offer coin amount * params.swap_fee_rate and ceil for reservation
    # to pay fees.
    offer_coin_fee: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(6)
    # limit order price for the order, the price is the exchange ratio of X/Y
    # where X is the amount of the first coin and Y is the amount  of the second
    # coin when their denoms are sorted alphabetically.
    order_price: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgSwapWithinBatchResponse(betterproto.Message):
    """MsgSwapWithinBatchResponse defines the Msg/Swap response type."""

    pass


@dataclass(eq=False, repr=False)
class PoolType(betterproto.Message):
    """
    Structure for the pool type to distinguish the characteristics of the
    reserve pools.
    """

    # This is the id of the pool_type that is used as pool_type_id for pool
    # creation. In this version, only pool-type-id 1 is supported. {"id":1,"name"
    # :"ConstantProductLiquidityPool","min_reserve_coin_num":2,"max_reserve_coin_
    # num":2,"description":""}
    id: int = betterproto.uint32_field(1)
    # name of the pool type.
    name: str = betterproto.string_field(2)
    # minimum number of reserveCoins for LiquidityPoolType, only 2 reserve coins
    # are supported.
    min_reserve_coin_num: int = betterproto.uint32_field(3)
    # maximum number of reserveCoins for LiquidityPoolType, only 2 reserve coins
    # are supported.
    max_reserve_coin_num: int = betterproto.uint32_field(4)
    # description of the pool type.
    description: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the parameters for the liquidity module."""

    # list of available pool types
    pool_types: List["PoolType"] = betterproto.message_field(1)
    # Minimum number of coins to be deposited to the liquidity pool on pool
    # creation.
    min_init_deposit_amount: str = betterproto.string_field(2)
    # Initial mint amount of pool coins upon pool creation.
    init_pool_coin_mint_amount: str = betterproto.string_field(3)
    # Limit the size of each liquidity pool to minimize risk. In development, set
    # to 0 for no limit. In production, set a limit.
    max_reserve_coin_amount: str = betterproto.string_field(4)
    # Fee paid to create a Liquidity Pool. Set a fee to prevent spamming.
    pool_creation_fee: List[
        "___cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(5)
    # Swap fee rate for every executed swap.
    swap_fee_rate: str = betterproto.string_field(6)
    # Reserve coin withdrawal with less proportion by withdrawFeeRate.
    withdraw_fee_rate: str = betterproto.string_field(7)
    # Maximum ratio of reserve coins that can be ordered at a swap order.
    max_order_amount_ratio: str = betterproto.string_field(8)
    # The smallest unit batch height for every liquidity pool.
    unit_batch_height: int = betterproto.uint32_field(9)
    # Circuit breaker enables or disables transaction messages in liquidity
    # module.
    circuit_breaker_enabled: bool = betterproto.bool_field(10)


@dataclass(eq=False, repr=False)
class Pool(betterproto.Message):
    """Pool defines the liquidity pool that contains pool information."""

    # id of the pool
    id: int = betterproto.uint64_field(1)
    # id of the pool_type
    type_id: int = betterproto.uint32_field(2)
    # denoms of reserve coin pair of the pool
    reserve_coin_denoms: List[str] = betterproto.string_field(3)
    # reserve account address of the pool
    reserve_account_address: str = betterproto.string_field(4)
    # denom of pool coin of the pool
    pool_coin_denom: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class PoolMetadata(betterproto.Message):
    """
    Metadata for the state of each pool for invariant checking after genesis
    export or import.
    """

    # id of the pool
    pool_id: int = betterproto.uint64_field(1)
    # pool coin issued at the pool
    pool_coin_total_supply: "___cosmos_base_v1_beta1__.Coin" = (
        betterproto.message_field(2)
    )
    # reserve coins deposited in the pool
    reserve_coins: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class PoolBatch(betterproto.Message):
    """
    PoolBatch defines the batch or batches of a given liquidity pool that
    contains indexes of deposit, withdraw, and swap messages.  Index param
    increments by 1 if the pool id is same.
    """

    # id of the pool
    pool_id: int = betterproto.uint64_field(1)
    # index of this batch
    index: int = betterproto.uint64_field(2)
    # height where this batch is started
    begin_height: int = betterproto.int64_field(3)
    # last index of DepositMsgStates
    deposit_msg_index: int = betterproto.uint64_field(4)
    # last index of WithdrawMsgStates
    withdraw_msg_index: int = betterproto.uint64_field(5)
    # last index of SwapMsgStates
    swap_msg_index: int = betterproto.uint64_field(6)
    # true if executed, false if not executed
    executed: bool = betterproto.bool_field(7)


@dataclass(eq=False, repr=False)
class DepositMsgState(betterproto.Message):
    """
    DepositMsgState defines the state of deposit message that contains state
    information as it is processed in the next batch or batches.
    """

    # height where this message is appended to the batch
    msg_height: int = betterproto.int64_field(1)
    # index of this deposit message in this liquidity pool
    msg_index: int = betterproto.uint64_field(2)
    # true if executed on this batch, false if not executed
    executed: bool = betterproto.bool_field(3)
    # true if executed successfully on this batch, false if failed
    succeeded: bool = betterproto.bool_field(4)
    # true if ready to be deleted on kvstore, false if not ready to be deleted
    to_be_deleted: bool = betterproto.bool_field(5)
    # MsgDepositWithinBatch
    msg: "MsgDepositWithinBatch" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class WithdrawMsgState(betterproto.Message):
    """
    WithdrawMsgState defines the state of the withdraw message that contains
    state information as the message is processed in the next batch or batches.
    """

    # height where this message is appended to the batch
    msg_height: int = betterproto.int64_field(1)
    # index of this withdraw message in this liquidity pool
    msg_index: int = betterproto.uint64_field(2)
    # true if executed on this batch, false if not executed
    executed: bool = betterproto.bool_field(3)
    # true if executed successfully on this batch, false if failed
    succeeded: bool = betterproto.bool_field(4)
    # true if ready to be deleted on kvstore, false if not ready to be deleted
    to_be_deleted: bool = betterproto.bool_field(5)
    # MsgWithdrawWithinBatch
    msg: "MsgWithdrawWithinBatch" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class SwapMsgState(betterproto.Message):
    """
    SwapMsgState defines the state of the swap message that contains state
    information as the message is processed in the next batch or batches.
    """

    # height where this message is appended to the batch
    msg_height: int = betterproto.int64_field(1)
    # index of this swap message in this liquidity pool
    msg_index: int = betterproto.uint64_field(2)
    # true if executed on this batch, false if not executed
    executed: bool = betterproto.bool_field(3)
    # true if executed successfully on this batch, false if failed
    succeeded: bool = betterproto.bool_field(4)
    # true if ready to be deleted on kvstore, false if not ready to be deleted
    to_be_deleted: bool = betterproto.bool_field(5)
    # swap orders are cancelled when current height is equal to or higher than
    # ExpiryHeight
    order_expiry_height: int = betterproto.int64_field(6)
    # offer coin exchanged until now
    exchanged_offer_coin: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(
        7
    )
    # offer coin currently remaining to be exchanged
    remaining_offer_coin: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(
        8
    )
    # reserve fee for pays fee in half offer coin
    reserved_offer_coin_fee: "___cosmos_base_v1_beta1__.Coin" = (
        betterproto.message_field(9)
    )
    # MsgSwapWithinBatch
    msg: "MsgSwapWithinBatch" = betterproto.message_field(10)


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolRequest(betterproto.Message):
    """
    the request type for the QueryLiquidityPool RPC method. requestable
    specified pool_id.
    """

    pool_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolResponse(betterproto.Message):
    """
    the response type for the QueryLiquidityPoolResponse RPC method. Returns
    the liquidity pool that corresponds to the requested pool_id.
    """

    pool: "Pool" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolByPoolCoinDenomRequest(betterproto.Message):
    """
    the request type for the QueryLiquidityByPoolCoinDenomPool RPC method.
    Requestable specified pool_coin_denom.
    """

    pool_coin_denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolByReserveAccRequest(betterproto.Message):
    """
    the request type for the QueryLiquidityByReserveAcc RPC method. Requestable
    specified reserve_acc.
    """

    reserve_acc: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolBatchRequest(betterproto.Message):
    """
    the request type for the QueryLiquidityPoolBatch RPC method. requestable
    including specified pool_id.
    """

    # id of the target pool for query
    pool_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolBatchResponse(betterproto.Message):
    """
    the response type for the QueryLiquidityPoolBatchResponse RPC method.
    Returns the liquidity pool batch that corresponds to the requested pool_id.
    """

    batch: "PoolBatch" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolsRequest(betterproto.Message):
    """
    the request type for the QueryLiquidityPools RPC method. Requestable
    including pagination offset, limit, key.
    """

    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )


@dataclass(eq=False, repr=False)
class QueryLiquidityPoolsResponse(betterproto.Message):
    """
    the response type for the QueryLiquidityPoolsResponse RPC method. This
    includes a list of all existing liquidity pools and paging results that
    contain next_key and total count.
    """

    pools: List["Pool"] = betterproto.message_field(1)
    # pagination defines the pagination in the response. not working on this
    # version.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """QueryParamsRequest is request type for the QueryParams RPC method."""

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    the response type for the QueryParamsResponse RPC method. This includes
    current parameter of the liquidity module.
    """

    # params holds all the parameters of this module.
    params: "Params" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryPoolBatchSwapMsgsRequest(betterproto.Message):
    """
    the request type for the QueryPoolBatchSwapMsgs RPC method. Requestable
    including specified pool_id and pagination offset, limit, key.
    """

    # id of the target pool for query
    pool_id: int = betterproto.uint64_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPoolBatchSwapMsgRequest(betterproto.Message):
    """
    the request type for the QueryPoolBatchSwap RPC method. Requestable
    including specified pool_id and msg_index.
    """

    # id of the target pool for query
    pool_id: int = betterproto.uint64_field(1)
    # target msg_index of the pool
    msg_index: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class QueryPoolBatchSwapMsgsResponse(betterproto.Message):
    """
    the response type for the QueryPoolBatchSwapMsgs RPC method. This includes
    list of all currently existing swap messages of the batch and paging
    results that contain next_key and total count.
    """

    swaps: List["SwapMsgState"] = betterproto.message_field(1)
    # pagination defines the pagination in the response. not working on this
    # version.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPoolBatchSwapMsgResponse(betterproto.Message):
    """
    the response type for the QueryPoolBatchSwapMsg RPC method. This includes a
    batch swap message of the batch.
    """

    swap: "SwapMsgState" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryPoolBatchDepositMsgsRequest(betterproto.Message):
    """
    the request type for the QueryPoolBatchDeposit RPC method. Requestable
    including specified pool_id and pagination offset, limit, key.
    """

    # id of the target pool for query
    pool_id: int = betterproto.uint64_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPoolBatchDepositMsgRequest(betterproto.Message):
    """
    the request type for the QueryPoolBatchDeposit RPC method. requestable
    including specified pool_id and msg_index.
    """

    # id of the target pool for query
    pool_id: int = betterproto.uint64_field(1)
    # target msg_index of the pool
    msg_index: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class QueryPoolBatchDepositMsgsResponse(betterproto.Message):
    """
    the response type for the QueryPoolBatchDeposit RPC method. This includes a
    list of all currently existing deposit messages of the batch and paging
    results that contain next_key and total count.
    """

    deposits: List["DepositMsgState"] = betterproto.message_field(1)
    # pagination defines the pagination in the response. not working on this
    # version.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPoolBatchDepositMsgResponse(betterproto.Message):
    """
    the response type for the QueryPoolBatchDepositMsg RPC method. This
    includes a batch swap message of the batch.
    """

    deposit: "DepositMsgState" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryPoolBatchWithdrawMsgsRequest(betterproto.Message):
    """
    the request type for the QueryPoolBatchWithdraw RPC method. Requestable
    including specified pool_id and pagination offset, limit, key.
    """

    # id of the target pool for query
    pool_id: int = betterproto.uint64_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPoolBatchWithdrawMsgRequest(betterproto.Message):
    """
    the request type for the QueryPoolBatchWithdraw RPC method. requestable
    including specified pool_id and msg_index.
    """

    # id of the target pool for query
    pool_id: int = betterproto.uint64_field(1)
    # target msg_index of the pool
    msg_index: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class QueryPoolBatchWithdrawMsgsResponse(betterproto.Message):
    """
    the response type for the QueryPoolBatchWithdraw RPC method. This includes
    a list of all currently existing withdraw messages of the batch and paging
    results that contain next_key and total count.
    """

    withdraws: List["WithdrawMsgState"] = betterproto.message_field(1)
    # pagination defines the pagination in the response. Not supported on this
    # version.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPoolBatchWithdrawMsgResponse(betterproto.Message):
    """
    the response type for the QueryPoolBatchWithdrawMsg RPC method. This
    includes a batch swap message of the batch.
    """

    withdraw: "WithdrawMsgState" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class PoolRecord(betterproto.Message):
    """
    records the state of each pool after genesis export or import, used to
    check variables
    """

    pool: "Pool" = betterproto.message_field(1)
    pool_metadata: "PoolMetadata" = betterproto.message_field(2)
    pool_batch: "PoolBatch" = betterproto.message_field(3)
    deposit_msg_states: List["DepositMsgState"] = betterproto.message_field(4)
    withdraw_msg_states: List["WithdrawMsgState"] = betterproto.message_field(5)
    swap_msg_states: List["SwapMsgState"] = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the liquidity module's genesis state."""

    # params defines all the parameters for the liquidity module.
    params: "Params" = betterproto.message_field(1)
    pool_records: List["PoolRecord"] = betterproto.message_field(2)


class MsgStub(betterproto.ServiceStub):
    async def create_pool(
        self,
        *,
        pool_creator_address: str = "",
        pool_type_id: int = 0,
        deposit_coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]] = None
    ) -> "MsgCreatePoolResponse":
        deposit_coins = deposit_coins or []

        request = MsgCreatePool()
        request.pool_creator_address = pool_creator_address
        request.pool_type_id = pool_type_id
        if deposit_coins is not None:
            request.deposit_coins = deposit_coins

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Msg/CreatePool",
            request,
            MsgCreatePoolResponse,
        )

    async def deposit_within_batch(
        self,
        *,
        depositor_address: str = "",
        pool_id: int = 0,
        deposit_coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]] = None
    ) -> "MsgDepositWithinBatchResponse":
        deposit_coins = deposit_coins or []

        request = MsgDepositWithinBatch()
        request.depositor_address = depositor_address
        request.pool_id = pool_id
        if deposit_coins is not None:
            request.deposit_coins = deposit_coins

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Msg/DepositWithinBatch",
            request,
            MsgDepositWithinBatchResponse,
        )

    async def withdraw_within_batch(
        self,
        *,
        withdrawer_address: str = "",
        pool_id: int = 0,
        pool_coin: "___cosmos_base_v1_beta1__.Coin" = None
    ) -> "MsgWithdrawWithinBatchResponse":

        request = MsgWithdrawWithinBatch()
        request.withdrawer_address = withdrawer_address
        request.pool_id = pool_id
        if pool_coin is not None:
            request.pool_coin = pool_coin

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Msg/WithdrawWithinBatch",
            request,
            MsgWithdrawWithinBatchResponse,
        )

    async def swap(
        self,
        *,
        swap_requester_address: str = "",
        pool_id: int = 0,
        swap_type_id: int = 0,
        offer_coin: "___cosmos_base_v1_beta1__.Coin" = None,
        demand_coin_denom: str = "",
        offer_coin_fee: "___cosmos_base_v1_beta1__.Coin" = None,
        order_price: str = ""
    ) -> "MsgSwapWithinBatchResponse":

        request = MsgSwapWithinBatch()
        request.swap_requester_address = swap_requester_address
        request.pool_id = pool_id
        request.swap_type_id = swap_type_id
        if offer_coin is not None:
            request.offer_coin = offer_coin
        request.demand_coin_denom = demand_coin_denom
        if offer_coin_fee is not None:
            request.offer_coin_fee = offer_coin_fee
        request.order_price = order_price

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Msg/Swap",
            request,
            MsgSwapWithinBatchResponse,
        )


class QueryStub(betterproto.ServiceStub):
    async def liquidity_pools(
        self, *, pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryLiquidityPoolsResponse":

        request = QueryLiquidityPoolsRequest()
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/LiquidityPools",
            request,
            QueryLiquidityPoolsResponse,
        )

    async def liquidity_pool(self, *, pool_id: int = 0) -> "QueryLiquidityPoolResponse":

        request = QueryLiquidityPoolRequest()
        request.pool_id = pool_id

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/LiquidityPool",
            request,
            QueryLiquidityPoolResponse,
        )

    async def liquidity_pool_by_pool_coin_denom(
        self, *, pool_coin_denom: str = ""
    ) -> "QueryLiquidityPoolResponse":

        request = QueryLiquidityPoolByPoolCoinDenomRequest()
        request.pool_coin_denom = pool_coin_denom

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/LiquidityPoolByPoolCoinDenom",
            request,
            QueryLiquidityPoolResponse,
        )

    async def liquidity_pool_by_reserve_acc(
        self, *, reserve_acc: str = ""
    ) -> "QueryLiquidityPoolResponse":

        request = QueryLiquidityPoolByReserveAccRequest()
        request.reserve_acc = reserve_acc

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/LiquidityPoolByReserveAcc",
            request,
            QueryLiquidityPoolResponse,
        )

    async def liquidity_pool_batch(
        self, *, pool_id: int = 0
    ) -> "QueryLiquidityPoolBatchResponse":

        request = QueryLiquidityPoolBatchRequest()
        request.pool_id = pool_id

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/LiquidityPoolBatch",
            request,
            QueryLiquidityPoolBatchResponse,
        )

    async def pool_batch_swap_msgs(
        self,
        *,
        pool_id: int = 0,
        pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryPoolBatchSwapMsgsResponse":

        request = QueryPoolBatchSwapMsgsRequest()
        request.pool_id = pool_id
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/PoolBatchSwapMsgs",
            request,
            QueryPoolBatchSwapMsgsResponse,
        )

    async def pool_batch_swap_msg(
        self, *, pool_id: int = 0, msg_index: int = 0
    ) -> "QueryPoolBatchSwapMsgResponse":

        request = QueryPoolBatchSwapMsgRequest()
        request.pool_id = pool_id
        request.msg_index = msg_index

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/PoolBatchSwapMsg",
            request,
            QueryPoolBatchSwapMsgResponse,
        )

    async def pool_batch_deposit_msgs(
        self,
        *,
        pool_id: int = 0,
        pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryPoolBatchDepositMsgsResponse":

        request = QueryPoolBatchDepositMsgsRequest()
        request.pool_id = pool_id
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/PoolBatchDepositMsgs",
            request,
            QueryPoolBatchDepositMsgsResponse,
        )

    async def pool_batch_deposit_msg(
        self, *, pool_id: int = 0, msg_index: int = 0
    ) -> "QueryPoolBatchDepositMsgResponse":

        request = QueryPoolBatchDepositMsgRequest()
        request.pool_id = pool_id
        request.msg_index = msg_index

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/PoolBatchDepositMsg",
            request,
            QueryPoolBatchDepositMsgResponse,
        )

    async def pool_batch_withdraw_msgs(
        self,
        *,
        pool_id: int = 0,
        pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryPoolBatchWithdrawMsgsResponse":

        request = QueryPoolBatchWithdrawMsgsRequest()
        request.pool_id = pool_id
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/PoolBatchWithdrawMsgs",
            request,
            QueryPoolBatchWithdrawMsgsResponse,
        )

    async def pool_batch_withdraw_msg(
        self, *, pool_id: int = 0, msg_index: int = 0
    ) -> "QueryPoolBatchWithdrawMsgResponse":

        request = QueryPoolBatchWithdrawMsgRequest()
        request.pool_id = pool_id
        request.msg_index = msg_index

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/PoolBatchWithdrawMsg",
            request,
            QueryPoolBatchWithdrawMsgResponse,
        )

    async def params(self) -> "QueryParamsResponse":

        request = QueryParamsRequest()

        return await self._unary_unary(
            "/tendermint.liquidity.v1beta1.Query/Params", request, QueryParamsResponse
        )


class MsgBase(ServiceBase):
    async def create_pool(
        self,
        pool_creator_address: str,
        pool_type_id: int,
        deposit_coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]],
    ) -> "MsgCreatePoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def deposit_within_batch(
        self,
        depositor_address: str,
        pool_id: int,
        deposit_coins: Optional[List["___cosmos_base_v1_beta1__.Coin"]],
    ) -> "MsgDepositWithinBatchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def withdraw_within_batch(
        self,
        withdrawer_address: str,
        pool_id: int,
        pool_coin: "___cosmos_base_v1_beta1__.Coin",
    ) -> "MsgWithdrawWithinBatchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def swap(
        self,
        swap_requester_address: str,
        pool_id: int,
        swap_type_id: int,
        offer_coin: "___cosmos_base_v1_beta1__.Coin",
        demand_coin_denom: str,
        offer_coin_fee: "___cosmos_base_v1_beta1__.Coin",
        order_price: str,
    ) -> "MsgSwapWithinBatchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_pool(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_creator_address": request.pool_creator_address,
            "pool_type_id": request.pool_type_id,
            "deposit_coins": request.deposit_coins,
        }

        response = await self.create_pool(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_deposit_within_batch(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "depositor_address": request.depositor_address,
            "pool_id": request.pool_id,
            "deposit_coins": request.deposit_coins,
        }

        response = await self.deposit_within_batch(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_withdraw_within_batch(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "withdrawer_address": request.withdrawer_address,
            "pool_id": request.pool_id,
            "pool_coin": request.pool_coin,
        }

        response = await self.withdraw_within_batch(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_swap(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "swap_requester_address": request.swap_requester_address,
            "pool_id": request.pool_id,
            "swap_type_id": request.swap_type_id,
            "offer_coin": request.offer_coin,
            "demand_coin_denom": request.demand_coin_denom,
            "offer_coin_fee": request.offer_coin_fee,
            "order_price": request.order_price,
        }

        response = await self.swap(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/tendermint.liquidity.v1beta1.Msg/CreatePool": grpclib.const.Handler(
                self.__rpc_create_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreatePool,
                MsgCreatePoolResponse,
            ),
            "/tendermint.liquidity.v1beta1.Msg/DepositWithinBatch": grpclib.const.Handler(
                self.__rpc_deposit_within_batch,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgDepositWithinBatch,
                MsgDepositWithinBatchResponse,
            ),
            "/tendermint.liquidity.v1beta1.Msg/WithdrawWithinBatch": grpclib.const.Handler(
                self.__rpc_withdraw_within_batch,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgWithdrawWithinBatch,
                MsgWithdrawWithinBatchResponse,
            ),
            "/tendermint.liquidity.v1beta1.Msg/Swap": grpclib.const.Handler(
                self.__rpc_swap,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSwapWithinBatch,
                MsgSwapWithinBatchResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def liquidity_pools(
        self, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryLiquidityPoolsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def liquidity_pool(self, pool_id: int) -> "QueryLiquidityPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def liquidity_pool_by_pool_coin_denom(
        self, pool_coin_denom: str
    ) -> "QueryLiquidityPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def liquidity_pool_by_reserve_acc(
        self, reserve_acc: str
    ) -> "QueryLiquidityPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def liquidity_pool_batch(
        self, pool_id: int
    ) -> "QueryLiquidityPoolBatchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool_batch_swap_msgs(
        self, pool_id: int, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryPoolBatchSwapMsgsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool_batch_swap_msg(
        self, pool_id: int, msg_index: int
    ) -> "QueryPoolBatchSwapMsgResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool_batch_deposit_msgs(
        self, pool_id: int, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryPoolBatchDepositMsgsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool_batch_deposit_msg(
        self, pool_id: int, msg_index: int
    ) -> "QueryPoolBatchDepositMsgResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool_batch_withdraw_msgs(
        self, pool_id: int, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryPoolBatchWithdrawMsgsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool_batch_withdraw_msg(
        self, pool_id: int, msg_index: int
    ) -> "QueryPoolBatchWithdrawMsgResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(self) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_liquidity_pools(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
        }

        response = await self.liquidity_pools(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_liquidity_pool(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
        }

        response = await self.liquidity_pool(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_liquidity_pool_by_pool_coin_denom(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_coin_denom": request.pool_coin_denom,
        }

        response = await self.liquidity_pool_by_pool_coin_denom(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_liquidity_pool_by_reserve_acc(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "reserve_acc": request.reserve_acc,
        }

        response = await self.liquidity_pool_by_reserve_acc(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_liquidity_pool_batch(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
        }

        response = await self.liquidity_pool_batch(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pool_batch_swap_msgs(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
            "pagination": request.pagination,
        }

        response = await self.pool_batch_swap_msgs(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pool_batch_swap_msg(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
            "msg_index": request.msg_index,
        }

        response = await self.pool_batch_swap_msg(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pool_batch_deposit_msgs(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
            "pagination": request.pagination,
        }

        response = await self.pool_batch_deposit_msgs(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pool_batch_deposit_msg(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
            "msg_index": request.msg_index,
        }

        response = await self.pool_batch_deposit_msg(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pool_batch_withdraw_msgs(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
            "pagination": request.pagination,
        }

        response = await self.pool_batch_withdraw_msgs(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pool_batch_withdraw_msg(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pool_id": request.pool_id,
            "msg_index": request.msg_index,
        }

        response = await self.pool_batch_withdraw_msg(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_params(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.params(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/tendermint.liquidity.v1beta1.Query/LiquidityPools": grpclib.const.Handler(
                self.__rpc_liquidity_pools,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryLiquidityPoolsRequest,
                QueryLiquidityPoolsResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/LiquidityPool": grpclib.const.Handler(
                self.__rpc_liquidity_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryLiquidityPoolRequest,
                QueryLiquidityPoolResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/LiquidityPoolByPoolCoinDenom": grpclib.const.Handler(
                self.__rpc_liquidity_pool_by_pool_coin_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryLiquidityPoolByPoolCoinDenomRequest,
                QueryLiquidityPoolResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/LiquidityPoolByReserveAcc": grpclib.const.Handler(
                self.__rpc_liquidity_pool_by_reserve_acc,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryLiquidityPoolByReserveAccRequest,
                QueryLiquidityPoolResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/LiquidityPoolBatch": grpclib.const.Handler(
                self.__rpc_liquidity_pool_batch,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryLiquidityPoolBatchRequest,
                QueryLiquidityPoolBatchResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/PoolBatchSwapMsgs": grpclib.const.Handler(
                self.__rpc_pool_batch_swap_msgs,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolBatchSwapMsgsRequest,
                QueryPoolBatchSwapMsgsResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/PoolBatchSwapMsg": grpclib.const.Handler(
                self.__rpc_pool_batch_swap_msg,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolBatchSwapMsgRequest,
                QueryPoolBatchSwapMsgResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/PoolBatchDepositMsgs": grpclib.const.Handler(
                self.__rpc_pool_batch_deposit_msgs,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolBatchDepositMsgsRequest,
                QueryPoolBatchDepositMsgsResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/PoolBatchDepositMsg": grpclib.const.Handler(
                self.__rpc_pool_batch_deposit_msg,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolBatchDepositMsgRequest,
                QueryPoolBatchDepositMsgResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/PoolBatchWithdrawMsgs": grpclib.const.Handler(
                self.__rpc_pool_batch_withdraw_msgs,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolBatchWithdrawMsgsRequest,
                QueryPoolBatchWithdrawMsgsResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/PoolBatchWithdrawMsg": grpclib.const.Handler(
                self.__rpc_pool_batch_withdraw_msg,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolBatchWithdrawMsgRequest,
                QueryPoolBatchWithdrawMsgResponse,
            ),
            "/tendermint.liquidity.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
        }


from ....cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__
from ....cosmos.base.query import v1beta1 as ___cosmos_base_query_v1_beta1__
