# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: ibc/core/channel/v1/channel.proto, ibc/core/channel/v1/genesis.proto, ibc/core/channel/v1/query.proto, ibc/core/channel/v1/tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class State(betterproto.Enum):
    """
    State defines if a channel is in one of the following states: CLOSED, INIT,
    TRYOPEN, OPEN or UNINITIALIZED.
    """

    # Default State
    STATE_UNINITIALIZED_UNSPECIFIED = 0
    # A channel has just started the opening handshake.
    STATE_INIT = 1
    # A channel has acknowledged the handshake step on the counterparty chain.
    STATE_TRYOPEN = 2
    # A channel has completed the handshake. Open channels are ready to send and
    # receive packets.
    STATE_OPEN = 3
    # A channel has been closed and can no longer be used to send or receive
    # packets.
    STATE_CLOSED = 4


class Order(betterproto.Enum):
    """Order defines if a channel is ORDERED or UNORDERED"""

    # zero-value for channel ordering
    ORDER_NONE_UNSPECIFIED = 0
    # packets can be delivered in any order, which may differ from the order in
    # which they were sent.
    ORDER_UNORDERED = 1
    # packets are delivered exactly in the order which they were sent
    ORDER_ORDERED = 2


@dataclass(eq=False, repr=False)
class Channel(betterproto.Message):
    """
    Channel defines pipeline for exactly-once packet delivery between specific
    modules on separate blockchains, which has at least one end capable of
    sending packets and one end capable of receiving packets.
    """

    # current state of the channel end
    state: "State" = betterproto.enum_field(1)
    # whether the channel is ordered or unordered
    ordering: "Order" = betterproto.enum_field(2)
    # counterparty channel end
    counterparty: "Counterparty" = betterproto.message_field(3)
    # list of connection identifiers, in order, along which packets sent on this
    # channel will travel
    connection_hops: List[str] = betterproto.string_field(4)
    # opaque channel version, which is agreed upon during the handshake
    version: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class IdentifiedChannel(betterproto.Message):
    """
    IdentifiedChannel defines a channel with additional port and channel
    identifier fields.
    """

    # current state of the channel end
    state: "State" = betterproto.enum_field(1)
    # whether the channel is ordered or unordered
    ordering: "Order" = betterproto.enum_field(2)
    # counterparty channel end
    counterparty: "Counterparty" = betterproto.message_field(3)
    # list of connection identifiers, in order, along which packets sent on this
    # channel will travel
    connection_hops: List[str] = betterproto.string_field(4)
    # opaque channel version, which is agreed upon during the handshake
    version: str = betterproto.string_field(5)
    # port identifier
    port_id: str = betterproto.string_field(6)
    # channel identifier
    channel_id: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class Counterparty(betterproto.Message):
    """Counterparty defines a channel end counterparty"""

    # port on the counterparty chain which owns the other end of the channel.
    port_id: str = betterproto.string_field(1)
    # channel end on the counterparty chain
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Packet(betterproto.Message):
    """
    Packet defines a type that carries data across different chains through IBC
    """

    # number corresponds to the order of sends and receives, where a Packet with
    # an earlier sequence number must be sent and received before a Packet with a
    # later sequence number.
    sequence: int = betterproto.uint64_field(1)
    # identifies the port on the sending chain.
    source_port: str = betterproto.string_field(2)
    # identifies the channel end on the sending chain.
    source_channel: str = betterproto.string_field(3)
    # identifies the port on the receiving chain.
    destination_port: str = betterproto.string_field(4)
    # identifies the channel end on the receiving chain.
    destination_channel: str = betterproto.string_field(5)
    # actual opaque bytes transferred directly to the application module
    data: bytes = betterproto.bytes_field(6)
    # block height after which the packet times out
    timeout_height: "__client_v1__.Height" = betterproto.message_field(7)
    # block timestamp (in nanoseconds) after which the packet times out
    timeout_timestamp: int = betterproto.uint64_field(8)


@dataclass(eq=False, repr=False)
class PacketState(betterproto.Message):
    """
    PacketState defines the generic type necessary to retrieve and store packet
    commitments, acknowledgements, and receipts. Caller is responsible for
    knowing the context necessary to interpret this state as a commitment,
    acknowledgement, or a receipt.
    """

    # channel port identifier.
    port_id: str = betterproto.string_field(1)
    # channel unique identifier.
    channel_id: str = betterproto.string_field(2)
    # packet sequence.
    sequence: int = betterproto.uint64_field(3)
    # embedded data that represents packet state.
    data: bytes = betterproto.bytes_field(4)


@dataclass(eq=False, repr=False)
class Acknowledgement(betterproto.Message):
    """
    Acknowledgement is the recommended acknowledgement format to be used by
    app-specific protocols. NOTE: The field numbers 21 and 22 were explicitly
    chosen to avoid accidental conflicts with other protobuf message formats
    used for acknowledgements. The first byte of any message with this format
    will be the non-ASCII values `0xaa` (result) or `0xb2` (error). Implemented
    as defined by ICS:
    https://github.com/cosmos/ics/tree/master/spec/ics-004-channel-and-packet-
    semantics#acknowledgement-envelope
    """

    result: bytes = betterproto.bytes_field(21, group="response")
    error: str = betterproto.string_field(22, group="response")


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the ibc channel submodule's genesis state."""

    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    acknowledgements: List["PacketState"] = betterproto.message_field(2)
    commitments: List["PacketState"] = betterproto.message_field(3)
    receipts: List["PacketState"] = betterproto.message_field(4)
    send_sequences: List["PacketSequence"] = betterproto.message_field(5)
    recv_sequences: List["PacketSequence"] = betterproto.message_field(6)
    ack_sequences: List["PacketSequence"] = betterproto.message_field(7)
    # the sequence for the next generated channel identifier
    next_channel_sequence: int = betterproto.uint64_field(8)


@dataclass(eq=False, repr=False)
class PacketSequence(betterproto.Message):
    """
    PacketSequence defines the genesis type necessary to retrieve and store
    next send and receive sequences.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelOpenInit(betterproto.Message):
    """
    MsgChannelOpenInit defines an sdk.Msg to initialize a channel handshake. It
    is called by a relayer on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel: "Channel" = betterproto.message_field(2)
    signer: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelOpenInitResponse(betterproto.Message):
    """
    MsgChannelOpenInitResponse defines the Msg/ChannelOpenInit response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelOpenTry(betterproto.Message):
    """
    MsgChannelOpenInit defines a msg sent by a Relayer to try to open a channel
    on Chain B.
    """

    port_id: str = betterproto.string_field(1)
    # in the case of crossing hello's, when both chains call OpenInit, we need
    # the channel identifier of the previous channel in state INIT
    previous_channel_id: str = betterproto.string_field(2)
    channel: "Channel" = betterproto.message_field(3)
    counterparty_version: str = betterproto.string_field(4)
    proof_init: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgChannelOpenTryResponse(betterproto.Message):
    """
    MsgChannelOpenTryResponse defines the Msg/ChannelOpenTry response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelOpenAck(betterproto.Message):
    """
    MsgChannelOpenAck defines a msg sent by a Relayer to Chain A to acknowledge
    the change of channel state to TRYOPEN on Chain B.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    counterparty_channel_id: str = betterproto.string_field(3)
    counterparty_version: str = betterproto.string_field(4)
    proof_try: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgChannelOpenAckResponse(betterproto.Message):
    """
    MsgChannelOpenAckResponse defines the Msg/ChannelOpenAck response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelOpenConfirm(betterproto.Message):
    """
    MsgChannelOpenConfirm defines a msg sent by a Relayer to Chain B to
    acknowledge the change of channel state to OPEN on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    proof_ack: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgChannelOpenConfirmResponse(betterproto.Message):
    """
    MsgChannelOpenConfirmResponse defines the Msg/ChannelOpenConfirm response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelCloseInit(betterproto.Message):
    """
    MsgChannelCloseInit defines a msg sent by a Relayer to Chain A to close a
    channel with Chain B.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    signer: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelCloseInitResponse(betterproto.Message):
    """
    MsgChannelCloseInitResponse defines the Msg/ChannelCloseInit response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelCloseConfirm(betterproto.Message):
    """
    MsgChannelCloseConfirm defines a msg sent by a Relayer to Chain B to
    acknowledge the change of channel state to CLOSED on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    proof_init: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgChannelCloseConfirmResponse(betterproto.Message):
    """
    MsgChannelCloseConfirmResponse defines the Msg/ChannelCloseConfirm response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgRecvPacket(betterproto.Message):
    """MsgRecvPacket receives incoming IBC packet"""

    packet: "Packet" = betterproto.message_field(1)
    proof_commitment: bytes = betterproto.bytes_field(2)
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    signer: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgRecvPacketResponse(betterproto.Message):
    """MsgRecvPacketResponse defines the Msg/RecvPacket response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgTimeout(betterproto.Message):
    """MsgTimeout receives timed-out packet"""

    packet: "Packet" = betterproto.message_field(1)
    proof_unreceived: bytes = betterproto.bytes_field(2)
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    next_sequence_recv: int = betterproto.uint64_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgTimeoutResponse(betterproto.Message):
    """MsgTimeoutResponse defines the Msg/Timeout response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgTimeoutOnClose(betterproto.Message):
    """
    MsgTimeoutOnClose timed-out packet upon counterparty channel closure.
    """

    packet: "Packet" = betterproto.message_field(1)
    proof_unreceived: bytes = betterproto.bytes_field(2)
    proof_close: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    next_sequence_recv: int = betterproto.uint64_field(5)
    signer: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class MsgTimeoutOnCloseResponse(betterproto.Message):
    """
    MsgTimeoutOnCloseResponse defines the Msg/TimeoutOnClose response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgAcknowledgement(betterproto.Message):
    """MsgAcknowledgement receives incoming IBC acknowledgement"""

    packet: "Packet" = betterproto.message_field(1)
    acknowledgement: bytes = betterproto.bytes_field(2)
    proof_acked: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgAcknowledgementResponse(betterproto.Message):
    """
    MsgAcknowledgementResponse defines the Msg/Acknowledgement response type.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryChannelRequest(betterproto.Message):
    """
    QueryChannelRequest is the request type for the Query/Channel RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryChannelResponse(betterproto.Message):
    """
    QueryChannelResponse is the response type for the Query/Channel RPC method.
    Besides the Channel end, it includes a proof and the height from which the
    proof was retrieved.
    """

    # channel associated with the request identifiers
    channel: "Channel" = betterproto.message_field(1)
    # merkle proof of existence
    proof: bytes = betterproto.bytes_field(2)
    # height at which the proof was retrieved
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryChannelsRequest(betterproto.Message):
    """
    QueryChannelsRequest is the request type for the Query/Channels RPC method
    """

    # pagination request
    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )


@dataclass(eq=False, repr=False)
class QueryChannelsResponse(betterproto.Message):
    """
    QueryChannelsResponse is the response type for the Query/Channels RPC
    method.
    """

    # list of stored channels of the chain.
    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    # pagination response
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    # query block height
    height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryConnectionChannelsRequest(betterproto.Message):
    """
    QueryConnectionChannelsRequest is the request type for the
    Query/QueryConnectionChannels RPC method
    """

    # connection unique identifier
    connection: str = betterproto.string_field(1)
    # pagination request
    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryConnectionChannelsResponse(betterproto.Message):
    """
    QueryConnectionChannelsResponse is the Response type for the
    Query/QueryConnectionChannels RPC method
    """

    # list of channels associated with a connection.
    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    # pagination response
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    # query block height
    height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryChannelClientStateRequest(betterproto.Message):
    """
    QueryChannelClientStateRequest is the request type for the
    Query/ClientState RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryChannelClientStateResponse(betterproto.Message):
    """
    QueryChannelClientStateResponse is the Response type for the
    Query/QueryChannelClientState RPC method
    """

    # client state associated with the channel
    identified_client_state: "__client_v1__.IdentifiedClientState" = (
        betterproto.message_field(1)
    )
    # merkle proof of existence
    proof: bytes = betterproto.bytes_field(2)
    # height at which the proof was retrieved
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryChannelConsensusStateRequest(betterproto.Message):
    """
    QueryChannelConsensusStateRequest is the request type for the
    Query/ConsensusState RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # revision number of the consensus state
    revision_number: int = betterproto.uint64_field(3)
    # revision height of the consensus state
    revision_height: int = betterproto.uint64_field(4)


@dataclass(eq=False, repr=False)
class QueryChannelConsensusStateResponse(betterproto.Message):
    """
    QueryChannelClientStateResponse is the Response type for the
    Query/QueryChannelClientState RPC method
    """

    # consensus state associated with the channel
    consensus_state: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        1
    )
    # client ID associated with the consensus state
    client_id: str = betterproto.string_field(2)
    # merkle proof of existence
    proof: bytes = betterproto.bytes_field(3)
    # height at which the proof was retrieved
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentRequest(betterproto.Message):
    """
    QueryPacketCommitmentRequest is the request type for the
    Query/PacketCommitment RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # packet sequence
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentResponse(betterproto.Message):
    """
    QueryPacketCommitmentResponse defines the client query response for a
    packet which also includes a proof and the height from which the proof was
    retrieved
    """

    # packet associated with the request fields
    commitment: bytes = betterproto.bytes_field(1)
    # merkle proof of existence
    proof: bytes = betterproto.bytes_field(2)
    # height at which the proof was retrieved
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentsRequest(betterproto.Message):
    """
    QueryPacketCommitmentsRequest is the request type for the
    Query/QueryPacketCommitments RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # pagination request
    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(3)
    )


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentsResponse(betterproto.Message):
    """
    QueryPacketCommitmentsResponse is the request type for the
    Query/QueryPacketCommitments RPC method
    """

    commitments: List["PacketState"] = betterproto.message_field(1)
    # pagination response
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    # query block height
    height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryPacketReceiptRequest(betterproto.Message):
    """
    QueryPacketReceiptRequest is the request type for the Query/PacketReceipt
    RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # packet sequence
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class QueryPacketReceiptResponse(betterproto.Message):
    """
    QueryPacketReceiptResponse defines the client query response for a packet
    receipt which also includes a proof, and the height from which the proof
    was retrieved
    """

    # success flag for if receipt exists
    received: bool = betterproto.bool_field(2)
    # merkle proof of existence
    proof: bytes = betterproto.bytes_field(3)
    # height at which the proof was retrieved
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementRequest(betterproto.Message):
    """
    QueryPacketAcknowledgementRequest is the request type for the
    Query/PacketAcknowledgement RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # packet sequence
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementResponse(betterproto.Message):
    """
    QueryPacketAcknowledgementResponse defines the client query response for a
    packet which also includes a proof and the height from which the proof was
    retrieved
    """

    # packet associated with the request fields
    acknowledgement: bytes = betterproto.bytes_field(1)
    # merkle proof of existence
    proof: bytes = betterproto.bytes_field(2)
    # height at which the proof was retrieved
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementsRequest(betterproto.Message):
    """
    QueryPacketAcknowledgementsRequest is the request type for the
    Query/QueryPacketCommitments RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # pagination request
    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(3)
    )


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementsResponse(betterproto.Message):
    """
    QueryPacketAcknowledgemetsResponse is the request type for the
    Query/QueryPacketAcknowledgements RPC method
    """

    acknowledgements: List["PacketState"] = betterproto.message_field(1)
    # pagination response
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    # query block height
    height: "__client_v1__.Height" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryUnreceivedPacketsRequest(betterproto.Message):
    """
    QueryUnreceivedPacketsRequest is the request type for the
    Query/UnreceivedPackets RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # list of packet sequences
    packet_commitment_sequences: List[int] = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class QueryUnreceivedPacketsResponse(betterproto.Message):
    """
    QueryUnreceivedPacketsResponse is the response type for the
    Query/UnreceivedPacketCommitments RPC method
    """

    # list of unreceived packet sequences
    sequences: List[int] = betterproto.uint64_field(1)
    # query block height
    height: "__client_v1__.Height" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryUnreceivedAcksRequest(betterproto.Message):
    """
    QueryUnreceivedAcks is the request type for the Query/UnreceivedAcks RPC
    method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)
    # list of acknowledgement sequences
    packet_ack_sequences: List[int] = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class QueryUnreceivedAcksResponse(betterproto.Message):
    """
    QueryUnreceivedAcksResponse is the response type for the
    Query/UnreceivedAcks RPC method
    """

    # list of unreceived acknowledgement sequences
    sequences: List[int] = betterproto.uint64_field(1)
    # query block height
    height: "__client_v1__.Height" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryNextSequenceReceiveRequest(betterproto.Message):
    """
    QueryNextSequenceReceiveRequest is the request type for the
    Query/QueryNextSequenceReceiveRequest RPC method
    """

    # port unique identifier
    port_id: str = betterproto.string_field(1)
    # channel unique identifier
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryNextSequenceReceiveResponse(betterproto.Message):
    """
    QuerySequenceResponse is the request type for the
    Query/QueryNextSequenceReceiveResponse RPC method
    """

    # next sequence receive number
    next_sequence_receive: int = betterproto.uint64_field(1)
    # merkle proof of existence
    proof: bytes = betterproto.bytes_field(2)
    # height at which the proof was retrieved
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)


class MsgStub(betterproto.ServiceStub):
    async def channel_open_init(
        self, *, port_id: str = "", channel: "Channel" = None, signer: str = ""
    ) -> "MsgChannelOpenInitResponse":

        request = MsgChannelOpenInit()
        request.port_id = port_id
        if channel is not None:
            request.channel = channel
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenInit",
            request,
            MsgChannelOpenInitResponse,
        )

    async def channel_open_try(
        self,
        *,
        port_id: str = "",
        previous_channel_id: str = "",
        channel: "Channel" = None,
        counterparty_version: str = "",
        proof_init: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        signer: str = ""
    ) -> "MsgChannelOpenTryResponse":

        request = MsgChannelOpenTry()
        request.port_id = port_id
        request.previous_channel_id = previous_channel_id
        if channel is not None:
            request.channel = channel
        request.counterparty_version = counterparty_version
        request.proof_init = proof_init
        if proof_height is not None:
            request.proof_height = proof_height
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenTry",
            request,
            MsgChannelOpenTryResponse,
        )

    async def channel_open_ack(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        counterparty_channel_id: str = "",
        counterparty_version: str = "",
        proof_try: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        signer: str = ""
    ) -> "MsgChannelOpenAckResponse":

        request = MsgChannelOpenAck()
        request.port_id = port_id
        request.channel_id = channel_id
        request.counterparty_channel_id = counterparty_channel_id
        request.counterparty_version = counterparty_version
        request.proof_try = proof_try
        if proof_height is not None:
            request.proof_height = proof_height
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenAck",
            request,
            MsgChannelOpenAckResponse,
        )

    async def channel_open_confirm(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        proof_ack: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        signer: str = ""
    ) -> "MsgChannelOpenConfirmResponse":

        request = MsgChannelOpenConfirm()
        request.port_id = port_id
        request.channel_id = channel_id
        request.proof_ack = proof_ack
        if proof_height is not None:
            request.proof_height = proof_height
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenConfirm",
            request,
            MsgChannelOpenConfirmResponse,
        )

    async def channel_close_init(
        self, *, port_id: str = "", channel_id: str = "", signer: str = ""
    ) -> "MsgChannelCloseInitResponse":

        request = MsgChannelCloseInit()
        request.port_id = port_id
        request.channel_id = channel_id
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelCloseInit",
            request,
            MsgChannelCloseInitResponse,
        )

    async def channel_close_confirm(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        proof_init: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        signer: str = ""
    ) -> "MsgChannelCloseConfirmResponse":

        request = MsgChannelCloseConfirm()
        request.port_id = port_id
        request.channel_id = channel_id
        request.proof_init = proof_init
        if proof_height is not None:
            request.proof_height = proof_height
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelCloseConfirm",
            request,
            MsgChannelCloseConfirmResponse,
        )

    async def recv_packet(
        self,
        *,
        packet: "Packet" = None,
        proof_commitment: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        signer: str = ""
    ) -> "MsgRecvPacketResponse":

        request = MsgRecvPacket()
        if packet is not None:
            request.packet = packet
        request.proof_commitment = proof_commitment
        if proof_height is not None:
            request.proof_height = proof_height
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/RecvPacket", request, MsgRecvPacketResponse
        )

    async def timeout(
        self,
        *,
        packet: "Packet" = None,
        proof_unreceived: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        next_sequence_recv: int = 0,
        signer: str = ""
    ) -> "MsgTimeoutResponse":

        request = MsgTimeout()
        if packet is not None:
            request.packet = packet
        request.proof_unreceived = proof_unreceived
        if proof_height is not None:
            request.proof_height = proof_height
        request.next_sequence_recv = next_sequence_recv
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/Timeout", request, MsgTimeoutResponse
        )

    async def timeout_on_close(
        self,
        *,
        packet: "Packet" = None,
        proof_unreceived: bytes = b"",
        proof_close: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        next_sequence_recv: int = 0,
        signer: str = ""
    ) -> "MsgTimeoutOnCloseResponse":

        request = MsgTimeoutOnClose()
        if packet is not None:
            request.packet = packet
        request.proof_unreceived = proof_unreceived
        request.proof_close = proof_close
        if proof_height is not None:
            request.proof_height = proof_height
        request.next_sequence_recv = next_sequence_recv
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/TimeoutOnClose",
            request,
            MsgTimeoutOnCloseResponse,
        )

    async def acknowledgement(
        self,
        *,
        packet: "Packet" = None,
        acknowledgement: bytes = b"",
        proof_acked: bytes = b"",
        proof_height: "__client_v1__.Height" = None,
        signer: str = ""
    ) -> "MsgAcknowledgementResponse":

        request = MsgAcknowledgement()
        if packet is not None:
            request.packet = packet
        request.acknowledgement = acknowledgement
        request.proof_acked = proof_acked
        if proof_height is not None:
            request.proof_height = proof_height
        request.signer = signer

        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/Acknowledgement",
            request,
            MsgAcknowledgementResponse,
        )


class QueryStub(betterproto.ServiceStub):
    async def channel(
        self, *, port_id: str = "", channel_id: str = ""
    ) -> "QueryChannelResponse":

        request = QueryChannelRequest()
        request.port_id = port_id
        request.channel_id = channel_id

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/Channel", request, QueryChannelResponse
        )

    async def channels(
        self, *, pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryChannelsResponse":

        request = QueryChannelsRequest()
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/Channels", request, QueryChannelsResponse
        )

    async def connection_channels(
        self,
        *,
        connection: str = "",
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryConnectionChannelsResponse":

        request = QueryConnectionChannelsRequest()
        request.connection = connection
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ConnectionChannels",
            request,
            QueryConnectionChannelsResponse,
        )

    async def channel_client_state(
        self, *, port_id: str = "", channel_id: str = ""
    ) -> "QueryChannelClientStateResponse":

        request = QueryChannelClientStateRequest()
        request.port_id = port_id
        request.channel_id = channel_id

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ChannelClientState",
            request,
            QueryChannelClientStateResponse,
        )

    async def channel_consensus_state(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        revision_number: int = 0,
        revision_height: int = 0
    ) -> "QueryChannelConsensusStateResponse":

        request = QueryChannelConsensusStateRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        request.revision_number = revision_number
        request.revision_height = revision_height

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ChannelConsensusState",
            request,
            QueryChannelConsensusStateResponse,
        )

    async def packet_commitment(
        self, *, port_id: str = "", channel_id: str = "", sequence: int = 0
    ) -> "QueryPacketCommitmentResponse":

        request = QueryPacketCommitmentRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        request.sequence = sequence

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketCommitment",
            request,
            QueryPacketCommitmentResponse,
        )

    async def packet_commitments(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryPacketCommitmentsResponse":

        request = QueryPacketCommitmentsRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketCommitments",
            request,
            QueryPacketCommitmentsResponse,
        )

    async def packet_receipt(
        self, *, port_id: str = "", channel_id: str = "", sequence: int = 0
    ) -> "QueryPacketReceiptResponse":

        request = QueryPacketReceiptRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        request.sequence = sequence

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketReceipt",
            request,
            QueryPacketReceiptResponse,
        )

    async def packet_acknowledgement(
        self, *, port_id: str = "", channel_id: str = "", sequence: int = 0
    ) -> "QueryPacketAcknowledgementResponse":

        request = QueryPacketAcknowledgementRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        request.sequence = sequence

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketAcknowledgement",
            request,
            QueryPacketAcknowledgementResponse,
        )

    async def packet_acknowledgements(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryPacketAcknowledgementsResponse":

        request = QueryPacketAcknowledgementsRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketAcknowledgements",
            request,
            QueryPacketAcknowledgementsResponse,
        )

    async def unreceived_packets(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        packet_commitment_sequences: Optional[List[int]] = None
    ) -> "QueryUnreceivedPacketsResponse":
        packet_commitment_sequences = packet_commitment_sequences or []

        request = QueryUnreceivedPacketsRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        request.packet_commitment_sequences = packet_commitment_sequences

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/UnreceivedPackets",
            request,
            QueryUnreceivedPacketsResponse,
        )

    async def unreceived_acks(
        self,
        *,
        port_id: str = "",
        channel_id: str = "",
        packet_ack_sequences: Optional[List[int]] = None
    ) -> "QueryUnreceivedAcksResponse":
        packet_ack_sequences = packet_ack_sequences or []

        request = QueryUnreceivedAcksRequest()
        request.port_id = port_id
        request.channel_id = channel_id
        request.packet_ack_sequences = packet_ack_sequences

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/UnreceivedAcks",
            request,
            QueryUnreceivedAcksResponse,
        )

    async def next_sequence_receive(
        self, *, port_id: str = "", channel_id: str = ""
    ) -> "QueryNextSequenceReceiveResponse":

        request = QueryNextSequenceReceiveRequest()
        request.port_id = port_id
        request.channel_id = channel_id

        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/NextSequenceReceive",
            request,
            QueryNextSequenceReceiveResponse,
        )


class MsgBase(ServiceBase):
    async def channel_open_init(
        self, port_id: str, channel: "Channel", signer: str
    ) -> "MsgChannelOpenInitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_try(
        self,
        port_id: str,
        previous_channel_id: str,
        channel: "Channel",
        counterparty_version: str,
        proof_init: bytes,
        proof_height: "__client_v1__.Height",
        signer: str,
    ) -> "MsgChannelOpenTryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_ack(
        self,
        port_id: str,
        channel_id: str,
        counterparty_channel_id: str,
        counterparty_version: str,
        proof_try: bytes,
        proof_height: "__client_v1__.Height",
        signer: str,
    ) -> "MsgChannelOpenAckResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_confirm(
        self,
        port_id: str,
        channel_id: str,
        proof_ack: bytes,
        proof_height: "__client_v1__.Height",
        signer: str,
    ) -> "MsgChannelOpenConfirmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_close_init(
        self, port_id: str, channel_id: str, signer: str
    ) -> "MsgChannelCloseInitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_close_confirm(
        self,
        port_id: str,
        channel_id: str,
        proof_init: bytes,
        proof_height: "__client_v1__.Height",
        signer: str,
    ) -> "MsgChannelCloseConfirmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def recv_packet(
        self,
        packet: "Packet",
        proof_commitment: bytes,
        proof_height: "__client_v1__.Height",
        signer: str,
    ) -> "MsgRecvPacketResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def timeout(
        self,
        packet: "Packet",
        proof_unreceived: bytes,
        proof_height: "__client_v1__.Height",
        next_sequence_recv: int,
        signer: str,
    ) -> "MsgTimeoutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def timeout_on_close(
        self,
        packet: "Packet",
        proof_unreceived: bytes,
        proof_close: bytes,
        proof_height: "__client_v1__.Height",
        next_sequence_recv: int,
        signer: str,
    ) -> "MsgTimeoutOnCloseResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def acknowledgement(
        self,
        packet: "Packet",
        acknowledgement: bytes,
        proof_acked: bytes,
        proof_height: "__client_v1__.Height",
        signer: str,
    ) -> "MsgAcknowledgementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_channel_open_init(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel": request.channel,
            "signer": request.signer,
        }

        response = await self.channel_open_init(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channel_open_try(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "previous_channel_id": request.previous_channel_id,
            "channel": request.channel,
            "counterparty_version": request.counterparty_version,
            "proof_init": request.proof_init,
            "proof_height": request.proof_height,
            "signer": request.signer,
        }

        response = await self.channel_open_try(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channel_open_ack(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "counterparty_channel_id": request.counterparty_channel_id,
            "counterparty_version": request.counterparty_version,
            "proof_try": request.proof_try,
            "proof_height": request.proof_height,
            "signer": request.signer,
        }

        response = await self.channel_open_ack(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channel_open_confirm(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "proof_ack": request.proof_ack,
            "proof_height": request.proof_height,
            "signer": request.signer,
        }

        response = await self.channel_open_confirm(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channel_close_init(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "signer": request.signer,
        }

        response = await self.channel_close_init(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channel_close_confirm(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "proof_init": request.proof_init,
            "proof_height": request.proof_height,
            "signer": request.signer,
        }

        response = await self.channel_close_confirm(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_recv_packet(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet": request.packet,
            "proof_commitment": request.proof_commitment,
            "proof_height": request.proof_height,
            "signer": request.signer,
        }

        response = await self.recv_packet(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_timeout(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet": request.packet,
            "proof_unreceived": request.proof_unreceived,
            "proof_height": request.proof_height,
            "next_sequence_recv": request.next_sequence_recv,
            "signer": request.signer,
        }

        response = await self.timeout(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_timeout_on_close(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet": request.packet,
            "proof_unreceived": request.proof_unreceived,
            "proof_close": request.proof_close,
            "proof_height": request.proof_height,
            "next_sequence_recv": request.next_sequence_recv,
            "signer": request.signer,
        }

        response = await self.timeout_on_close(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_acknowledgement(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet": request.packet,
            "acknowledgement": request.acknowledgement,
            "proof_acked": request.proof_acked,
            "proof_height": request.proof_height,
            "signer": request.signer,
        }

        response = await self.acknowledgement(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.core.channel.v1.Msg/ChannelOpenInit": grpclib.const.Handler(
                self.__rpc_channel_open_init,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenInit,
                MsgChannelOpenInitResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenTry": grpclib.const.Handler(
                self.__rpc_channel_open_try,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenTry,
                MsgChannelOpenTryResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenAck": grpclib.const.Handler(
                self.__rpc_channel_open_ack,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenAck,
                MsgChannelOpenAckResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenConfirm": grpclib.const.Handler(
                self.__rpc_channel_open_confirm,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenConfirm,
                MsgChannelOpenConfirmResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelCloseInit": grpclib.const.Handler(
                self.__rpc_channel_close_init,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelCloseInit,
                MsgChannelCloseInitResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelCloseConfirm": grpclib.const.Handler(
                self.__rpc_channel_close_confirm,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelCloseConfirm,
                MsgChannelCloseConfirmResponse,
            ),
            "/ibc.core.channel.v1.Msg/RecvPacket": grpclib.const.Handler(
                self.__rpc_recv_packet,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgRecvPacket,
                MsgRecvPacketResponse,
            ),
            "/ibc.core.channel.v1.Msg/Timeout": grpclib.const.Handler(
                self.__rpc_timeout,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgTimeout,
                MsgTimeoutResponse,
            ),
            "/ibc.core.channel.v1.Msg/TimeoutOnClose": grpclib.const.Handler(
                self.__rpc_timeout_on_close,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgTimeoutOnClose,
                MsgTimeoutOnCloseResponse,
            ),
            "/ibc.core.channel.v1.Msg/Acknowledgement": grpclib.const.Handler(
                self.__rpc_acknowledgement,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgAcknowledgement,
                MsgAcknowledgementResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def channel(self, port_id: str, channel_id: str) -> "QueryChannelResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channels(
        self, pagination: "____cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryChannelsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def connection_channels(
        self,
        connection: str,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest",
    ) -> "QueryConnectionChannelsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_client_state(
        self, port_id: str, channel_id: str
    ) -> "QueryChannelClientStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_consensus_state(
        self, port_id: str, channel_id: str, revision_number: int, revision_height: int
    ) -> "QueryChannelConsensusStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_commitment(
        self, port_id: str, channel_id: str, sequence: int
    ) -> "QueryPacketCommitmentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_commitments(
        self,
        port_id: str,
        channel_id: str,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest",
    ) -> "QueryPacketCommitmentsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_receipt(
        self, port_id: str, channel_id: str, sequence: int
    ) -> "QueryPacketReceiptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_acknowledgement(
        self, port_id: str, channel_id: str, sequence: int
    ) -> "QueryPacketAcknowledgementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_acknowledgements(
        self,
        port_id: str,
        channel_id: str,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest",
    ) -> "QueryPacketAcknowledgementsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unreceived_packets(
        self,
        port_id: str,
        channel_id: str,
        packet_commitment_sequences: Optional[List[int]],
    ) -> "QueryUnreceivedPacketsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unreceived_acks(
        self, port_id: str, channel_id: str, packet_ack_sequences: Optional[List[int]]
    ) -> "QueryUnreceivedAcksResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def next_sequence_receive(
        self, port_id: str, channel_id: str
    ) -> "QueryNextSequenceReceiveResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_channel(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
        }

        response = await self.channel(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channels(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
        }

        response = await self.channels(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_connection_channels(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "connection": request.connection,
            "pagination": request.pagination,
        }

        response = await self.connection_channels(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channel_client_state(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
        }

        response = await self.channel_client_state(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_channel_consensus_state(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "revision_number": request.revision_number,
            "revision_height": request.revision_height,
        }

        response = await self.channel_consensus_state(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_packet_commitment(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "sequence": request.sequence,
        }

        response = await self.packet_commitment(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_packet_commitments(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "pagination": request.pagination,
        }

        response = await self.packet_commitments(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_packet_receipt(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "sequence": request.sequence,
        }

        response = await self.packet_receipt(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_packet_acknowledgement(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "sequence": request.sequence,
        }

        response = await self.packet_acknowledgement(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_packet_acknowledgements(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "pagination": request.pagination,
        }

        response = await self.packet_acknowledgements(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_unreceived_packets(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "packet_commitment_sequences": request.packet_commitment_sequences,
        }

        response = await self.unreceived_packets(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_unreceived_acks(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "packet_ack_sequences": request.packet_ack_sequences,
        }

        response = await self.unreceived_acks(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_next_sequence_receive(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
        }

        response = await self.next_sequence_receive(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.core.channel.v1.Query/Channel": grpclib.const.Handler(
                self.__rpc_channel,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelRequest,
                QueryChannelResponse,
            ),
            "/ibc.core.channel.v1.Query/Channels": grpclib.const.Handler(
                self.__rpc_channels,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelsRequest,
                QueryChannelsResponse,
            ),
            "/ibc.core.channel.v1.Query/ConnectionChannels": grpclib.const.Handler(
                self.__rpc_connection_channels,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryConnectionChannelsRequest,
                QueryConnectionChannelsResponse,
            ),
            "/ibc.core.channel.v1.Query/ChannelClientState": grpclib.const.Handler(
                self.__rpc_channel_client_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelClientStateRequest,
                QueryChannelClientStateResponse,
            ),
            "/ibc.core.channel.v1.Query/ChannelConsensusState": grpclib.const.Handler(
                self.__rpc_channel_consensus_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelConsensusStateRequest,
                QueryChannelConsensusStateResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketCommitment": grpclib.const.Handler(
                self.__rpc_packet_commitment,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketCommitmentRequest,
                QueryPacketCommitmentResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketCommitments": grpclib.const.Handler(
                self.__rpc_packet_commitments,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketCommitmentsRequest,
                QueryPacketCommitmentsResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketReceipt": grpclib.const.Handler(
                self.__rpc_packet_receipt,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketReceiptRequest,
                QueryPacketReceiptResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketAcknowledgement": grpclib.const.Handler(
                self.__rpc_packet_acknowledgement,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketAcknowledgementRequest,
                QueryPacketAcknowledgementResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketAcknowledgements": grpclib.const.Handler(
                self.__rpc_packet_acknowledgements,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketAcknowledgementsRequest,
                QueryPacketAcknowledgementsResponse,
            ),
            "/ibc.core.channel.v1.Query/UnreceivedPackets": grpclib.const.Handler(
                self.__rpc_unreceived_packets,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnreceivedPacketsRequest,
                QueryUnreceivedPacketsResponse,
            ),
            "/ibc.core.channel.v1.Query/UnreceivedAcks": grpclib.const.Handler(
                self.__rpc_unreceived_acks,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnreceivedAcksRequest,
                QueryUnreceivedAcksResponse,
            ),
            "/ibc.core.channel.v1.Query/NextSequenceReceive": grpclib.const.Handler(
                self.__rpc_next_sequence_receive,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryNextSequenceReceiveRequest,
                QueryNextSequenceReceiveResponse,
            ),
        }


from .....cosmos.base.query import v1beta1 as ____cosmos_base_query_v1_beta1__
from ...client import v1 as __client_v1__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
