# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/tx/signing/v1beta1/signing.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


class SignMode(betterproto.Enum):
    """SignMode represents a signing mode with its own security guarantees."""

    # SIGN_MODE_UNSPECIFIED specifies an unknown signing mode and will be
    # rejected
    SIGN_MODE_UNSPECIFIED = 0
    # SIGN_MODE_DIRECT specifies a signing mode which uses SignDoc and is
    # verified with raw bytes from Tx
    SIGN_MODE_DIRECT = 1
    # SIGN_MODE_TEXTUAL is a future signing mode that will verify some human-
    # readable textual representation on top of the binary representation from
    # SIGN_MODE_DIRECT
    SIGN_MODE_TEXTUAL = 2
    # SIGN_MODE_LEGACY_AMINO_JSON is a backwards compatibility mode which uses
    # Amino JSON and will be removed in the future
    SIGN_MODE_LEGACY_AMINO_JSON = 127


@dataclass(eq=False, repr=False)
class SignatureDescriptors(betterproto.Message):
    """SignatureDescriptors wraps multiple SignatureDescriptor's."""

    # signatures are the signature descriptors
    signatures: List["SignatureDescriptor"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SignatureDescriptor(betterproto.Message):
    """
    SignatureDescriptor is a convenience type which represents the full data
    for a signature including the public key of the signer, signing modes and
    the signature itself. It is primarily used for coordinating signatures
    between clients.
    """

    # public_key is the public key of the signer
    public_key: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    data: "SignatureDescriptorData" = betterproto.message_field(2)
    # sequence is the sequence of the account, which describes the number of
    # committed transactions signed by a given address. It is used to prevent
    # replay attacks.
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class SignatureDescriptorData(betterproto.Message):
    """Data represents signature data"""

    # single represents a single signer
    single: "SignatureDescriptorDataSingle" = betterproto.message_field(1, group="sum")
    # multi represents a multisig signer
    multi: "SignatureDescriptorDataMulti" = betterproto.message_field(2, group="sum")


@dataclass(eq=False, repr=False)
class SignatureDescriptorDataSingle(betterproto.Message):
    """Single is the signature data for a single signer"""

    # mode is the signing mode of the single signer
    mode: "SignMode" = betterproto.enum_field(1)
    # signature is the raw signature bytes
    signature: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class SignatureDescriptorDataMulti(betterproto.Message):
    """Multi is the signature data for a multisig public key"""

    # bitarray specifies which keys within the multisig are signing
    bitarray: "___crypto_multisig_v1_beta1__.CompactBitArray" = (
        betterproto.message_field(1)
    )
    # signatures is the signatures of the multi-signature
    signatures: List["SignatureDescriptorData"] = betterproto.message_field(2)


from ....crypto.multisig import v1beta1 as ___crypto_multisig_v1_beta1__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
