# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/staking/v1beta1/authz.proto, cosmos/staking/v1beta1/genesis.proto, cosmos/staking/v1beta1/query.proto, cosmos/staking/v1beta1/staking.proto, cosmos/staking/v1beta1/tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime, timedelta
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class BondStatus(betterproto.Enum):
    """BondStatus is the status of a validator."""

    # UNSPECIFIED defines an invalid validator status.
    BOND_STATUS_UNSPECIFIED = 0
    # UNBONDED defines a validator that is not bonded.
    BOND_STATUS_UNBONDED = 1
    # UNBONDING defines a validator that is unbonding.
    BOND_STATUS_UNBONDING = 2
    # BONDED defines a validator that is bonded.
    BOND_STATUS_BONDED = 3


class AuthorizationType(betterproto.Enum):
    """
    AuthorizationType defines the type of staking module authorization type
    """

    # AUTHORIZATION_TYPE_UNSPECIFIED specifies an unknown authorization type
    AUTHORIZATION_TYPE_UNSPECIFIED = 0
    # AUTHORIZATION_TYPE_DELEGATE defines an authorization type for Msg/Delegate
    AUTHORIZATION_TYPE_DELEGATE = 1
    # AUTHORIZATION_TYPE_UNDELEGATE defines an authorization type for
    # Msg/Undelegate
    AUTHORIZATION_TYPE_UNDELEGATE = 2
    # AUTHORIZATION_TYPE_REDELEGATE defines an authorization type for
    # Msg/BeginRedelegate
    AUTHORIZATION_TYPE_REDELEGATE = 3


@dataclass(eq=False, repr=False)
class HistoricalInfo(betterproto.Message):
    """
    HistoricalInfo contains header and validator information for a given block.
    It is stored as part of staking module's state, which persists the `n` most
    recent HistoricalInfo (`n` is set by the staking module's
    `historical_entries` parameter).
    """

    header: "___tendermint_types__.Header" = betterproto.message_field(1)
    valset: List["Validator"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CommissionRates(betterproto.Message):
    """
    CommissionRates defines the initial commission rates to be used for
    creating a validator.
    """

    # rate is the commission rate charged to delegators, as a fraction.
    rate: str = betterproto.string_field(1)
    # max_rate defines the maximum commission rate which validator can ever
    # charge, as a fraction.
    max_rate: str = betterproto.string_field(2)
    # max_change_rate defines the maximum daily increase of the validator
    # commission, as a fraction.
    max_change_rate: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class Commission(betterproto.Message):
    """Commission defines commission parameters for a given validator."""

    # commission_rates defines the initial commission rates to be used for
    # creating a validator.
    commission_rates: "CommissionRates" = betterproto.message_field(1)
    # update_time is the last time the commission rate was changed.
    update_time: datetime = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Description(betterproto.Message):
    """Description defines a validator description."""

    # moniker defines a human-readable name for the validator.
    moniker: str = betterproto.string_field(1)
    # identity defines an optional identity signature (ex. UPort or Keybase).
    identity: str = betterproto.string_field(2)
    # website defines an optional website link.
    website: str = betterproto.string_field(3)
    # security_contact defines an optional email for security contact.
    security_contact: str = betterproto.string_field(4)
    # details define other optional details.
    details: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class Validator(betterproto.Message):
    """
    Validator defines a validator, together with the total amount of the
    Validator's bond shares and their exchange rate to coins. Slashing results
    in a decrease in the exchange rate, allowing correct calculation of future
    undelegations without iterating over delegators. When coins are delegated
    to this validator, the validator is credited with a delegation whose number
    of bond shares is based on the amount of coins delegated divided by the
    current exchange rate. Voting power can be calculated as total bonded
    shares multiplied by exchange rate.
    """

    # operator_address defines the address of the validator's operator; bech
    # encoded in JSON.
    operator_address: str = betterproto.string_field(1)
    # consensus_pubkey is the consensus public key of the validator, as a
    # Protobuf Any.
    consensus_pubkey: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        2
    )
    # jailed defined whether the validator has been jailed from bonded status or
    # not.
    jailed: bool = betterproto.bool_field(3)
    # status is the validator status (bonded/unbonding/unbonded).
    status: "BondStatus" = betterproto.enum_field(4)
    # tokens define the delegated tokens (incl. self-delegation).
    tokens: str = betterproto.string_field(5)
    # delegator_shares defines total shares issued to a validator's delegators.
    delegator_shares: str = betterproto.string_field(6)
    # description defines the description terms for the validator.
    description: "Description" = betterproto.message_field(7)
    # unbonding_height defines, if unbonding, the height at which this validator
    # has begun unbonding.
    unbonding_height: int = betterproto.int64_field(8)
    # unbonding_time defines, if unbonding, the min time for the validator to
    # complete unbonding.
    unbonding_time: datetime = betterproto.message_field(9)
    # commission defines the commission parameters.
    commission: "Commission" = betterproto.message_field(10)
    # min_self_delegation is the validator's self declared minimum self
    # delegation.
    min_self_delegation: str = betterproto.string_field(11)


@dataclass(eq=False, repr=False)
class ValAddresses(betterproto.Message):
    """ValAddresses defines a repeated set of validator addresses."""

    addresses: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DvPair(betterproto.Message):
    """
    DVPair is struct that just has a delegator-validator pair with no other
    data. It is intended to be used as a marshalable pointer. For example, a
    DVPair can be used to construct the key to getting an UnbondingDelegation
    from state.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DvPairs(betterproto.Message):
    """DVPairs defines an array of DVPair objects."""

    pairs: List["DvPair"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DvvTriplet(betterproto.Message):
    """
    DVVTriplet is struct that just has a delegator-validator-validator triplet
    with no other data. It is intended to be used as a marshalable pointer. For
    example, a DVVTriplet can be used to construct the key to getting a
    Redelegation from state.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_src_address: str = betterproto.string_field(2)
    validator_dst_address: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class DvvTriplets(betterproto.Message):
    """DVVTriplets defines an array of DVVTriplet objects."""

    triplets: List["DvvTriplet"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Delegation(betterproto.Message):
    """
    Delegation represents the bond with tokens held by an account. It is owned
    by one delegator, and is associated with the voting power of one validator.
    """

    # delegator_address is the bech32-encoded address of the delegator.
    delegator_address: str = betterproto.string_field(1)
    # validator_address is the bech32-encoded address of the validator.
    validator_address: str = betterproto.string_field(2)
    # shares define the delegation shares received.
    shares: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class UnbondingDelegation(betterproto.Message):
    """
    UnbondingDelegation stores all of a single delegator's unbonding bonds for
    a single validator in an time-ordered list.
    """

    # delegator_address is the bech32-encoded address of the delegator.
    delegator_address: str = betterproto.string_field(1)
    # validator_address is the bech32-encoded address of the validator.
    validator_address: str = betterproto.string_field(2)
    # entries are the unbonding delegation entries.
    entries: List["UnbondingDelegationEntry"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class UnbondingDelegationEntry(betterproto.Message):
    """
    UnbondingDelegationEntry defines an unbonding object with relevant
    metadata.
    """

    # creation_height is the height which the unbonding took place.
    creation_height: int = betterproto.int64_field(1)
    # completion_time is the unix time for unbonding completion.
    completion_time: datetime = betterproto.message_field(2)
    # initial_balance defines the tokens initially scheduled to receive at
    # completion.
    initial_balance: str = betterproto.string_field(3)
    # balance defines the tokens to receive at completion.
    balance: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class RedelegationEntry(betterproto.Message):
    """
    RedelegationEntry defines a redelegation object with relevant metadata.
    """

    # creation_height  defines the height which the redelegation took place.
    creation_height: int = betterproto.int64_field(1)
    # completion_time defines the unix time for redelegation completion.
    completion_time: datetime = betterproto.message_field(2)
    # initial_balance defines the initial balance when redelegation started.
    initial_balance: str = betterproto.string_field(3)
    # shares_dst is the amount of destination-validator shares created by
    # redelegation.
    shares_dst: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class Redelegation(betterproto.Message):
    """
    Redelegation contains the list of a particular delegator's redelegating
    bonds from a particular source validator to a particular destination
    validator.
    """

    # delegator_address is the bech32-encoded address of the delegator.
    delegator_address: str = betterproto.string_field(1)
    # validator_src_address is the validator redelegation source operator
    # address.
    validator_src_address: str = betterproto.string_field(2)
    # validator_dst_address is the validator redelegation destination operator
    # address.
    validator_dst_address: str = betterproto.string_field(3)
    # entries are the redelegation entries.
    entries: List["RedelegationEntry"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the parameters for the staking module."""

    # unbonding_time is the time duration of unbonding.
    unbonding_time: timedelta = betterproto.message_field(1)
    # max_validators is the maximum number of validators.
    max_validators: int = betterproto.uint32_field(2)
    # max_entries is the max entries for either unbonding delegation or
    # redelegation (per pair/trio).
    max_entries: int = betterproto.uint32_field(3)
    # historical_entries is the number of historical entries to persist.
    historical_entries: int = betterproto.uint32_field(4)
    # bond_denom defines the bondable coin denomination.
    bond_denom: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class DelegationResponse(betterproto.Message):
    """
    DelegationResponse is equivalent to Delegation except that it contains a
    balance in addition to shares which is more suitable for client responses.
    """

    delegation: "Delegation" = betterproto.message_field(1)
    balance: "__base_v1_beta1__.Coin" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class RedelegationEntryResponse(betterproto.Message):
    """
    RedelegationEntryResponse is equivalent to a RedelegationEntry except that
    it contains a balance in addition to shares which is more suitable for
    client responses.
    """

    redelegation_entry: "RedelegationEntry" = betterproto.message_field(1)
    balance: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class RedelegationResponse(betterproto.Message):
    """
    RedelegationResponse is equivalent to a Redelegation except that its
    entries contain a balance in addition to shares which is more suitable for
    client responses.
    """

    redelegation: "Redelegation" = betterproto.message_field(1)
    entries: List["RedelegationEntryResponse"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Pool(betterproto.Message):
    """
    Pool is used for tracking bonded and not-bonded token supply of the bond
    denomination.
    """

    not_bonded_tokens: str = betterproto.string_field(1)
    bonded_tokens: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgCreateValidator(betterproto.Message):
    """
    MsgCreateValidator defines a SDK message for creating a new validator.
    """

    description: "Description" = betterproto.message_field(1)
    commission: "CommissionRates" = betterproto.message_field(2)
    min_self_delegation: str = betterproto.string_field(3)
    delegator_address: str = betterproto.string_field(4)
    validator_address: str = betterproto.string_field(5)
    pubkey: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(6)
    value: "__base_v1_beta1__.Coin" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class MsgCreateValidatorResponse(betterproto.Message):
    """
    MsgCreateValidatorResponse defines the Msg/CreateValidator response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgEditValidator(betterproto.Message):
    """
    MsgEditValidator defines a SDK message for editing an existing validator.
    """

    description: "Description" = betterproto.message_field(1)
    validator_address: str = betterproto.string_field(2)
    # We pass a reference to the new commission rate and min self delegation as
    # it's not mandatory to update. If not updated, the deserialized rate will be
    # zero with no way to distinguish if an update was intended. REF: #2373
    commission_rate: str = betterproto.string_field(3)
    min_self_delegation: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgEditValidatorResponse(betterproto.Message):
    """
    MsgEditValidatorResponse defines the Msg/EditValidator response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgDelegate(betterproto.Message):
    """
    MsgDelegate defines a SDK message for performing a delegation of coins from
    a delegator to a validator.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)
    amount: "__base_v1_beta1__.Coin" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgDelegateResponse(betterproto.Message):
    """MsgDelegateResponse defines the Msg/Delegate response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgBeginRedelegate(betterproto.Message):
    """
    MsgBeginRedelegate defines a SDK message for performing a redelegation of
    coins from a delegator and source validator to a destination validator.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_src_address: str = betterproto.string_field(2)
    validator_dst_address: str = betterproto.string_field(3)
    amount: "__base_v1_beta1__.Coin" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class MsgBeginRedelegateResponse(betterproto.Message):
    """
    MsgBeginRedelegateResponse defines the Msg/BeginRedelegate response type.
    """

    completion_time: datetime = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MsgUndelegate(betterproto.Message):
    """
    MsgUndelegate defines a SDK message for performing an undelegation from a
    delegate and a validator.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)
    amount: "__base_v1_beta1__.Coin" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgUndelegateResponse(betterproto.Message):
    """MsgUndelegateResponse defines the Msg/Undelegate response type."""

    completion_time: datetime = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryValidatorsRequest(betterproto.Message):
    """
    QueryValidatorsRequest is request type for Query/Validators RPC method.
    """

    # status enables to query for validators matching a given status.
    status: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryValidatorsResponse(betterproto.Message):
    """
    QueryValidatorsResponse is response type for the Query/Validators RPC
    method
    """

    # validators contains all the queried validators.
    validators: List["Validator"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryValidatorRequest(betterproto.Message):
    """
    QueryValidatorRequest is response type for the Query/Validator RPC method
    """

    # validator_addr defines the validator address to query for.
    validator_addr: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryValidatorResponse(betterproto.Message):
    """
    QueryValidatorResponse is response type for the Query/Validator RPC method
    """

    # validator defines the the validator info.
    validator: "Validator" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryValidatorDelegationsRequest(betterproto.Message):
    """
    QueryValidatorDelegationsRequest is request type for the
    Query/ValidatorDelegations RPC method
    """

    # validator_addr defines the validator address to query for.
    validator_addr: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryValidatorDelegationsResponse(betterproto.Message):
    """
    QueryValidatorDelegationsResponse is response type for the
    Query/ValidatorDelegations RPC method
    """

    delegation_responses: List["DelegationResponse"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryValidatorUnbondingDelegationsRequest(betterproto.Message):
    """
    QueryValidatorUnbondingDelegationsRequest is required type for the
    Query/ValidatorUnbondingDelegations RPC method
    """

    # validator_addr defines the validator address to query for.
    validator_addr: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryValidatorUnbondingDelegationsResponse(betterproto.Message):
    """
    QueryValidatorUnbondingDelegationsResponse is response type for the
    Query/ValidatorUnbondingDelegations RPC method.
    """

    unbonding_responses: List["UnbondingDelegation"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegationRequest(betterproto.Message):
    """
    QueryDelegationRequest is request type for the Query/Delegation RPC method.
    """

    # delegator_addr defines the delegator address to query for.
    delegator_addr: str = betterproto.string_field(1)
    # validator_addr defines the validator address to query for.
    validator_addr: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegationResponse(betterproto.Message):
    """
    QueryDelegationResponse is response type for the Query/Delegation RPC
    method.
    """

    # delegation_responses defines the delegation info of a delegation.
    delegation_response: "DelegationResponse" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryUnbondingDelegationRequest(betterproto.Message):
    """
    QueryUnbondingDelegationRequest is request type for the
    Query/UnbondingDelegation RPC method.
    """

    # delegator_addr defines the delegator address to query for.
    delegator_addr: str = betterproto.string_field(1)
    # validator_addr defines the validator address to query for.
    validator_addr: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryUnbondingDelegationResponse(betterproto.Message):
    """
    QueryDelegationResponse is response type for the Query/UnbondingDelegation
    RPC method.
    """

    # unbond defines the unbonding information of a delegation.
    unbond: "UnbondingDelegation" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryDelegatorDelegationsRequest(betterproto.Message):
    """
    QueryDelegatorDelegationsRequest is request type for the
    Query/DelegatorDelegations RPC method.
    """

    # delegator_addr defines the delegator address to query for.
    delegator_addr: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegatorDelegationsResponse(betterproto.Message):
    """
    QueryDelegatorDelegationsResponse is response type for the
    Query/DelegatorDelegations RPC method.
    """

    # delegation_responses defines all the delegations' info of a delegator.
    delegation_responses: List["DelegationResponse"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegatorUnbondingDelegationsRequest(betterproto.Message):
    """
    QueryDelegatorUnbondingDelegationsRequest is request type for the
    Query/DelegatorUnbondingDelegations RPC method.
    """

    # delegator_addr defines the delegator address to query for.
    delegator_addr: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegatorUnbondingDelegationsResponse(betterproto.Message):
    """
    QueryUnbondingDelegatorDelegationsResponse is response type for the
    Query/UnbondingDelegatorDelegations RPC method.
    """

    unbonding_responses: List["UnbondingDelegation"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryRedelegationsRequest(betterproto.Message):
    """
    QueryRedelegationsRequest is request type for the Query/Redelegations RPC
    method.
    """

    # delegator_addr defines the delegator address to query for.
    delegator_addr: str = betterproto.string_field(1)
    # src_validator_addr defines the validator address to redelegate from.
    src_validator_addr: str = betterproto.string_field(2)
    # dst_validator_addr defines the validator address to redelegate to.
    dst_validator_addr: str = betterproto.string_field(3)
    # pagination defines an optional pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class QueryRedelegationsResponse(betterproto.Message):
    """
    QueryRedelegationsResponse is response type for the Query/Redelegations RPC
    method.
    """

    redelegation_responses: List["RedelegationResponse"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorsRequest(betterproto.Message):
    """
    QueryDelegatorValidatorsRequest is request type for the
    Query/DelegatorValidators RPC method.
    """

    # delegator_addr defines the delegator address to query for.
    delegator_addr: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorsResponse(betterproto.Message):
    """
    QueryDelegatorValidatorsResponse is response type for the
    Query/DelegatorValidators RPC method.
    """

    # validators defines the the validators' info of a delegator.
    validators: List["Validator"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorRequest(betterproto.Message):
    """
    QueryDelegatorValidatorRequest is request type for the
    Query/DelegatorValidator RPC method.
    """

    # delegator_addr defines the delegator address to query for.
    delegator_addr: str = betterproto.string_field(1)
    # validator_addr defines the validator address to query for.
    validator_addr: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorResponse(betterproto.Message):
    """
    QueryDelegatorValidatorResponse response type for the
    Query/DelegatorValidator RPC method.
    """

    # validator defines the the validator info.
    validator: "Validator" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryHistoricalInfoRequest(betterproto.Message):
    """
    QueryHistoricalInfoRequest is request type for the Query/HistoricalInfo RPC
    method.
    """

    # height defines at which height to query the historical info.
    height: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class QueryHistoricalInfoResponse(betterproto.Message):
    """
    QueryHistoricalInfoResponse is response type for the Query/HistoricalInfo
    RPC method.
    """

    # hist defines the historical info at the given height.
    hist: "HistoricalInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryPoolRequest(betterproto.Message):
    """QueryPoolRequest is request type for the Query/Pool RPC method."""

    pass


@dataclass(eq=False, repr=False)
class QueryPoolResponse(betterproto.Message):
    """QueryPoolResponse is response type for the Query/Pool RPC method."""

    # pool defines the pool info.
    pool: "Pool" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """QueryParamsRequest is request type for the Query/Params RPC method."""

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is response type for the Query/Params RPC method.
    """

    # params holds all the parameters of this module.
    params: "Params" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class StakeAuthorization(betterproto.Message):
    """
    StakeAuthorization defines authorization for
    delegate/undelegate/redelegate.
    """

    # max_tokens specifies the maximum amount of tokens can be delegate to a
    # validator. If it is empty, there is no spend limit and any amount of coins
    # can be delegated.
    max_tokens: "__base_v1_beta1__.Coin" = betterproto.message_field(1)
    # allow_list specifies list of validator addresses to whom grantee can
    # delegate tokens on behalf of granter's account.
    allow_list: "StakeAuthorizationValidators" = betterproto.message_field(
        2, group="validators"
    )
    # deny_list specifies list of validator addresses to whom grantee can not
    # delegate tokens.
    deny_list: "StakeAuthorizationValidators" = betterproto.message_field(
        3, group="validators"
    )
    # authorization_type defines one of AuthorizationType.
    authorization_type: "AuthorizationType" = betterproto.enum_field(4)


@dataclass(eq=False, repr=False)
class StakeAuthorizationValidators(betterproto.Message):
    """Validators defines list of validator addresses."""

    address: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the staking module's genesis state."""

    # params defines all the paramaters of related to deposit.
    params: "Params" = betterproto.message_field(1)
    # last_total_power tracks the total amounts of bonded tokens recorded during
    # the previous end block.
    last_total_power: bytes = betterproto.bytes_field(2)
    # last_validator_powers is a special index that provides a historical list of
    # the last-block's bonded validators.
    last_validator_powers: List["LastValidatorPower"] = betterproto.message_field(3)
    # delegations defines the validator set at genesis.
    validators: List["Validator"] = betterproto.message_field(4)
    # delegations defines the delegations active at genesis.
    delegations: List["Delegation"] = betterproto.message_field(5)
    # unbonding_delegations defines the unbonding delegations active at genesis.
    unbonding_delegations: List["UnbondingDelegation"] = betterproto.message_field(6)
    # redelegations defines the redelegations active at genesis.
    redelegations: List["Redelegation"] = betterproto.message_field(7)
    exported: bool = betterproto.bool_field(8)


@dataclass(eq=False, repr=False)
class LastValidatorPower(betterproto.Message):
    """LastValidatorPower required for validator set update logic."""

    # address is the address of the validator.
    address: str = betterproto.string_field(1)
    # power defines the power of the validator.
    power: int = betterproto.int64_field(2)


class MsgStub(betterproto.ServiceStub):
    async def create_validator(
        self,
        *,
        description: "Description" = None,
        commission: "CommissionRates" = None,
        min_self_delegation: str = "",
        delegator_address: str = "",
        validator_address: str = "",
        pubkey: "betterproto_lib_google_protobuf.Any" = None,
        value: "__base_v1_beta1__.Coin" = None
    ) -> "MsgCreateValidatorResponse":

        request = MsgCreateValidator()
        if description is not None:
            request.description = description
        if commission is not None:
            request.commission = commission
        request.min_self_delegation = min_self_delegation
        request.delegator_address = delegator_address
        request.validator_address = validator_address
        if pubkey is not None:
            request.pubkey = pubkey
        if value is not None:
            request.value = value

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/CreateValidator",
            request,
            MsgCreateValidatorResponse,
        )

    async def edit_validator(
        self,
        *,
        description: "Description" = None,
        validator_address: str = "",
        commission_rate: str = "",
        min_self_delegation: str = ""
    ) -> "MsgEditValidatorResponse":

        request = MsgEditValidator()
        if description is not None:
            request.description = description
        request.validator_address = validator_address
        request.commission_rate = commission_rate
        request.min_self_delegation = min_self_delegation

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/EditValidator",
            request,
            MsgEditValidatorResponse,
        )

    async def delegate(
        self,
        *,
        delegator_address: str = "",
        validator_address: str = "",
        amount: "__base_v1_beta1__.Coin" = None
    ) -> "MsgDelegateResponse":

        request = MsgDelegate()
        request.delegator_address = delegator_address
        request.validator_address = validator_address
        if amount is not None:
            request.amount = amount

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/Delegate", request, MsgDelegateResponse
        )

    async def begin_redelegate(
        self,
        *,
        delegator_address: str = "",
        validator_src_address: str = "",
        validator_dst_address: str = "",
        amount: "__base_v1_beta1__.Coin" = None
    ) -> "MsgBeginRedelegateResponse":

        request = MsgBeginRedelegate()
        request.delegator_address = delegator_address
        request.validator_src_address = validator_src_address
        request.validator_dst_address = validator_dst_address
        if amount is not None:
            request.amount = amount

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/BeginRedelegate",
            request,
            MsgBeginRedelegateResponse,
        )

    async def undelegate(
        self,
        *,
        delegator_address: str = "",
        validator_address: str = "",
        amount: "__base_v1_beta1__.Coin" = None
    ) -> "MsgUndelegateResponse":

        request = MsgUndelegate()
        request.delegator_address = delegator_address
        request.validator_address = validator_address
        if amount is not None:
            request.amount = amount

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/Undelegate", request, MsgUndelegateResponse
        )


class QueryStub(betterproto.ServiceStub):
    async def validators(
        self,
        *,
        status: str = "",
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryValidatorsResponse":

        request = QueryValidatorsRequest()
        request.status = status
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Validators", request, QueryValidatorsResponse
        )

    async def validator(self, *, validator_addr: str = "") -> "QueryValidatorResponse":

        request = QueryValidatorRequest()
        request.validator_addr = validator_addr

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Validator", request, QueryValidatorResponse
        )

    async def validator_delegations(
        self,
        *,
        validator_addr: str = "",
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryValidatorDelegationsResponse":

        request = QueryValidatorDelegationsRequest()
        request.validator_addr = validator_addr
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/ValidatorDelegations",
            request,
            QueryValidatorDelegationsResponse,
        )

    async def validator_unbonding_delegations(
        self,
        *,
        validator_addr: str = "",
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryValidatorUnbondingDelegationsResponse":

        request = QueryValidatorUnbondingDelegationsRequest()
        request.validator_addr = validator_addr
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/ValidatorUnbondingDelegations",
            request,
            QueryValidatorUnbondingDelegationsResponse,
        )

    async def delegation(
        self, *, delegator_addr: str = "", validator_addr: str = ""
    ) -> "QueryDelegationResponse":

        request = QueryDelegationRequest()
        request.delegator_addr = delegator_addr
        request.validator_addr = validator_addr

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Delegation", request, QueryDelegationResponse
        )

    async def unbonding_delegation(
        self, *, delegator_addr: str = "", validator_addr: str = ""
    ) -> "QueryUnbondingDelegationResponse":

        request = QueryUnbondingDelegationRequest()
        request.delegator_addr = delegator_addr
        request.validator_addr = validator_addr

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/UnbondingDelegation",
            request,
            QueryUnbondingDelegationResponse,
        )

    async def delegator_delegations(
        self,
        *,
        delegator_addr: str = "",
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryDelegatorDelegationsResponse":

        request = QueryDelegatorDelegationsRequest()
        request.delegator_addr = delegator_addr
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorDelegations",
            request,
            QueryDelegatorDelegationsResponse,
        )

    async def delegator_unbonding_delegations(
        self,
        *,
        delegator_addr: str = "",
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryDelegatorUnbondingDelegationsResponse":

        request = QueryDelegatorUnbondingDelegationsRequest()
        request.delegator_addr = delegator_addr
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorUnbondingDelegations",
            request,
            QueryDelegatorUnbondingDelegationsResponse,
        )

    async def redelegations(
        self,
        *,
        delegator_addr: str = "",
        src_validator_addr: str = "",
        dst_validator_addr: str = "",
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryRedelegationsResponse":

        request = QueryRedelegationsRequest()
        request.delegator_addr = delegator_addr
        request.src_validator_addr = src_validator_addr
        request.dst_validator_addr = dst_validator_addr
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Redelegations",
            request,
            QueryRedelegationsResponse,
        )

    async def delegator_validators(
        self,
        *,
        delegator_addr: str = "",
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryDelegatorValidatorsResponse":

        request = QueryDelegatorValidatorsRequest()
        request.delegator_addr = delegator_addr
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorValidators",
            request,
            QueryDelegatorValidatorsResponse,
        )

    async def delegator_validator(
        self, *, delegator_addr: str = "", validator_addr: str = ""
    ) -> "QueryDelegatorValidatorResponse":

        request = QueryDelegatorValidatorRequest()
        request.delegator_addr = delegator_addr
        request.validator_addr = validator_addr

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorValidator",
            request,
            QueryDelegatorValidatorResponse,
        )

    async def historical_info(
        self, *, height: int = 0
    ) -> "QueryHistoricalInfoResponse":

        request = QueryHistoricalInfoRequest()
        request.height = height

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/HistoricalInfo",
            request,
            QueryHistoricalInfoResponse,
        )

    async def pool(self) -> "QueryPoolResponse":

        request = QueryPoolRequest()

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Pool", request, QueryPoolResponse
        )

    async def params(self) -> "QueryParamsResponse":

        request = QueryParamsRequest()

        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Params", request, QueryParamsResponse
        )


class MsgBase(ServiceBase):
    async def create_validator(
        self,
        description: "Description",
        commission: "CommissionRates",
        min_self_delegation: str,
        delegator_address: str,
        validator_address: str,
        pubkey: "betterproto_lib_google_protobuf.Any",
        value: "__base_v1_beta1__.Coin",
    ) -> "MsgCreateValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def edit_validator(
        self,
        description: "Description",
        validator_address: str,
        commission_rate: str,
        min_self_delegation: str,
    ) -> "MsgEditValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegate(
        self,
        delegator_address: str,
        validator_address: str,
        amount: "__base_v1_beta1__.Coin",
    ) -> "MsgDelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def begin_redelegate(
        self,
        delegator_address: str,
        validator_src_address: str,
        validator_dst_address: str,
        amount: "__base_v1_beta1__.Coin",
    ) -> "MsgBeginRedelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def undelegate(
        self,
        delegator_address: str,
        validator_address: str,
        amount: "__base_v1_beta1__.Coin",
    ) -> "MsgUndelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_validator(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "description": request.description,
            "commission": request.commission,
            "min_self_delegation": request.min_self_delegation,
            "delegator_address": request.delegator_address,
            "validator_address": request.validator_address,
            "pubkey": request.pubkey,
            "value": request.value,
        }

        response = await self.create_validator(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_edit_validator(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "description": request.description,
            "validator_address": request.validator_address,
            "commission_rate": request.commission_rate,
            "min_self_delegation": request.min_self_delegation,
        }

        response = await self.edit_validator(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delegate(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_address": request.delegator_address,
            "validator_address": request.validator_address,
            "amount": request.amount,
        }

        response = await self.delegate(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_begin_redelegate(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_address": request.delegator_address,
            "validator_src_address": request.validator_src_address,
            "validator_dst_address": request.validator_dst_address,
            "amount": request.amount,
        }

        response = await self.begin_redelegate(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_undelegate(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_address": request.delegator_address,
            "validator_address": request.validator_address,
            "amount": request.amount,
        }

        response = await self.undelegate(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.staking.v1beta1.Msg/CreateValidator": grpclib.const.Handler(
                self.__rpc_create_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreateValidator,
                MsgCreateValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/EditValidator": grpclib.const.Handler(
                self.__rpc_edit_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgEditValidator,
                MsgEditValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/Delegate": grpclib.const.Handler(
                self.__rpc_delegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgDelegate,
                MsgDelegateResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/BeginRedelegate": grpclib.const.Handler(
                self.__rpc_begin_redelegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgBeginRedelegate,
                MsgBeginRedelegateResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/Undelegate": grpclib.const.Handler(
                self.__rpc_undelegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUndelegate,
                MsgUndelegateResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def validators(
        self, status: str, pagination: "__base_query_v1_beta1__.PageRequest"
    ) -> "QueryValidatorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator(self, validator_addr: str) -> "QueryValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_delegations(
        self, validator_addr: str, pagination: "__base_query_v1_beta1__.PageRequest"
    ) -> "QueryValidatorDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_unbonding_delegations(
        self, validator_addr: str, pagination: "__base_query_v1_beta1__.PageRequest"
    ) -> "QueryValidatorUnbondingDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegation(
        self, delegator_addr: str, validator_addr: str
    ) -> "QueryDelegationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unbonding_delegation(
        self, delegator_addr: str, validator_addr: str
    ) -> "QueryUnbondingDelegationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_delegations(
        self, delegator_addr: str, pagination: "__base_query_v1_beta1__.PageRequest"
    ) -> "QueryDelegatorDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_unbonding_delegations(
        self, delegator_addr: str, pagination: "__base_query_v1_beta1__.PageRequest"
    ) -> "QueryDelegatorUnbondingDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def redelegations(
        self,
        delegator_addr: str,
        src_validator_addr: str,
        dst_validator_addr: str,
        pagination: "__base_query_v1_beta1__.PageRequest",
    ) -> "QueryRedelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_validators(
        self, delegator_addr: str, pagination: "__base_query_v1_beta1__.PageRequest"
    ) -> "QueryDelegatorValidatorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_validator(
        self, delegator_addr: str, validator_addr: str
    ) -> "QueryDelegatorValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def historical_info(self, height: int) -> "QueryHistoricalInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool(self) -> "QueryPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(self) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_validators(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "status": request.status,
            "pagination": request.pagination,
        }

        response = await self.validators(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_validator(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "validator_addr": request.validator_addr,
        }

        response = await self.validator(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_validator_delegations(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "validator_addr": request.validator_addr,
            "pagination": request.pagination,
        }

        response = await self.validator_delegations(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_validator_unbonding_delegations(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "validator_addr": request.validator_addr,
            "pagination": request.pagination,
        }

        response = await self.validator_unbonding_delegations(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delegation(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_addr": request.delegator_addr,
            "validator_addr": request.validator_addr,
        }

        response = await self.delegation(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_unbonding_delegation(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_addr": request.delegator_addr,
            "validator_addr": request.validator_addr,
        }

        response = await self.unbonding_delegation(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delegator_delegations(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_addr": request.delegator_addr,
            "pagination": request.pagination,
        }

        response = await self.delegator_delegations(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delegator_unbonding_delegations(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_addr": request.delegator_addr,
            "pagination": request.pagination,
        }

        response = await self.delegator_unbonding_delegations(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_redelegations(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_addr": request.delegator_addr,
            "src_validator_addr": request.src_validator_addr,
            "dst_validator_addr": request.dst_validator_addr,
            "pagination": request.pagination,
        }

        response = await self.redelegations(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delegator_validators(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_addr": request.delegator_addr,
            "pagination": request.pagination,
        }

        response = await self.delegator_validators(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delegator_validator(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "delegator_addr": request.delegator_addr,
            "validator_addr": request.validator_addr,
        }

        response = await self.delegator_validator(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_historical_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "height": request.height,
        }

        response = await self.historical_info(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pool(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.pool(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_params(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.params(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.staking.v1beta1.Query/Validators": grpclib.const.Handler(
                self.__rpc_validators,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorsRequest,
                QueryValidatorsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Validator": grpclib.const.Handler(
                self.__rpc_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorRequest,
                QueryValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Query/ValidatorDelegations": grpclib.const.Handler(
                self.__rpc_validator_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorDelegationsRequest,
                QueryValidatorDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/ValidatorUnbondingDelegations": grpclib.const.Handler(
                self.__rpc_validator_unbonding_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorUnbondingDelegationsRequest,
                QueryValidatorUnbondingDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Delegation": grpclib.const.Handler(
                self.__rpc_delegation,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegationRequest,
                QueryDelegationResponse,
            ),
            "/cosmos.staking.v1beta1.Query/UnbondingDelegation": grpclib.const.Handler(
                self.__rpc_unbonding_delegation,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnbondingDelegationRequest,
                QueryUnbondingDelegationResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorDelegations": grpclib.const.Handler(
                self.__rpc_delegator_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorDelegationsRequest,
                QueryDelegatorDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorUnbondingDelegations": grpclib.const.Handler(
                self.__rpc_delegator_unbonding_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorUnbondingDelegationsRequest,
                QueryDelegatorUnbondingDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Redelegations": grpclib.const.Handler(
                self.__rpc_redelegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRedelegationsRequest,
                QueryRedelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorValidators": grpclib.const.Handler(
                self.__rpc_delegator_validators,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorValidatorsRequest,
                QueryDelegatorValidatorsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorValidator": grpclib.const.Handler(
                self.__rpc_delegator_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorValidatorRequest,
                QueryDelegatorValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Query/HistoricalInfo": grpclib.const.Handler(
                self.__rpc_historical_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryHistoricalInfoRequest,
                QueryHistoricalInfoResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Pool": grpclib.const.Handler(
                self.__rpc_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolRequest,
                QueryPoolResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
        }


from ....tendermint import types as ___tendermint_types__
from ...base import v1beta1 as __base_v1_beta1__
from ...base.query import v1beta1 as __base_query_v1_beta1__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
