# PoreMS: A Pore Generator for Molecular Simulations

--------------------------------------

[![PyPI Version](https://img.shields.io/badge/PyPI-0.2.0-orange)](https://pypi.org/project/porems/)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://github.com/Ajax23/PoreMS/blob/master/LICENSE)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3984865.svg)](https://doi.org/10.5281/zenodo.3984865)
[![Build Status](https://travis-ci.com/Ajax23/PoreMS.svg?branch=master)](https://travis-ci.com/Ajax23/PoreMS)
[![codecov](https://codecov.io/gh/Ajax23/PoreMS/branch/master/graph/badge.svg)](https://codecov.io/gh/Ajax23/PoreMS)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/Ajax23/PoreMS.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/Ajax23/PoreMS/context:python)

## Documentation

Online documentation is available at [ajax23.github.io/PoreMS](https://ajax23.github.io/PoreMS/).

The docs include an example for generating [molecules](https://ajax23.github.io/PoreMS/molecule.html) and [pores](https://ajax23.github.io/PoreMS/pore.html), and an [API reference](https://ajax23.github.io/PoreMS/api.html). Visit [process](https://ajax23.github.io/PoreMS/process.html) for an overview of the programs operating principle.

An examplary [workflow](https://ajax23.github.io/PoreMS/workflow.html) has been provided for using the PoreMS package to create a pore system and run molecular dynamics simulation using [Gromacs](http://www.gromacs.org/).

## Dependencies

PoreMS supports Python 3.5+.

Installation requires [numpy](https://numpy.org/), [pandas](https://pandas.pydata.org/) and [matplotlib](https://matplotlib.org/).


## Installation

The latest stable release (and older versions) can be installed from PyPI:

    pip install porems

You may instead want to use the development version from Github:

    pip install git+https://github.com/ajax23/porems.git#egg=porems

    pip install git+https://github.com/ajax23/porems.git@develop#egg=porems

Or download the repository and install in the top directory via:

    pip install .


## Testing

To test porems, run the test in the test directory.


## Development

PoreMS development takes place on Github: https://github.com/Ajax23/PoreMS

Please submit any reproducible bugs you encounter to the [issue tracker](https://github.com/Ajax23/PoreMS/issues).


## How to Cite PoreMS

When citing PoreMS please use the following: **Kraus et al., Molecular Simulation, 2020, DOI: TbA**

Additionaly, to assure reproducability of the generated pore systems, please cite the **Zenodo DOI** corresponding to the used PoreMS version. (Current DOI is listed in the badges.)
