# AutoML Framework Documentation

Welcome to the comprehensive documentation for the AutoML Framework! This documentation will help you get started, understand advanced features, and make the most of the framework's capabilities.

## 📚 Documentation Structure

### 🚀 **Getting Started**
- [Installation Guide](installation.md) - Set up the framework
- [Quick Start](quickstart.md) - Get running in 5 minutes
- [User Guide](user-guide.md) - Comprehensive usage guide

### 📖 **Tutorials**
- [Getting Started Tutorial](tutorials/getting_started.md) - Step-by-step introduction
- [Advanced Features](tutorials/advanced_features.md) - Explore powerful capabilities
- [Custom Preprocessing](tutorials/custom_preprocessing.md) - Build custom preprocessors
- [Model Comparison](tutorials/model_comparison.md) - Compare and evaluate models

### 🔧 **API Reference**
- [AutoML Class](API/automl.md) - Main interface documentation
- [Pipeline](API/pipeline.md) - Core pipeline functionality
- [Overfitting Handler](API/overfitting.md) - Overfitting detection and mitigation
- [Hyperparameter Tuning](API/hyperparameter_tuning.md) - Optimization strategies
- [Model Wrapper](API/model_wrapper.md) - Model interface
- [Preprocessors](API/preprocessors.md) - Data preprocessing
- [Utilities](API/utils.md) - Helper functions
- [Metrics](API/metrics.md) - Performance metrics

### 💡 **Examples**
- [Basic Usage](examples/basic_usage.md) - Simple examples to get started
- [Custom Models](examples/custom_models.md) - Adding your own models
- [Overfitting Mitigation](examples/overfitting_mitigation.md) - Handling overfitting
- [Production Deployment](examples/production_deployment.md) - Deploy to production

### 📋 **Guides**
- [Overfitting Detection](guides/overfitting_detection.md) - Understanding overfitting
- [Model Selection](guides/model_selection.md) - Choosing the right model
- [Feature Engineering](guides/feature_engineering.md) - Preparing your data
- [Performance Optimization](guides/performance_optimization.md) - Speed and efficiency

### 🔧 **Help & Support**
- [Troubleshooting](troubleshooting.md) - Common issues and solutions

## 🎯 **Quick Navigation**

### **New Users**
1. Start with [Installation](installation.md)
2. Follow [Quick Start](quickstart.md)
3. Try [Getting Started Tutorial](tutorials/getting_started.md)

### **Existing Users**
- Check [API Reference](api/) for detailed documentation
- Browse [Examples](examples/) for specific use cases
- Read [Guides](guides/) for conceptual understanding

### **Contributors**
- Read [Contributing Guide](contributing.md)
- Check [API Documentation](api/) for implementation details
- Review [Troubleshooting](troubleshooting.md) for common issues

## 🌟 **Key Features Documentation**

### **🧠 Overfitting Detection**
Our framework includes advanced overfitting detection capabilities:
- [Overfitting Detection Guide](guides/overfitting_detection.md)
- [API Reference](api/overfitting.md)
- [Examples](examples/overfitting_mitigation.md)

### **⚡ Hyperparameter Tuning**
Multiple optimization strategies for better performance:
- [Hyperparameter Tuning API](api/hyperparameter_tuning.md)
- [Tuning Examples](examples/hyperparameter_tuning.md)
- [Performance Optimization](guides/performance_optimization.md)

### **🎯 One-Line AutoML**
Complete ML pipeline with minimal code:
- [Quick Start Guide](quickstart.md)
- [Basic Usage Examples](examples/basic_usage.md)
- [User Guide](user-guide.md)

## 📊 **Documentation Quality**

This documentation follows best practices:
- ✅ **Step-by-step tutorials** with working code
- ✅ **Comprehensive API reference** with examples
- ✅ **Real-world examples** and use cases
- ✅ **Troubleshooting guides** for common issues
- ✅ **Performance benchmarks** and comparisons
- ✅ **Visual diagrams** and illustrations

## 🤝 **Community & Support**

- **GitHub Issues**: [Report bugs](https://github.com/nandarizkika/automl-framework/issues)
- **Discussions**: [Ask questions](https://github.com/nandarizkika/automl-framework/discussions)
- **Email**: nandarizky52@gmail.com

## 🔄 **Staying Updated**

- **Star the repo** to get notified of updates
- **Watch releases** for new features
- **Follow the changelog** for version updates

---

**Ready to get started?** → [Installation Guide](installation.md) → [Quick Start](quickstart.md)

**Need help?** → [Troubleshooting](troubleshooting.md) → [GitHub Discussions](https://github.com/nandarizkika/automl-framework/discussions)
