Japan Search Gallery Tools
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

``` sh
pip install jps_gallery_tools
```

## How to use

[See the
documentation](https://nakamura196.github.io/jps_gallery_tools/api.html)
for full details of the Japan Search Gallery API Client.

``` python
from jps_gallery_tools.api import JPSGalleryClient
gallery = JPSGalleryClient()
```

``` python
gallery.setMetadata('title', 'ja', '日本語タイトル')
gallery.setMetadata('summary', 'ja', '日本語の概要')
gallery.setMetadata("responsibility", "ja", "中村覚")
gallery.addTag("はじめてのタグ")
gallery.addTag("二つ目のタグ")
```

# トップ画像

``` python
original_url = "https://blogger.googleusercontent.com/img/a/AVvXsEiTjjaWkCHeCslxeKujaQotjuR_HvhOHen7Ql7rQV8nmQl4ivLRF_CSabMY-JLJHNL-xHMe3VDyA9F-iv1RtQ2jFTk1Vnjck-veKLUZPdYqCcjzHkc8SGKb1fyZ_x8W66aTrSXQ78UN3CnyBakwwmmH_hmPKeEsTzq8J3e2zzUMylmDjCZ0LClPByBRRw=s400"
thumbnail_url = "https://blogger.googleusercontent.com/img/a/AVvXsEiTjjaWkCHeCslxeKujaQotjuR_HvhOHen7Ql7rQV8nmQl4ivLRF_CSabMY-JLJHNL-xHMe3VDyA9F-iv1RtQ2jFTk1Vnjck-veKLUZPdYqCcjzHkc8SGKb1fyZ_x8W66aTrSXQ78UN3CnyBakwwmmH_hmPKeEsTzq8J3e2zzUMylmDjCZ0LClPByBRRw=s180-c"
title = "初日の出のキャラクター"
source = "いらすとや"
top_image = UrlImage(original_url, title, source, thumbnail_url)
gallery.setImage(top_image)
```

``` python
# part = ListPart("tile")
part = ListPart("tile")
part.setMetadata("title", "ja", "リストのタイトル")
part.setMetadata("title", "en", "List Title")
gallery.addPart(part)
```

``` python
# item = ListExternalLinkPart()
# item.setUrl("https://www.irasutoya.com/2021/11/blog-post_91.html")
# part.addPart(item)
```

``` python
# part.addPart(top_image)
item = ListExternalLinkPart()
part.addPart(item)
item.setMetadata("title", "ja", "外部リンクのタイトル")

item.setImage(top_image)
```

``` python
from pprint import pprint
pprint(gallery.export())
```

    {'curationType': 'GALLERY',
     'edit': {'action': 'CREATE',
              'date': 1675830770680,
              'orgId': 'jpsws',
              'userId': 'system'},
     'id': 'aaa',
     'image': {'contentsRightsType': 'various',
               'cover': None,
               'imgType': 'URL',
               'source': {'ja': 'いらすとや'},
               'sourceUrl': None,
               'thumbnailUrl': 'https://blogger.googleusercontent.com/img/a/AVvXsEiTjjaWkCHeCslxeKujaQotjuR_HvhOHen7Ql7rQV8nmQl4ivLRF_CSabMY-JLJHNL-xHMe3VDyA9F-iv1RtQ2jFTk1Vnjck-veKLUZPdYqCcjzHkc8SGKb1fyZ_x8W66aTrSXQ78UN3CnyBakwwmmH_hmPKeEsTzq8J3e2zzUMylmDjCZ0LClPByBRRw=s180-c',
               'title': {'ja': '初日の出のキャラクター'},
               'url': 'https://blogger.googleusercontent.com/img/a/AVvXsEiTjjaWkCHeCslxeKujaQotjuR_HvhOHen7Ql7rQV8nmQl4ivLRF_CSabMY-JLJHNL-xHMe3VDyA9F-iv1RtQ2jFTk1Vnjck-veKLUZPdYqCcjzHkc8SGKb1fyZ_x8W66aTrSXQ78UN3CnyBakwwmmH_hmPKeEsTzq8J3e2zzUMylmDjCZ0LClPByBRRw=s400'},
     'parts': [{'cpid': 'a',
                'parts': [{'cpid': 'a',
                           'image': {'contentsRightsType': 'various',
                                     'cover': None,
                                     'imgType': 'URL',
                                     'source': {'ja': 'いらすとや'},
                                     'sourceUrl': None,
                                     'thumbnailUrl': 'https://blogger.googleusercontent.com/img/a/AVvXsEiTjjaWkCHeCslxeKujaQotjuR_HvhOHen7Ql7rQV8nmQl4ivLRF_CSabMY-JLJHNL-xHMe3VDyA9F-iv1RtQ2jFTk1Vnjck-veKLUZPdYqCcjzHkc8SGKb1fyZ_x8W66aTrSXQ78UN3CnyBakwwmmH_hmPKeEsTzq8J3e2zzUMylmDjCZ0LClPByBRRw=s180-c',
                                     'title': {'ja': '初日の出のキャラクター'},
                                     'url': 'https://blogger.googleusercontent.com/img/a/AVvXsEiTjjaWkCHeCslxeKujaQotjuR_HvhOHen7Ql7rQV8nmQl4ivLRF_CSabMY-JLJHNL-xHMe3VDyA9F-iv1RtQ2jFTk1Vnjck-veKLUZPdYqCcjzHkc8SGKb1fyZ_x8W66aTrSXQ78UN3CnyBakwwmmH_hmPKeEsTzq8J3e2zzUMylmDjCZ0LClPByBRRw=s400'},
                           'title': {'ja': '外部リンクのタイトル'},
                           'type': 'jps-curation-list-external-link'}],
                'title': {'en': 'List Title', 'ja': 'リストのタイトル'},
                'type': 'jps-curation-list',
                'viewType': 'tile'}],
     'permission': {'level': 'ADMIN', 'publicationLevel': 'WORKSPACE'},
     'primaryTerm': 1,
     'responsibility': {'ja': '中村覚'},
     'rights': {},
     'rightsType': 'ccby',
     'seqNo': 0,
     'summary': {'ja': '日本語の概要'},
     'title': {'ja': '日本語タイトル'},
     'version': 1,
     'workspace': 'abc',
     'workspaceTags': ['はじめてのタグ', '二つ目のタグ']}

``` python
gallery.save("tmp/gallery.json")
```

``` python
b = gallery.encode()
print(b)
```

    eyJ2ZXJzaW9uIjogMSwgInNlcU5vIjogMCwgInByaW1hcnlUZXJtIjogMSwgInRpdGxlIjogeyJqYSI6ICJcdTY1ZTVcdTY3MmNcdThhOWVcdTMwYmZcdTMwYTRcdTMwYzhcdTMwZWIifSwgInN1bW1hcnkiOiB7ImphIjogIlx1NjVlNVx1NjcyY1x1OGE5ZVx1MzA2ZVx1Njk4Mlx1ODk4MSJ9LCAicmVzcG9uc2liaWxpdHkiOiB7ImphIjogIlx1NGUyZFx1Njc1MVx1ODk5YSJ9LCAid29ya3NwYWNlIjogImFiYyIsICJ3b3Jrc3BhY2VUYWdzIjogWyJcdTMwNmZcdTMwNThcdTMwODFcdTMwNjZcdTMwNmVcdTMwYmZcdTMwYjAiLCAiXHU0ZThjXHUzMDY0XHU3NmVlXHUzMDZlXHUzMGJmXHUzMGIwIl0sICJwZXJtaXNzaW9uIjogeyJwdWJsaWNhdGlvbkxldmVsIjogIldPUktTUEFDRSIsICJsZXZlbCI6ICJBRE1JTiJ9LCAiZWRpdCI6IHsidXNlcklkIjogInN5c3RlbSIsICJvcmdJZCI6ICJqcHN3cyIsICJkYXRlIjogMTY3NTgzMDc3MDY4MCwgImFjdGlvbiI6ICJDUkVBVEUifSwgInBhcnRzIjogW3siY3BpZCI6ICJhIiwgInR5cGUiOiAianBzLWN1cmF0aW9uLWxpc3QiLCAidmlld1R5cGUiOiAidGlsZSIsICJwYXJ0cyI6IFt7ImNwaWQiOiAiYSIsICJ0eXBlIjogImpwcy1jdXJhdGlvbi1saXN0LWV4dGVybmFsLWxpbmsiLCAidGl0bGUiOiB7ImphIjogIlx1NTkxNlx1OTBlOFx1MzBlYVx1MzBmM1x1MzBhZlx1MzA2ZVx1MzBiZlx1MzBhNFx1MzBjOFx1MzBlYiJ9LCAiaW1hZ2UiOiB7ImltZ1R5cGUiOiAiVVJMIiwgImNvdmVyIjogbnVsbCwgInNvdXJjZVVybCI6IG51bGwsICJ0aXRsZSI6IHsiamEiOiAiXHU1MjFkXHU2NWU1XHUzMDZlXHU1MWZhXHUzMDZlXHUzMGFkXHUzMGUzXHUzMGU5XHUzMGFmXHUzMGJmXHUzMGZjIn0sICJzb3VyY2UiOiB7ImphIjogIlx1MzA0NFx1MzA4OVx1MzA1OVx1MzA2OFx1MzA4NCJ9LCAiY29udGVudHNSaWdodHNUeXBlIjogInZhcmlvdXMiLCAidXJsIjogImh0dHBzOi8vYmxvZ2dlci5nb29nbGV1c2VyY29udGVudC5jb20vaW1nL2EvQVZ2WHNFaVRqamFXa0NIZUNzbHhlS3VqYVFvdGp1Ul9IdmhPSGVuN1FsN3JRVjhubVFsNGl2TFJGX0NTYWJNWS1KTEpITkwteEhNZTNWRHlBOUYtaXYxUnRRMmpGVGsxVm5qY2stdmVLTFVaUGRZcUNjanpIa2M4U0dLYjFmeVpfeDhXNjZhVHJTWFE3OFVOM0NueUJha3d3bW1IX2htUEtlRXNUenE4SjNlMnp6VU15bG1EakNaMExDbFBCeUJSUnc9czQwMCIsICJ0aHVtYm5haWxVcmwiOiAiaHR0cHM6Ly9ibG9nZ2VyLmdvb2dsZXVzZXJjb250ZW50LmNvbS9pbWcvYS9BVnZYc0VpVGpqYVdrQ0hlQ3NseGVLdWphUW90anVSX0h2aE9IZW43UWw3clFWOG5tUWw0aXZMUkZfQ1NhYk1ZLUpMSkhOTC14SE1lM1ZEeUE5Ri1pdjFSdFEyakZUazFWbmpjay12ZUtMVVpQZFlxQ2NqekhrYzhTR0tiMWZ5Wl94OFc2NmFUclNYUTc4VU4zQ255QmFrd3dtbUhfaG1QS2VFc1R6cThKM2UyenpVTXlsbURqQ1owTENsUEJ5QlJSdz1zMTgwLWMifX1dLCAidGl0bGUiOiB7ImphIjogIlx1MzBlYVx1MzBiOVx1MzBjOFx1MzA2ZVx1MzBiZlx1MzBhNFx1MzBjOFx1MzBlYiIsICJlbiI6ICJMaXN0IFRpdGxlIn19XSwgInJpZ2h0cyI6IHt9LCAicmlnaHRzVHlwZSI6ICJjY2J5IiwgImlkIjogImFhYSIsICJjdXJhdGlvblR5cGUiOiAiR0FMTEVSWSIsICJpbWFnZSI6IHsiaW1nVHlwZSI6ICJVUkwiLCAiY292ZXIiOiBudWxsLCAic291cmNlVXJsIjogbnVsbCwgInRpdGxlIjogeyJqYSI6ICJcdTUyMWRcdTY1ZTVcdTMwNmVcdTUxZmFcdTMwNmVcdTMwYWRcdTMwZTNcdTMwZTlcdTMwYWZcdTMwYmZcdTMwZmMifSwgInNvdXJjZSI6IHsiamEiOiAiXHUzMDQ0XHUzMDg5XHUzMDU5XHUzMDY4XHUzMDg0In0sICJjb250ZW50c1JpZ2h0c1R5cGUiOiAidmFyaW91cyIsICJ1cmwiOiAiaHR0cHM6Ly9ibG9nZ2VyLmdvb2dsZXVzZXJjb250ZW50LmNvbS9pbWcvYS9BVnZYc0VpVGpqYVdrQ0hlQ3NseGVLdWphUW90anVSX0h2aE9IZW43UWw3clFWOG5tUWw0aXZMUkZfQ1NhYk1ZLUpMSkhOTC14SE1lM1ZEeUE5Ri1pdjFSdFEyakZUazFWbmpjay12ZUtMVVpQZFlxQ2NqekhrYzhTR0tiMWZ5Wl94OFc2NmFUclNYUTc4VU4zQ255QmFrd3dtbUhfaG1QS2VFc1R6cThKM2UyenpVTXlsbURqQ1owTENsUEJ5QlJSdz1zNDAwIiwgInRodW1ibmFpbFVybCI6ICJodHRwczovL2Jsb2dnZXIuZ29vZ2xldXNlcmNvbnRlbnQuY29tL2ltZy9hL0FWdlhzRWlUamphV2tDSGVDc2x4ZUt1amFRb3RqdVJfSHZoT0hlbjdRbDdyUVY4bm1RbDRpdkxSRl9DU2FiTVktSkxKSE5MLXhITWUzVkR5QTlGLWl2MVJ0UTJqRlRrMVZuamNrLXZlS0xVWlBkWXFDY2p6SGtjOFNHS2IxZnlaX3g4VzY2YVRyU1hRNzhVTjNDbnlCYWt3d21tSF9obVBLZUVzVHpxOEozZTJ6elVNeWxtRGpDWjBMQ2xQQnlCUlJ3PXMxODAtYyJ9fQ==
