TITLE Mod file for component: Component(id=poisson_input type=SpikeSourcePoisson)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.8.1
         org.neuroml.model   v1.8.1
         jLEMS               v0.10.6

ENDCOMMENT

NEURON {
    POINT_PROCESS poisson_input
    RANGE start                             : parameter
    RANGE duration                          : parameter
    RANGE rate                              : parameter
    RANGE end                               : parameter
    RANGE LONG_TIME                         : parameter
    RANGE SMALL_TIME                        : parameter
    : Based on netstim.mod
    THREADSAFE : only true if every instance has its own distinct Random
    POINTER donotuse
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    start = 0 (ms)
    duration = 1000000000 (ms)
    rate = 10 (kHz)
    end = 1000000000 (ms)
    LONG_TIME = 3.59999998E15 (ms)
    SMALL_TIME = 1.0E-9 (ms)
}

ASSIGNED {
    isi (ms)                    : Not a state variable as far as Neuron's concerned...
    rate_tsince (ms/ms)
    rate_tnextUsed (ms/ms)
    rate_tnextIdeal (ms/ms)
    donotuse
}

STATE {
    tsince (ms) 
    tnextIdeal (ms) 
    tnextUsed (ms) 
    
}

INITIAL {
    rates()
    rates() ? To ensure correct initialisation.
    
    isi = start  - log(random_float(1))/  rate
    
    tsince = 0
    
    tnextIdeal = isi  + H(((  isi  ) - (  start  +  duration  ))/  duration  )*  LONG_TIME
    
    tnextUsed = tnextIdeal
    
    net_send(0, 1) : go to NET_RECEIVE block, flag 1, for initial state
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    
    
}

NET_RECEIVE(flag) {
    
    LOCAL weight
    
    
    if (flag == 1) { : Setting watch for top level OnCondition...
        WATCH (t >  tnextUsed) 1000
    }
    if (flag == 1000) {
    
        isi = -1 * log(random_float(1))/  rate
    
        tnextIdeal = (  tnextIdeal  +  isi  ) + H(((  tnextIdeal  +  isi  ) - (  start  +  duration  ))/  duration  )*  LONG_TIME
    
        tnextUsed = tnextIdeal  *H( (  tnextIdeal  -t)/t ) + (t+  SMALL_TIME  )*H( (t-  tnextIdeal  )/t )
    
        tsince = 0
    
        net_event(t)
        WATCH (t >  tnextUsed) 1000
    
    }
    
}

DERIVATIVE states {
    rates()
    tsince' = rate_tsince 
    tnextUsed' = rate_tnextUsed 
    tnextIdeal' = rate_tnextIdeal 
    
}

PROCEDURE rates() {
    
    rate_tsince = 1 ? Note units of all quantities used here need to be consistent!
    rate_tnextUsed = 0 ? Note units of all quantities used here need to be consistent!
    rate_tnextIdeal = 0 ? Note units of all quantities used here need to be consistent!
    
     
    
}


: Returns a float between 0 and max; implementation of random() as used in LEMS
FUNCTION random_float(max) {
    
    : This is not ideal, getting an exponential dist random number and then turning back to uniform
    : However this is the easiest what to ensure mod files with random methods fit into NEURON's
    : internal framework for managing internal number generation.
    random_float = exp(-1*erand())*max
    
}

:****************************************************
: Methods copied from netstim.mod in NEURON source

 
PROCEDURE seed(x) {
	set_seed(x)
}

VERBATIM
double nrn_random_pick(void* r);
void* nrn_random_arg(int argpos);
ENDVERBATIM


FUNCTION erand() {
VERBATIM
	if (_p_donotuse) {
		/*
		:Supports separate independent but reproducible streams for
		: each instance. However, the corresponding hoc Random
		: distribution MUST be set to Random.negexp(1)
		*/
		_lerand = nrn_random_pick(_p_donotuse);
	}else{
		/* only can be used in main thread */
		if (_nt != nrn_threads) {
           hoc_execerror("multithread random in NetStim"," only via hoc Random");
		}
ENDVERBATIM
		: the old standby. Cannot use if reproducible parallel sim
		: independent of nhost or which host this instance is on
		: is desired, since each instance on this cpu draws from
		: the same stream
		erand = exprand(1)
VERBATIM
	}
ENDVERBATIM
}

PROCEDURE noiseFromRandom() {
VERBATIM
 {
	void** pv = (void**)(&_p_donotuse);
	if (ifarg(1)) {
		*pv = nrn_random_arg(1);
	}else{
		*pv = (void*)0;
	}
 }
ENDVERBATIM
}

: End of methods copied from netstim.mod in NEURON source
:****************************************************


: The Heaviside step function
FUNCTION H(x) {
    
    if (x < 0) { H = 0 }
    else if (x > 0) { H = 1 }
    else { H = 0.5 }
    
}

