"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CargoBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const cdktf_local_exec_1 = require("cdktf-local-exec");
/**
 * Builds a binary using cargo inside a docker container.
 *
 * It is built to support https://github.com/awslabs/aws-lambda-rust-runtime
 *
 * @stability stable
 */
class CargoBuild extends cdktf_local_exec_1.LocalExec {
    /**
     * @stability stable
     */
    constructor(scope, name, options) {
        super(scope, name, options);
        throw new Error("Not implemented");
        // TODO: Implement this using docker action
        //     const platform = options.arch === "arm" ? "linux/arm64" : "linux/x86";
        //     const target =
        //       options.arch === "arm"
        //         ? "aarch64-unknown-linux-gnu"
        //         : "x86_64-unknown-linux-gnu";
        //     const command = `
        //     docker run --platform ${platform} \
        //   --rm --user "$(id -u)":"$(id -g)" \
        //   -v "${options.cwd}":/usr/src/myapp -w /usr/src/myapp rust:${RUST_VERSION} \
        //   cargo build -p lambda_runtime --example basic --release --target ${RUST_TARGET}
        //     cargo build --release -p ${options.projectName} --target ${target} && cp target/${target}/release/* binary`;
    }
    /**
     * @stability stable
     */
    get binary() {
        return path_1.resolve(this.cwd, "binary");
    }
}
exports.CargoBuild = CargoBuild;
_a = JSII_RTTI_SYMBOL_1;
CargoBuild[_a] = { fqn: "cdktf-local-build.CargoBuild", version: "0.0.18" };
//# sourceMappingURL=data:application/json;base64,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