"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogQueryWidget = void 0;
const cdk = require("@aws-cdk/core");
const widget_1 = require("./widget");
/**
 * Display query results from Logs Insights
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'table',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.REGION,
                    query: `${sources} | ${query}`,
                },
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
//# sourceMappingURL=data:application/json;base64,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