"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = exports.PeriodOverride = void 0;
const core_1 = require("@aws-cdk/core");
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
/**
 * Specify the period for graphs when the CloudWatch dashboard loads
 */
var PeriodOverride;
(function (PeriodOverride) {
    /**
     * Period of all graphs on the dashboard automatically adapt to the time range of the dashboard.
     */
    PeriodOverride["AUTO"] = "auto";
    /**
     * Period set for each graph will be used
     */
    PeriodOverride["INHERIT"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard
 */
class Dashboard extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dashboardName,
        });
        this.rows = [];
        {
            const { dashboardName } = props;
            if (dashboardName && !core_1.Token.isUnresolved(dashboardName) && !dashboardName.match(/^[\w-]+$/)) {
                throw new Error([
                    `The value ${dashboardName} for field dashboardName contains invalid characters.`,
                    'It can only contain alphanumerics, dash (-) and underscore (_).',
                ].join(' '));
            }
        }
        new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: this.physicalName,
            dashboardBody: core_1.Lazy.stringValue({ produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return core_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                } }),
        });
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     */
    addWidgets(...widgets) {
        if (widgets.length === 0) {
            return;
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
//# sourceMappingURL=data:application/json;base64,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