"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'can create a receipt filter'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.ReceiptFilter(stack, 'Filter', {
            ip: '1.2.3.4/16',
            receiptFilterName: 'MyFilter',
            policy: lib_1.ReceiptFilterPolicy.BLOCK,
        });
        // THEN
        assert_1.expect(stack).toMatch({
            'Resources': {
                'FilterC907D6DA': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '1.2.3.4/16',
                                'Policy': 'Block',
                            },
                            'Name': 'MyFilter',
                        },
                    },
                },
            },
        });
        test.done();
    },
    'can create a white list filter'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.WhiteListReceiptFilter(stack, 'WhiteList', {
            ips: [
                '10.0.0.0/16',
                '1.2.3.4',
            ],
        });
        // THEN
        assert_1.expect(stack).toMatch({
            'Resources': {
                'WhiteListBlockAllAE2CDDFF': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '0.0.0.0/0',
                                'Policy': 'Block',
                            },
                        },
                    },
                },
                'WhiteListAllow1000016F396A7F2': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '10.0.0.0/16',
                                'Policy': 'Allow',
                            },
                        },
                    },
                },
                'WhiteListAllow1234A4DDAD4E': {
                    'Type': 'AWS::SES::ReceiptFilter',
                    'Properties': {
                        'Filter': {
                            'IpFilter': {
                                'Cidr': '1.2.3.4',
                                'Policy': 'Allow',
                            },
                        },
                    },
                },
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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