from dataclasses import dataclass
import requests
import validators
from .APIPayload import APIPayload
from .APICredentials import APICredentials

@dataclass(order=False)
class APIPayment:
    """
        Transfermovil payment

        @:param url: app url
        @:param ssl_verify: verify ssl certificate

    """

    url: str
    ssl_verify: bool

    def charge(self,credential: APICredentials, payload: APIPayload) -> dict:
        if not validators.url(self.url):
            raise Exception("Incorrect url")
        if not isinstance(self.ssl_verify, bool):
            raise Exception("Incorrect ssl_verified")
        if not isinstance(credential, APICredentials):
            raise Exception("Incorrect credentials")
        if not isinstance(payload,APIPayload):
            raise Exception("Incorrect payload")



        response = requests.post(self.url,
                                 headers=credential.getheaders(),
                                 json=payload.getPayload(),
                                 verify=self.ssl_verify)

        if response.status_code != 200:
            return {'success': False, 'error': response.reason}
        else:
            json = response.json()

            if json['PayOrderResult']['Success'] != True:
                return {'success': False, 'error': json['PayOrderResult']['Resultmsg']}

            return {'success': True}






