# Taipy GUI

## License
Copyright 2023 Avaiga Private Limited

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
the License. You may obtain a copy of the License at
[http://www.apache.org/licenses/LICENSE-2.0](https://www.apache.org/licenses/LICENSE-2.0.txt)

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.

## Usage
- [License](#license)
- [Usage](#usage)
- [Taipy GUI](#what-is-taipy-gui)
- [Installation](#installation)
- [Contributing](#contributing)
- [Code of conduct](#code-of-conduct)
- [Directory Structure](#directory-structure)

## What is Taipy GUI

Taipy is a Python library for creating Business Applications. More information on our
[website](https://www.taipy.io). Taipy is split into multiple repositories including _taipy-gui_ to let users
install the minimum they need.

[Taipy GUI](https://github.com/Avaiga/taipy-gui) provides Python classes that make it easy to create powerful Web apps in minutes.

A more in depth documentation of taipy can be found [here](https://docs.taipy.io/).

## Installation

Want to install and try _Taipy GUI_? Check out our [`INSTALLATION.md`](INSTALLATION.md) file.

## Contributing

Want to help build _Taipy GUI_? Check out our [`CONTRIBUTING.md`](CONTRIBUTING.md) file.

## Code of conduct

Want to be part of the _Taipy GUI_ community? Check out our [`CODE_OF_CONDUCT.md`](CODE_OF_CONDUCT.md) file.

## Directory Structure

- `gui`: Graphical user interface related files;
- `src/taipy/gui`: Python source files;
- `tests/taipy/gui`: Unit tests;
- `tools`: Files used to document _taipy-gui_;
- `CODE_OF_CONDUCT.md`: Code of conduct for members and contributors of _taipy-gui_;
- `CONTRIBUTING.md`: Instructions to contribute to _taipy-gui_;
- `INSTALLATION.md`: Instructions to install _taipy-gui_;
- `LICENSE`: The Apache 2.0 License;
- `MANIFEST.in`: Build configuration file;
- `mypy.ini`: [mypy](http://mypy-lang.org/) linter configuration file;
- `Pipfile`: File used by the Pipenv virtual environment to manage project dependencies;
- `pyproject.toml`: Python build configuration file use for linters here;
- `pytest.ini`: [pytest](https://pytest.org/) configuration file;
- `README.md`: Current file;
- `setup.py`: The setup script managing building, distributing, and installing _taipy-gui_;
- `tox.ini`: Contains test scenarios to be run.
