from contextlib import AbstractContextManager
from queue import Queue
from typing import Any, Callable, Optional, Tuple, TypeVar

import beeline.propagation.honeycomb
from beeline.propagation import PropagationContext, Request
from beeline.trace import Span, SynchronousTracer, Tracer
from beeline.version import VERSION
from libhoney import Client, Response, Transmission

USER_AGENT_ADDITION: str = ...

_F = TypeVar("_F", bound=Callable[..., Any])

class Beeline:
    client: Client
    tracer_impl: Tracer
    presend_hook: Callable[[dict[str, Any]], None]
    sampler_hook: Callable[[dict[str, Any]], Tuple[bool, int]]
    http_trace_parser_hook: Callable[[Request], Optional[PropagationContext]]
    http_trace_propagation_hook: Callable[
        [PropagationContext], Optional[dict[str, str]]
    ]
    def __init__(
        self,
        writekey: str = ...,
        dataset: str = ...,
        service_name: str = ...,
        tracer: Optional[Tracer] = ...,
        sample_rate: int = ...,
        api_host: str = ...,
        max_concurrent_batches: int = ...,
        max_batch_size: int = ...,
        send_frequency: float = ...,
        block_on_send: bool = ...,
        block_on_response: bool = ...,
        transmission_impl: Transmission = ...,
        sampler_hook: Callable[[dict[str, Any]], Tuple[bool, int]] = ...,
        presend_hook: Callable[[dict[str, Any]], None] = ...,
        http_trace_parser_hook: Callable[[Request], Optional[PropagationContext]] = ...,
        http_trace_propagation_hook: Callable[
            [PropagationContext], Optional[dict[str, str]]
        ] = ...,
        debug: bool = ...,
    ) -> None: ...
    def add_field(self, name: str, value: str) -> None: ...
    def add(self, data: dict[str, Any]) -> None: ...
    def tracer(
        self, name: str, trace_id: Optional[str] = ..., parent_id: Optional[str] = ...
    ) -> AbstractContextManager[Span]: ...
    def send_all(self) -> None: ...
    def traced(
        self, name: str, trace_id: Optional[str] = ..., parent_id: Optional[str] = ...
    ) -> Callable[[_F], _F]: ...
    def traced_thread(self, fn: _F) -> _F: ...
    def log(self, msg: str, *args: Any, **kwargs: Any) -> None: ...
    def get_responses_queue(self) -> Queue[Response]: ...
    def close(self) -> None: ...

def init(
    writekey: str = ...,
    dataset: str = ...,
    service_name: str = ...,
    tracer: Optional[Tracer] = ...,
    sample_rate: int = ...,
    api_host: str = ...,
    max_concurrent_batches: int = ...,
    max_batch_size: int = ...,
    send_frequency: float = ...,
    block_on_send: bool = ...,
    block_on_response: bool = ...,
    transmission_impl: Transmission = ...,
    sampler_hook: Callable[[dict[str, Any]], Tuple[bool, int]] = ...,
    presend_hook: Callable[[dict[str, Any]], None] = ...,
    debug: bool = ...,
    http_trace_parser_hook: Callable[[Request], Optional[PropagationContext]] = ...,
    http_trace_propagation_hook: Callable[
        [PropagationContext], Optional[dict[str, str]]
    ] = ...,
) -> None: ...
def send_now(data: dict[str, Any]) -> None: ...
def add_context(data: dict[str, Any]) -> None: ...
def add_context_field(name: str, value: Any) -> None: ...
def remove_context_field(name: str) -> None: ...
def add_rollup_field(name: str, value: float) -> None: ...
def add_trace_field(name: str, value: Any) -> None: ...
def remove_trace_field(name: str) -> None: ...
def tracer(
    name: str, trace_id: Optional[str] = ..., parent_id: Optional[str] = ...
) -> AbstractContextManager[Span]: ...
def start_trace(
    context: Optional[dict[str, Any]] = ...,
    trace_id: Optional[str] = ...,
    parent_span_id: Optional[str] = ...,
) -> Optional[Span]: ...
def finish_trace(span: Span) -> None: ...
def start_span(
    context: Optional[dict[str, Any]] = ..., parent_id: str = ...
) -> Optional[Span]: ...
def finish_span(span: Span) -> None: ...
def propagate_and_start_trace(
    context: dict[str, Any], request: Request
) -> Optional[Span]: ...
def http_trace_parser_hook(headers: Request) -> Optional[PropagationContext]: ...
def http_trace_propagation_hook() -> Optional[dict[str, str]]: ...
def send_all() -> None: ...
def get_beeline() -> Beeline: ...
def get_responses_queue() -> Queue[Response]: ...
def close() -> None: ...
def traced(
    name: str, trace_id: Optional[str] = ..., parent_id: Optional[str] = ...
) -> Callable[[_F], _F]: ...
def traced_thread(fn: _F) -> _F: ...
