import { Component } from '../component';
import { Project } from '../project';
import { Dependabot, DependabotOptions } from './dependabot';
import { Mergify } from './mergify';
import { PullRequestTemplate } from './pr-template';
import { GithubWorkflow } from './workflows';
/**
 * @experimental
 */
export interface GitHubOptions {
    /**
     * (experimental) Whether mergify should be enabled on this repository or not.
     *
     * @default true
     * @experimental
     */
    readonly mergify?: boolean;
}
/**
 * @experimental
 */
export declare class GitHub extends Component {
    /**
     * (experimental) The `Mergify` configured on this repository.
     *
     * This is `undefined` if Mergify
     * was not enabled when creating the repository.
     *
     * @experimental
     */
    readonly mergify?: Mergify;
    /**
     * The .gitattributes file for this repository.
     */
    private readonly gitattributes;
    /**
     * @experimental
     */
    constructor(project: Project, options: GitHubOptions);
    /**
     * @experimental
     */
    addWorkflow(name: string): GithubWorkflow;
    /**
     * @experimental
     */
    addPullRequestTemplate(...content: string[]): PullRequestTemplate;
    /**
     * @experimental
     */
    addDependabot(options?: DependabotOptions): Dependabot;
    /**
     * (experimental) Marks the provided file(s) as being generated.
     *
     * This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     * @experimental
     */
    annotateGenerated(glob: string): void;
}
