/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort.io;

import java.util.Map;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.api.ShuffleMapOutputWriter;
import org.apache.spark.shuffle.api.SingleSpillShuffleMapOutputWriter;
import org.apache.spark.shuffle.sort.io.LocalDiskShuffleMapOutputWriter;
import org.apache.spark.shuffle.sort.io.LocalDiskSingleSpillMapOutputWriter;
import org.apache.spark.storage.BlockManager;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class LocalDiskShuffleExecutorComponents
implements ShuffleExecutorComponents {
    private final SparkConf sparkConf;
    private BlockManager blockManager;
    private IndexShuffleBlockResolver blockResolver;

    public LocalDiskShuffleExecutorComponents(SparkConf sparkConf) {
        this.sparkConf = sparkConf;
    }

    @VisibleForTesting
    public LocalDiskShuffleExecutorComponents(SparkConf sparkConf, BlockManager blockManager, IndexShuffleBlockResolver blockResolver) {
        this.sparkConf = sparkConf;
        this.blockManager = blockManager;
        this.blockResolver = blockResolver;
    }

    @Override
    public void initializeExecutor(String appId, String execId, Map<String, String> extraConfigs) {
        this.blockManager = SparkEnv.get().blockManager();
        if (this.blockManager == null) {
            throw new IllegalStateException("No blockManager available from the SparkEnv.");
        }
        this.blockResolver = new IndexShuffleBlockResolver(this.sparkConf, this.blockManager);
    }

    @Override
    public ShuffleMapOutputWriter createMapOutputWriter(int shuffleId, long mapTaskId, int numPartitions) {
        if (this.blockResolver == null) {
            throw new IllegalStateException("Executor components must be initialized before getting writers.");
        }
        return new LocalDiskShuffleMapOutputWriter(shuffleId, mapTaskId, numPartitions, this.blockResolver, this.sparkConf);
    }

    @Override
    public Optional<SingleSpillShuffleMapOutputWriter> createSingleFileMapOutputWriter(int shuffleId, long mapId) {
        if (this.blockResolver == null) {
            throw new IllegalStateException("Executor components must be initialized before getting writers.");
        }
        return Optional.of(new LocalDiskSingleSpillMapOutputWriter(shuffleId, mapId, this.blockResolver));
    }
}

